/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDPegasusBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.config.ingame.JSGConfigEnumEntry;
import dev.tauri.jsg.config.ingame.JSGEnumConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.multistructure.mergehelper.StargatePegasusMergeHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargatePegasusRendererState;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGuiUpdate;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargatePegasusSpinHelper;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolPegasusEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.dialhomedevice.DHDActivateButtonState;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateSpinState;
import dev.tauri.jsg.util.ILinkable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class StargatePegasusBaseBE
extends StargateClassicBaseBE
implements ILinkable<DHDPegasusBE> {
    private BlockPos linkedDHD = null;
    private BlockPos lastPos = BlockPos.f_121853_;
    protected List<SymbolPegasusEnum> toDialSymbols = new ArrayList<SymbolPegasusEnum>();
    protected Player lastSender;
    protected boolean continueDialing = false;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);

    public StargatePegasusBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_PEGASUS_BASE_BE.get(), pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.getLevelNotNull().f_46443_ && (this.stargateState.engaged() || this.stargateState.incoming() || this.stargateState.unstable())) {
            for (int i = 0; i < 36; ++i) {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, i, false);
            }
        }
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargatePegasusMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.resetToDialSymbols();
        this.clearDHDSymbols();
    }

    @Override
    public void failGate() {
        super.failGate();
        this.resetToDialSymbols();
        this.clearDHDSymbols();
    }

    @Override
    protected void dialingFailed(StargateOpenResult reason) {
        this.resetToDialSymbols();
        super.dialingFailed(reason);
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.continueDialing = false;
        this.m_6596_();
        if (this.stargateState == EnumStargateState.DIALING || this.stargateState == EnumStargateState.DIALING_COMPUTER || this.stargateState == EnumStargateState.IDLE) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
            this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
        }
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating, boolean noxDialing) {
        super.openGate(targetGatePos, isInitiating, noxDialing);
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().activateSymbol(SymbolPegasusEnum.BBB);
        }
    }

    @Override
    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
        }
    }

    @Override
    public void activateDHDBRB() {
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).activateSymbol((SymbolInterface)this.getSymbolType().getBRB());
        }
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        DHDPegasusBE dhd;
        super.setConfig(config);
        if (this.isLinked() && (dhd = this.getLinkedDevice()) != null) {
            DHDAbstractRendererState state = (DHDAbstractRendererState)dhd.getState(StateTypeEnum.RENDERER_STATE);
            state.gateConfig = this.getConfig();
            dhd.sendState(StateTypeEnum.RENDERER_STATE, state);
        }
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return SymbolTypeRegistry.PEGASUS;
    }

    @Override
    public StargateTypeEnum getStargateType() {
        return StargateTypeEnum.PEGASUS;
    }

    @Override
    protected int getMaxChevrons() {
        if (this.dialingWithoutEnergy) {
            return 9;
        }
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && this.getLinkedDevice() != null && !this.getLinkedDevice().hasUpgrade(DHDAbstractBE.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        this.addSymbolToAddress(symbol, true);
    }

    public void addSymbolToAddress(SymbolInterface symbol, boolean activateSymbol) {
        if (this.isLinkedAndDHDOperational() && this.getLinkedDevice() != null && activateSymbol) {
            this.getLinkedDevice().activateSymbol(symbol);
        }
        super.addSymbolToAddress(symbol);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        this.clearDHDSymbols();
        this.startIncomingAnimation(dialedAddressSize, 300);
        this.m_6596_();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        this.clearDHDSymbols();
        this.startIncomingAnimation(dialedAddressSize, time);
        this.m_6596_();
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        super.startIncomingAnimation(addressSize, period);
        this.incomingPeriod = (int)Math.round((double)(this.incomingPeriod * addressSize) / 36.0);
        this.m_6596_();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        block12: {
            block11: {
                super.lightUpChevronByIncoming(disableAnimation);
                if (this.incomingPeriod == -1) {
                    return;
                }
                if (disableAnimation) break block11;
                boolean spin = (Boolean)((JSGBooleanConfigOption)this.config.getOption("allowIncomingAnim")).getValue();
                int z = this.incomingLastChevronLightUp;
                if (z == 1 && spin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
                }
                if (z % 4 == 0 && z > 0) {
                    int chevron = z / 4;
                    int[] pattern = new int[]{1, 2, 3, 7, 8, 4, 5, 6, 9};
                    if (!this.stargateState.idle() && this.isIncoming) {
                        if (chevron >= 9) {
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                            this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                            this.resetIncomingAnimation();
                            this.m_6596_();
                            return;
                        }
                        if (pattern[chevron - 1] < this.incomingAddressSize) {
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, pattern[chevron - 1] + 9, false);
                            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
                        }
                    } else {
                        this.isIncoming = false;
                        this.stargateState = EnumStargateState.IDLE;
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CLEAR_CHEVRONS, 10));
                        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                        this.resetIncomingAnimation();
                        this.m_6596_();
                        return;
                    }
                }
                if (spin) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, z, false);
                    break block12;
                } else if (z == 1) {
                    for (int i = 0; i < 36; ++i) {
                        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, i, false);
                    }
                }
                break block12;
            }
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, this.incomingAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.resetIncomingAnimation();
            this.m_6596_();
        }
        this.m_6596_();
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        if (this.isLinked() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
            this.getLinkedDevice().setLinkedDevice(null);
            this.setLinkedDevice(null);
        }
    }

    @Override
    public void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    @Nullable
    public DHDPegasusBE getLinkedDevice() {
        if (this.linkedDHD == null) {
            return null;
        }
        if (this.m_58904_() == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.linkedDHD);
        if (blockEntity instanceof DHDPegasusBE) {
            DHDPegasusBE dhd = (DHDPegasusBE)blockEntity;
            return dhd;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getLinkedPos() {
        return this.linkedDHD;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDPegasusBE dhdTile = this.getLinkedDevice();
        if (dhdTile == null) {
            return false;
        }
        return dhdTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDevice(BlockPos dhdPos) {
        this.linkedDHD = dhdPos;
        this.m_6596_();
    }

    @Override
    public void updateLinkStatus() {
        BlockEntity blockEntity;
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.world, this.pos, LinkingHelper.getDhdRange(), (Block)BlockRegistry.DHD_PEGASUS.get());
        if (closestDhd != null && (blockEntity = this.world.m_7702_(closestDhd)) instanceof DHDPegasusBE) {
            DHDPegasusBE dhd = (DHDPegasusBE)blockEntity;
            dhd.setLinkedDevice(this.pos);
            this.setLinkedDevice(closestDhd);
            this.m_6596_();
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        if (this.isLinked(true)) {
            compound.m_128356_("linkedDHD", this.linkedDHD.m_121878_());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128441_("linkedDHD")) {
            this.linkedDHD = BlockPos.m_122022_((long)compound.m_128454_("linkedDHD"));
        }
        super.m_142466_(compound);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> SoundPositionedEnum.PEGASUS_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> SoundPositionedEnum.PEGASUS_RING_ROLL_START;
        };
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEventEnum.GATE_PEGASUS_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEventEnum.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEventEnum.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEventEnum.GATE_PEGASUS_DIAL_FAILED;
            case StargateSoundEventEnum.INCOMING -> SoundEventEnum.GATE_PEGASUS_INCOMING;
            case StargateSoundEventEnum.CHEVRON_OPEN, StargateSoundEventEnum.CHEVRON_SHUT -> SoundEventEnum.GATE_PEGASUS_CHEVRON_OPEN;
            default -> null;
        };
    }

    public void resetToDialSymbols() {
        this.toDialSymbols.clear();
    }

    @Override
    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        return this.dialedAddress.size() < this.getMaxChevrons();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.world.f_46443_ && !this.toDialSymbols.isEmpty() && this.world.m_46467_() - this.lastSpinFinishedIn > (long)(this.continueDialing ? 2 : 10) && this.stargateState.idle()) {
            if (this.toDialSymbols.get(0) == SymbolPegasusEnum.BBB || this.canAddSymbolInternal(this.toDialSymbols.get(0))) {
                this.addSymbolToAddressByList(this.toDialSymbols.get(0));
            }
            if (!this.toDialSymbols.isEmpty()) {
                this.toDialSymbols.remove(0);
            }
            this.m_6596_();
        }
        if (!this.lastPos.equals((Object)this.pos)) {
            this.lastPos = this.pos;
            this.updateLinkStatus();
            this.m_6596_();
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected StargatePegasusRendererState.StargatePegasusRendererStateBuilder getRendererStateServer() {
        return (StargatePegasusRendererState.StargatePegasusRendererStateBuilder)new StargatePegasusRendererState.StargatePegasusRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargatePegasusRendererState();
    }

    @Override
    public StargatePegasusRendererState getRendererStateClient() {
        return (StargatePegasusRendererState)super.getRendererStateClient();
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return switch (stateType) {
            case StateTypeEnum.RENDERER_STATE -> new StargatePegasusRendererState();
            case StateTypeEnum.DHD_ACTIVATE_BUTTON -> new DHDActivateButtonState();
            case StateTypeEnum.GUI_UPDATE -> new StargateContainerGuiUpdate();
            case StateTypeEnum.BIOME_OVERRIDE_STATE -> new StargateBiomeOverrideState();
            default -> super.createState(stateType);
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null) {
            switch (stateType) {
                case RENDERER_UPDATE: {
                    StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                    switch (gateActionState.action) {
                        case CHEVRON_OPEN: {
                            this.getRendererStateClient().openChevron(this.world.m_46467_());
                            break;
                        }
                        case CHEVRON_CLOSE: {
                            this.getRendererStateClient().closeChevron(this.world.m_46467_());
                            break;
                        }
                        case CLEAR_CHEVRONS: {
                            this.getRendererStateClient().clearChevrons(this.world.m_46467_());
                            return;
                        }
                        case ACTIVATE_GLYPH: {
                            int slot = ((StargateRendererActionState)state).chevronCount;
                            slot = 36 - (slot - 9);
                            if (slot > 36) {
                                slot -= 36;
                            }
                            if (slot < 0) {
                                slot += 36;
                            }
                            if (this.getRendererStateClient() == null) break;
                            this.getRendererStateClient().setGlyphAtSlot(slot, slot);
                            break;
                        }
                        case CHEVRON_ACTIVATE: {
                            this.getRendererStateClient().spinHelper.setIsSpinning(false);
                            if (((StargateRendererActionState)state).chevronCount > 9) break;
                            ChevronEnum chevron = gateActionState.modifyFinal ? ChevronEnum.getFinal() : this.getRendererStateClient().chevronTextureList.getNextChevron();
                            this.getRendererStateClient().lockChevron(this.getRendererStateClient().spinHelper.getTargetSymbol().getId(), chevron);
                            break;
                        }
                    }
                    break;
                }
                case SPIN_STATE: {
                    StargateSpinState spinState = (StargateSpinState)state;
                    if (spinState.setOnly) {
                        this.getRendererStateClient().spinHelper.setIsSpinning(false);
                        ((StargatePegasusSpinHelper)this.getRendererStateClient().spinHelper).setTargetSymbol(spinState.targetSymbol);
                    }
                    if (this.getRendererStateClient().chevronTextureList.getNextChevron().rotationIndex != 1) break;
                    this.getRendererStateClient().slotToGlyphMap.clear();
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    protected long getSpinStartOffset() {
        return this.slotFromChevron(this.getRendererStateClient().chevronTextureList.getCurrentChevron());
    }

    public int slotFromChevron(ChevronEnum chevron) {
        return (new int[]{9, 5, 1, 33, 29, 25, 21, 17, 13})[chevron.rotationIndex];
    }

    @Override
    public StargateOpenResult attemptOpenAndFail() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        }
        this.continueDialing = false;
        this.m_6596_();
        return super.attemptOpenAndFail();
    }

    @Override
    public boolean abortDialingSequence() {
        if (super.abortDialingSequence()) {
            this.toDialSymbols.clear();
            this.m_6596_();
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddSymbol(SymbolInterface symbol) {
        if (this.dialedAddress.size() >= this.getMaxChevrons()) {
            return false;
        }
        return super.canAddSymbol(symbol);
    }

    public boolean canAddSymbolToList(SymbolInterface symbol) {
        int size = this.toDialSymbols.size();
        for (SymbolPegasusEnum s : this.toDialSymbols) {
            if (!s.brb()) continue;
            --size;
        }
        if (this.dialedAddress.size() + size + (this.stargateState.dialing() ? 1 : 0) >= this.getMaxChevrons()) {
            return false;
        }
        if (this.toDialSymbols.contains((SymbolPegasusEnum)symbol)) {
            return false;
        }
        return super.canAddSymbol(symbol);
    }

    @Override
    public boolean dialAddress(StargateAddress address, int symbolCount, boolean withoutEnergy, EnumDialingType dialingType) {
        if (!this.getStargateState().idle()) {
            return false;
        }
        super.dialAddress(address, symbolCount, withoutEnergy, dialingType);
        for (int i = 0; i < symbolCount; ++i) {
            this.addSymbolToAddressDHD(address.get(i));
        }
        if (!address.contains((SymbolInterface)this.getSymbolType().getOrigin())) {
            this.addSymbolToAddressDHD((SymbolInterface)this.getSymbolType().getOrigin());
        }
        this.addSymbolToAddressDHD((SymbolInterface)this.getSymbolType().getBRB());
        return true;
    }

    public void addSymbolToAddressDHD(SymbolInterface targetSymbol, Player sender) {
        this.lastSender = sender;
        this.addSymbolToAddressDHD(targetSymbol);
        this.m_6596_();
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface targetSymbol) {
        DHDPegasusBE dhd;
        if (targetSymbol != SymbolPegasusEnum.BBB && !this.canAddSymbolToList(targetSymbol)) {
            return;
        }
        if (!(targetSymbol instanceof SymbolPegasusEnum)) {
            return;
        }
        if (this.toDialSymbols.contains(targetSymbol)) {
            return;
        }
        if (this.isNoxDialing) {
            if (targetSymbol == this.getSymbolType().getBRB()) {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_NOX));
                return;
            }
            this.stargateState = EnumStargateState.DIALING;
            this.m_6596_();
            this.addSymbolToAddress(targetSymbol);
            this.doIncomingAnimation(1, false);
            if (this.stargateWillLock(targetSymbol)) {
                this.isFinalActive = true;
                this.m_6596_();
            }
            return;
        }
        if (this.isLinkedAndDHDOperational() && (targetSymbol != SymbolPegasusEnum.BBB || !this.toDialSymbols.isEmpty()) && (dhd = this.getLinkedDevice()) != null) {
            ((DHDAbstractBE)dhd).activateSymbol(targetSymbol);
        }
        this.toDialSymbols.add((SymbolPegasusEnum)targetSymbol);
    }

    public void addSymbolToAddressByList(SymbolInterface targetSymbol) {
        float distance;
        int indexDiff;
        EnumSpinDirection counterDirection;
        ChevronEnum currentChevron;
        this.lastSpinFinishedIn = 0L;
        if (targetSymbol.brb()) {
            Player player;
            StargateOpenResult openResult = this.attemptOpenAndFail();
            if (openResult == StargateOpenResult.NOT_ENOUGH_POWER && this.lastSender != null && (player = this.lastSender) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_milkyway.not_enough_power"), true);
            }
            this.continueDialing = false;
            this.m_6596_();
            return;
        }
        int dialAnim = ((JSGConfigEnumEntry)((JSGEnumConfigOption)this.getConfig().getOption((String)"pegDialAnim")).getValue()).value;
        boolean fastDial = this.isFastDialing || dialAnim == 1;
        boolean canContinueByConfig = !fastDial && dialAnim == 0;
        this.stargateState = EnumStargateState.DIALING;
        this.targetRingSymbol = targetSymbol;
        this.spinDirection = this.spinDirection.opposite();
        if (fastDial) {
            this.continueDialing = false;
            this.m_6596_();
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, EnumSpinDirection.CLOCKWISE, true, 0)), this.targetPoint);
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 5 + new Random().nextInt(5)));
            this.doIncomingAnimation(10, true);
            return;
        }
        ChevronEnum targetChevron = this.stargateWillLock(targetSymbol, true) ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
        ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
        if (this.stargateWillLock(targetSymbol, true) && this.dialedAddress.size() == 6) {
            currentChevron = ChevronEnum.C6;
        }
        EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
        if (this.spinDirection == counterDirection) {
            indexDiff = 36 - Math.abs(indexDiff);
        }
        if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
            distance += 36.0f;
        }
        int duration = (int)(distance / this.getSpeedFactor());
        this.doIncomingAnimation(duration, true, targetSymbol);
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
        this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
        this.addTask(this.lastSpinFinished);
        if (!this.continueDialing) {
            this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
        }
        int toDialSize = this.toDialSymbols.size();
        if (this.toDialSymbols.contains(SymbolPegasusEnum.BBB)) {
            --toDialSize;
        }
        this.continueDialing = canContinueByConfig && toDialSize >= 2 && targetChevron != ChevronEnum.getFinal();
        this.m_6596_();
        this.isSpinning = true;
        this.spinStartTime = this.world.m_46467_();
        this.ringSpinContext = null;
        this.m_6596_();
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        boolean moveOnly;
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        this.targetRingSymbol = targetSymbol;
        boolean bl = moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        if (moveOnly) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 0));
            this.doIncomingAnimation(10, true);
        } else {
            float distance;
            int indexDiff;
            EnumSpinDirection counterDirection;
            ChevronEnum currentChevron;
            this.spinDirection = this.spinDirection.opposite();
            ChevronEnum targetChevron = targetSymbol.origin() ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
            ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
            if (targetSymbol.origin() && this.dialedAddress.size() == 6) {
                currentChevron = ChevronEnum.C6;
            }
            EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
            if (this.spinDirection == counterDirection) {
                indexDiff = 36 - Math.abs(indexDiff);
            }
            if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
                distance += 36.0f;
            }
            int duration = (int)(distance / this.getSpeedFactor());
            this.doIncomingAnimation(duration, true, this.targetRingSymbol);
            JSG.logger.debug("addSymbolToAddressManual: current:{}, target:{}, direction:{}, distance:{}, duration:{}, moveOnly:{}", new Object[]{this.currentRingSymbol, targetSymbol, this.spinDirection, Float.valueOf(distance), duration, false});
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
            this.addTask(this.lastSpinFinished);
            this.addTask(new ScheduledTask(EnumScheduledTask.GATE_RING_ROLL, 15));
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, true);
            this.isSpinning = true;
            this.spinStartTime = this.world.m_46467_();
            this.ringSpinContext = context;
            if (context != null) {
                this.sendSignal("stargate_spin_start", new Object[]{this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName()});
            }
        }
        this.m_6596_();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        boolean onlySpin = false;
        if (customData != null && customData.m_128441_("onlySpin")) {
            onlySpin = customData.m_128471_("onlySpin");
        }
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.m_6596_();
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (!onlySpin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 0));
                } else {
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.m_6596_();
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                if (!this.continueDialing) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                }
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol, this.stargateState == EnumStargateState.DIALING_COMPUTER);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 0));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 60));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 0));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, this.stargateWillLock(this.targetRingSymbol));
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 1));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 1));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.stargateState = EnumStargateState.IDLE;
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
            case STARGATE_CLEAR_CHEVRONS: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            }
        }
        super.executeTask(scheduledTask, customData);
    }
}

