/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.multistructure.mergehelper.StargateOrlinMergeHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.renderer.stargate.StargateOrlinRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateOrlinSparkState;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StargateOrlinBaseBE
extends StargateAbstractBaseBE {
    public CompoundTag notebookPageTag = null;
    private final SmallEnergyStorage energyStorage = new SmallEnergyStorage();
    public boolean canNotGenerate = false;
    private int openCount = 0;
    private boolean isPowered;
    private int sparkIndex;

    public StargateAddress getAddressFromPageNBT() {
        if (this.notebookPageTag == null) {
            return this.setUpRandomGate();
        }
        if (!this.notebookPageTag.m_128441_("address")) {
            return this.setUpRandomGate();
        }
        CompoundTag address = this.notebookPageTag.m_128469_("address");
        return new StargateAddress(address);
    }

    private StargateAddress setUpRandomGate() {
        Pair<StargatePos, StargateAddress> gate = StargateNetwork.INSTANCE.getRandomAddress(this.getLevelNotNull().m_213780_(), SymbolTypeRegistry.MILKYWAY, StargateTypeEnum.MILKYWAY, gatePos -> {
            StargateAbstractBaseBE be = gatePos.getBlockEntity();
            if (be == null) {
                return false;
            }
            return be.isMerged();
        });
        if (gate == null) {
            return null;
        }
        CompoundTag tag = ((StargateAddress)gate.second()).serializeNBT();
        if (this.notebookPageTag == null) {
            this.notebookPageTag = new CompoundTag();
        }
        this.notebookPageTag.m_128365_("address", (Tag)tag);
        return (StargateAddress)gate.second();
    }

    public StargateOrlinBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_ORLIN_BASE_BE.get(), pos, state);
    }

    @Nullable
    public EnergyRequiredToOperate getEnergyRequiredToDial() {
        StargateAddress addressToDial = this.getAddressFromPageNBT();
        if (addressToDial == null) {
            return new EnergyRequiredToOperate(0, 0);
        }
        StargatePos sgPos = StargateNetwork.INSTANCE.getStargate(addressToDial);
        if (sgPos == null) {
            return null;
        }
        return this.getEnergyRequiredToDial(sgPos);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateOrlinMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected JSGAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return new JSGAxisAlignedBB(-1.0, 0.6, -0.15, 1.0, 2.7, -0.05);
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public StargateTypeEnum getStargateType() {
        return StargateTypeEnum.ORLIN;
    }

    @Override
    @Nullable
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return null;
    }

    @Override
    @Nullable
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEventEnum.GATE_MILKYWAY_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEventEnum.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEventEnum.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEventEnum.GATE_ORLIN_FAIL;
            case StargateSoundEventEnum.GATE_BROKE -> SoundEventEnum.GATE_ORLIN_BROKE;
            default -> null;
        };
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.m_58899_().m_7494_();
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return EnumSet.of(BiomeOverlayEnum.NORMAL);
    }

    @Override
    protected JSGAxisAlignedBB getHorizonKillingBox(boolean server) {
        return new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 1.5);
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return 2;
    }

    @Override
    protected List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return Collections.singletonList(new JSGAxisAlignedBB(-0.5, 1.0, -0.5, 0.5, 2.0, 0.5));
    }

    @Override
    protected StargateOrlinRendererState createRendererStateClient() {
        return new StargateOrlinRendererState();
    }

    @Override
    public StargateOrlinRendererState getRendererStateClient() {
        return (StargateOrlinRendererState)super.getRendererStateClient();
    }

    public void addDrops(List<ItemStack> drops) {
        if (this.openCount >= (Integer)JSGConfig.Stargate.stargateOrlinMaxOpenCount.get()) {
            Random rand = new Random();
            drops.add(new ItemStack((ItemLike)Items.f_42416_, 2 + rand.nextInt(3)));
        } else {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("openCount", this.openCount);
            if (this.notebookPageTag != null) {
                compound.m_128365_("notebook_page", (Tag)this.notebookPageTag);
            }
            ItemStack stack = new ItemStack((ItemLike)BlockRegistry.STARGATE_ORLIN_BASE_BLOCK.get());
            stack.m_41751_(compound);
            drops.add(stack);
        }
    }

    public void initializeFromItemStack(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41784_();
            if (compound.m_128441_("openCount")) {
                this.openCount = compound.m_128451_("openCount");
            }
            if (compound.m_128441_("notebook_page")) {
                this.notebookPageTag = compound.m_128469_("notebook_page");
            }
        }
    }

    @Override
    public StargateOrlinMergeHelper getMergeHelper() {
        return (StargateOrlinMergeHelper)super.getMergeHelper();
    }

    public boolean isBroken() {
        if (this.openCount >= (Integer)JSGConfig.Stargate.stargateOrlinMaxOpenCount.get()) {
            return true;
        }
        return this.getMergeHelper().getMaxOpenCount() >= (Integer)JSGConfig.Stargate.stargateOrlinMaxOpenCount.get();
    }

    @Override
    protected SmallEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.SPARK_STATE) {
            return new StargateOrlinSparkState();
        }
        return super.createState(stateType);
    }

    public void startSparks() {
        this.sparkIndex = 0;
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_SPARK, 5));
    }

    public void redstonePowerUpdate(boolean power) {
        if (!this.isMerged()) {
            return;
        }
        if (this.isPowered && !power || !this.isPowered && power) {
            this.isPowered = power;
            if (this.isPowered && this.stargateState.idle() && !this.isBroken()) {
                this.beginOpening();
            } else if (!this.isPowered && this.stargateState.initiating()) {
                this.attemptClose(StargateClosedReasonEnum.REQUESTED);
            }
            this.m_6596_();
        }
    }

    public void updateDialedAddress() {
        StargateAddress addressToDial = this.getAddressFromPageNBT();
        this.dialedAddress.clear();
        if (addressToDial == null) {
            return;
        }
        StargateAddressDynamic address = new StargateAddressDynamic(addressToDial);
        List<SymbolInterface> addressNeeded = address.subList(0, 6);
        addressNeeded.add((SymbolInterface)this.getSymbolType().getOrigin());
        this.dialedAddress.addAll(addressNeeded);
        this.m_6596_();
    }

    public void beginOpening() {
        if (this.f_58857_ == null || this.f_58857_.m_46472_() != Level.f_46428_) {
            JSGSoundHelper.playSoundEvent(this.f_58857_, this.getGateCenterPos(), SoundEventEnum.GATE_ORLIN_FAIL);
            return;
        }
        if (this.isBroken()) {
            return;
        }
        this.updateDialedAddress();
        StargateOpenResult status = this.checkAddressAndEnergy(this.dialedAddress);
        switch (status) {
            case OK: {
                this.stargateState = EnumStargateState.DIALING;
                this.startSparks();
                JSGSoundHelper.playSoundEvent(this.world, this.getGateCenterPos(), SoundEventEnum.GATE_ORLIN_DIAL);
                StargatePos targetGatePos = StargateNetwork.INSTANCE.getStargate(this.dialedAddress);
                if (targetGatePos != null && targetGatePos.getBlockEntity() != null && this.hasEnergyToDial(targetGatePos)) {
                    targetGatePos.getBlockEntity().incomingWormhole(7);
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_OPEN));
                return;
            }
            case ADDRESS_MALFORMED: {
                JSG.logger.error("Orlin's gate: wrong dialed address");
                JSG.logger.error(this.dialedAddress.toString());
                break;
            }
            case NOT_ENOUGH_POWER: 
            case ABORTED: 
            case ABORTED_BY_EVENT: 
            case CALLER_HUNG_UP: {
                JSG.logger.error("Orlin's gate: error while dialing: {}", (Object)status.name());
                JSG.logger.error(this.dialedAddress.toString());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType == StateTypeEnum.SPARK_STATE) {
            if (this.getRendererStateClient() == null) {
                return;
            }
            StargateOrlinSparkState sparkState = (StargateOrlinSparkState)state;
            this.getRendererStateClient().sparkFrom(sparkState.sparkIndex, sparkState.spartStart);
        } else {
            super.setState(stateType, state);
        }
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        switch (scheduledTask) {
            case STARGATE_ORLIN_OPEN: {
                this.attemptOpenAndFail();
                ++this.openCount;
                this.m_6596_();
                break;
            }
            case STARGATE_ORLIN_SPARK: {
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.SPARK_STATE, new StargateOrlinSparkState(this.sparkIndex, this.world.m_46467_())), this.targetPoint);
                if (this.sparkIndex < 6 && this.sparkIndex != -1) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ORLIN_SPARK, 24));
                }
                ++this.sparkIndex;
                break;
            }
            case STARGATE_FAILED_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
                break;
            }
            case STARGATE_ORLIN_BROKE_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.GATE_BROKE);
                break;
            }
            default: {
                super.executeTask(scheduledTask, customData);
            }
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128379_("isPowered", this.isPowered);
        compound.m_128405_("openCount", this.openCount);
        compound.m_128379_("canNotGenerate", this.canNotGenerate);
        if (this.notebookPageTag != null) {
            compound.m_128365_("notebook_page", (Tag)this.notebookPageTag);
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        this.isPowered = compound.m_128471_("isPowered");
        this.openCount = compound.m_128451_("openCount");
        this.canNotGenerate = compound.m_128471_("canNotGenerate");
        if (compound.m_128441_("notebook_page")) {
            this.notebookPageTag = compound.m_128469_("notebook_page");
        }
        super.m_142466_(compound);
    }

    @Override
    protected EnergyRequiredToOperate getEnergyRequiredToDial(StargatePos targetGatePos) {
        return super.getEnergyRequiredToDial(targetGatePos).mul((Double)JSGConfig.Stargate.stargateOrlinEnergyMul.get()).cap((Integer)JSGConfig.Stargate.stargateEnergyStorage.get() / 4 - 1000000);
    }
}

