/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDMilkyWayBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.config.ingame.JSGBooleanConfigOption;
import dev.tauri.jsg.config.ingame.JSGConfigEnumEntry;
import dev.tauri.jsg.config.ingame.JSGEnumConfigOption;
import dev.tauri.jsg.config.ingame.JSGTileEntityConfig;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.multistructure.mergehelper.StargateMilkyWayMergeHelper;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolMilkyWayEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.util.ILinkable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateMilkyWayBaseBE
extends StargateClassicBaseBE
implements ILinkable<DHDMilkyWayBE> {
    protected List<SymbolMilkyWayEnum> toDialSymbols = new ArrayList<SymbolMilkyWayEnum>();
    private BlockPos linkedDHD = null;
    private BlockPos lastPos = BlockPos.f_121853_;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);

    public StargateMilkyWayBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public StargateMilkyWayBaseBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.STARGATE_MILKYWAY_BASE_BE.get(), pos, state);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateMilkyWayMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).clearSymbols();
        }
    }

    @Override
    public void failGate() {
        super.failGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).clearSymbols();
        }
    }

    @Override
    public boolean abortDialingSequence() {
        if (super.abortDialingSequence()) {
            this.toDialSymbols.clear();
            this.m_6596_();
            return true;
        }
        return false;
    }

    @Override
    protected void dialingFailed(StargateOpenResult reason) {
        this.resetToDialSymbols();
        super.dialingFailed(reason);
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating, boolean noxDialing) {
        super.openGate(targetGatePos, isInitiating, noxDialing);
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).activateSymbol(SymbolMilkyWayEnum.BRB);
        }
    }

    @Override
    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).clearSymbols();
        }
    }

    @Override
    public void activateDHDBRB() {
        if (this.isLinkedAndDHDOperational()) {
            Objects.requireNonNull(this.getLinkedDevice()).activateSymbol((SymbolInterface)this.getSymbolType().getBRB());
        }
    }

    @Override
    public void setConfig(JSGTileEntityConfig config) {
        DHDMilkyWayBE dhd;
        super.setConfig(config);
        if (this.isLinked() && (dhd = this.getLinkedDevice()) != null) {
            DHDAbstractRendererState state = (DHDAbstractRendererState)dhd.getState(StateTypeEnum.RENDERER_STATE);
            state.gateConfig = this.getConfig();
            dhd.sendState(StateTypeEnum.RENDERER_STATE, state);
        }
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public StargateTypeEnum getStargateType() {
        return StargateTypeEnum.MILKYWAY;
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface symbol) {
        this.stargateState = EnumStargateState.DIALING;
        this.m_6596_();
        if (symbol.brb()) {
            this.attemptOpenAndFail();
            this.m_6596_();
            return;
        }
        this.addSymbolToAddress(symbol);
        this.doIncomingAnimation(this.isNoxDialing ? 1 : 10, false);
        int plusTime = new Random().nextInt(5);
        if (!this.isNoxDialing) {
            if (this.stargateWillLock(symbol)) {
                this.isFinalActive = true;
                if (((Boolean)((JSGBooleanConfigOption)this.config.getOption("dhdLockPoO")).getValue()).booleanValue()) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 5 + plusTime));
                } else {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10 + plusTime));
                }
            } else {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10 + plusTime));
            }
        }
        this.m_6596_();
    }

    @Override
    protected int getMaxChevrons() {
        if (this.dialingWithoutEnergy || this.isNoxDialing) {
            return 9;
        }
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && this.getLinkedDevice() != null && !this.getLinkedDevice().hasUpgrade(DHDAbstractBE.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public boolean dialAddress(StargateAddress address, int symbolCount, boolean withoutEnergy, EnumDialingType dialingType) {
        if (!this.getStargateState().idle()) {
            return false;
        }
        super.dialAddress(address, symbolCount, withoutEnergy, dialingType);
        for (int i = 0; i < symbolCount; ++i) {
            this.addSymbolToAddressUsingList(address.get(i));
        }
        if (!address.contains((SymbolInterface)this.getSymbolType().getOrigin())) {
            this.addSymbolToAddressUsingList((SymbolInterface)this.getSymbolType().getOrigin());
        }
        this.addSymbolToAddressUsingList((SymbolInterface)this.getSymbolType().getBRB());
        return true;
    }

    public void resetToDialSymbols() {
        this.toDialSymbols.clear();
    }

    public boolean canAddSymbolToList(SymbolInterface symbol) {
        int size = this.toDialSymbols.size();
        for (SymbolMilkyWayEnum s : this.toDialSymbols) {
            if (!s.brb()) continue;
            --size;
        }
        if (this.dialedAddress.size() + size + (this.stargateState.dialing() && !this.isNoxDialing ? 1 : 0) >= this.getMaxChevrons()) {
            return false;
        }
        if (this.toDialSymbols.contains((SymbolMilkyWayEnum)symbol)) {
            return false;
        }
        return super.canAddSymbol(symbol);
    }

    public void addSymbolToAddressUsingList(SymbolInterface targetSymbol) {
        if (targetSymbol != SymbolMilkyWayEnum.BRB && !this.canAddSymbolToList(targetSymbol)) {
            return;
        }
        if (!(targetSymbol instanceof SymbolMilkyWayEnum)) {
            return;
        }
        if (this.isNoxDialing) {
            this.addSymbolToAddressByNox(targetSymbol);
            return;
        }
        if (this.toDialSymbols.contains(targetSymbol)) {
            return;
        }
        this.toDialSymbols.add((SymbolMilkyWayEnum)targetSymbol);
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        super.addSymbolToAddress(symbol);
        DHDMilkyWayBE dhd = this.getLinkedDevice();
        if (this.isLinkedAndDHDOperational() && dhd != null) {
            ((DHDAbstractBE)dhd).activateSymbol(symbol);
        }
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @javax.annotation.Nullable Object context) {
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        super.addSymbolToAddressManual(targetSymbol, context);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, 400);
        this.m_6596_();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
        }
        this.startIncomingAnimation(dialedAddressSize, time);
        this.m_6596_();
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        super.startIncomingAnimation(addressSize, period);
        this.incomingPeriod -= (int)Math.round(20.0 / (double)addressSize);
        if (((Boolean)((JSGBooleanConfigOption)this.config.getOption("allowIncomingAnim")).getValue()).booleanValue() && this.incomingPeriod > 9) {
            this.spinRing(1, false, true, this.incomingPeriod * addressSize);
        }
        this.m_6596_();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        super.lightUpChevronByIncoming(disableAnimation);
        if (this.incomingPeriod == -1) {
            return;
        }
        if (!disableAnimation) {
            if (this.stargateState.idle()) {
                this.stargateState = EnumStargateState.IDLE;
                this.m_6596_();
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
                this.resetIncomingAnimation();
                this.m_6596_();
                return;
            }
            if (this.incomingLastChevronLightUp >= this.incomingAddressSize) {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 1));
                this.resetIncomingAnimation();
                this.m_6596_();
                return;
            }
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, this.incomingLastChevronLightUp + 9, false);
        } else {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, this.incomingAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.resetIncomingAnimation();
            this.m_6596_();
        }
        this.m_6596_();
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        if (this.isLinked() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
            this.getLinkedDevice().setLinkedDevice(null);
            this.setLinkedDevice(null);
        }
    }

    @Override
    public void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    @javax.annotation.Nullable
    public DHDMilkyWayBE getLinkedDevice() {
        if (this.linkedDHD == null || this.m_58904_() == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.linkedDHD);
        if (blockEntity instanceof DHDMilkyWayBE) {
            DHDMilkyWayBE dhd = (DHDMilkyWayBE)blockEntity;
            return dhd;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getLinkedPos() {
        return this.linkedDHD;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDMilkyWayBE dhdMilkyWayTile = this.getLinkedDevice();
        return dhdMilkyWayTile != null && dhdMilkyWayTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDevice(BlockPos dhdPos) {
        this.linkedDHD = dhdPos;
        this.m_6596_();
    }

    @Override
    public void updateLinkStatus() {
        if (!this.isMerged()) {
            return;
        }
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.getLevelNotNull(), this.pos, LinkingHelper.getDhdRange(), (Block)BlockRegistry.DHD_MILKYWAY.get());
        if (closestDhd != null) {
            DHDMilkyWayBE dhdMilkyWayTile = (DHDMilkyWayBE)this.getLevelNotNull().m_7702_(closestDhd);
            if (dhdMilkyWayTile == null) {
                return;
            }
            dhdMilkyWayTile.setLinkedDevice(this.pos);
            this.setLinkedDevice(closestDhd);
            this.m_6596_();
        }
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        if (this.isLinked(true)) {
            compound.m_128356_("linkedDHD", this.linkedDHD.m_121878_());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128441_("linkedDHD")) {
            this.linkedDHD = BlockPos.m_122022_((long)compound.m_128454_("linkedDHD"));
        }
        super.m_142466_(compound);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> SoundPositionedEnum.MILKYWAY_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> SoundPositionedEnum.MILKYWAY_RING_ROLL_START;
        };
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEventEnum.GATE_MILKYWAY_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEventEnum.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEventEnum.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> {
                if (this.stargateState.dialingComputer()) {
                    yield SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED_COMPUTER;
                }
                yield SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED;
            }
            case StargateSoundEventEnum.INCOMING -> SoundEventEnum.GATE_MILKYWAY_INCOMING;
            case StargateSoundEventEnum.CHEVRON_OPEN -> SoundEventEnum.GATE_MILKYWAY_CHEVRON_OPEN;
            case StargateSoundEventEnum.CHEVRON_SHUT -> SoundEventEnum.GATE_MILKYWAY_CHEVRON_SHUT;
            default -> null;
        };
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getLevelNotNull().f_46443_) {
            if (!this.toDialSymbols.isEmpty() && this.getTime() - this.lastSpinFinishedIn > 5L && this.stargateState.idle()) {
                if (this.toDialSymbols.get(0) == SymbolMilkyWayEnum.BRB || this.canAddSymbolInternal(this.toDialSymbols.get(0))) {
                    if (this.isFastDialing || this.toDialSymbols.get(0) == SymbolMilkyWayEnum.BRB) {
                        this.addSymbolToAddressDHD(this.toDialSymbols.get(0));
                    } else {
                        this.addSymbolToAddressManual(this.toDialSymbols.get(0), null);
                    }
                }
                if (!this.toDialSymbols.isEmpty()) {
                    this.toDialSymbols.remove(0);
                }
                this.m_6596_();
            }
            if (!this.lastPos.equals((Object)this.pos)) {
                this.lastPos = this.pos;
                this.updateLinkStatus();
                this.m_6596_();
            }
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder getRendererStateServer() {
        return (StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder)new StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargateMilkyWayRendererState();
    }

    @Override
    public StargateMilkyWayRendererState getRendererStateClient() {
        return (StargateMilkyWayRendererState)super.getRendererStateClient();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null && stateType == StateTypeEnum.RENDERER_UPDATE) {
            StargateRendererActionState gateActionState = (StargateRendererActionState)state;
            switch (gateActionState.action) {
                case CHEVRON_OPEN: {
                    this.getRendererStateClient().openChevron(this.getTime());
                    break;
                }
                case CHEVRON_CLOSE: {
                    this.getRendererStateClient().closeChevron(this.getTime());
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        boolean onlySpin = false;
        if (customData != null && customData.m_128441_("onlySpin")) {
            onlySpin = customData.m_128471_("onlySpin");
        }
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.m_6596_();
                if (!this.isNoxDialing) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                }
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (!onlySpin) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 7));
                } else if (this.stargateState.dialingComputer()) {
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.m_6596_();
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateWillLock(this.targetRingSymbol)) {
                        if (this.checkAddressAndEnergy(this.dialedAddress).ok()) {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 13));
                            break;
                        }
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                        break;
                    }
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 3));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                    return;
                }
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                } else {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE_BOTH, 0, false);
                }
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateState.incoming() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                    if (this.stargateState.dialingDHD()) {
                        this.stargateState = EnumStargateState.IDLE;
                    }
                    this.m_6596_();
                    return;
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 10));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_DIM, 0, false);
                this.stargateState = EnumStargateState.IDLE;
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public int getOriginId() {
        return StargateMilkyWayBaseBE.getOriginId(this.getBiomeOverlayWithOverride(true), this.getFakeWorld(), this.getConfig().has("MWoriginModel") ? ((JSGConfigEnumEntry)((JSGEnumConfigOption)this.getConfig().getOption((String)"MWoriginModel")).getValue()).value : -1);
    }
}

