/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.integration.ComputerDeviceHolder;
import dev.tauri.jsg.integration.ComputerDeviceProvider;
import dev.tauri.jsg.item.CartridgeItem;
import dev.tauri.jsg.item.notebook.PageNotebookItemEmpty;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.loader.OriginsLoader;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.machine.PrinterRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.stargate.network.IAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.util.ITickable;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrinterBE
extends BlockEntity
implements ITickable,
ComputerDeviceProvider,
StateProviderInterface {
    public ItemStack inputPages = ItemStack.f_41583_;
    public final LinkedList<ItemStack> outputPages = new LinkedList();
    public List<ItemStack> cartridges = new ArrayList<ItemStack>();
    public long printStarted;
    public int editPos;
    public int originId;
    public int originPos;
    public StargateAddressDynamic address;
    public final List<Integer> symbolsToPrint = new ArrayList<Integer>();
    public LinkedList<Component> printCustomText = null;
    public String titleOverride = null;
    public static final double PRINTING_TIME = (double)115.54f;
    public ComputerDeviceHolder computerDeviceHolder;
    public PrinterRendererState rendererState = new PrinterRendererState();
    protected PacketDistributor.TargetPoint targetPoint;
    private long lastActivated;

    public PrinterBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.PRINTER.get(), pPos, pBlockState);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.createDeviceHolder();
        }
    }

    public boolean noInk() {
        if (this.cartridges.size() < 4) {
            return true;
        }
        return this.cartridges.stream().anyMatch(c -> PrinterBE.getInkStatus(c) < (double)((CartridgeItem)c.m_41720_()).inkPerPage);
    }

    public static double getInkStatus(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 1.0;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("inkStatus")) {
            return 1.0;
        }
        return tag.m_128459_("inkStatus");
    }

    public void shrinkInk() {
        this.cartridges.forEach(c -> {
            CompoundTag tag = c.m_41784_();
            tag.m_128347_("inkStatus", PrinterBE.getInkStatus(c) - (double)((CartridgeItem)c.m_41720_()).inkPerPage);
            c.m_41751_(tag);
        });
        this.m_6596_();
    }

    public Map<Color, Pair<Double, Boolean>> getInkStatus() {
        HashMap<Color, Pair<Double, Boolean>> map = new HashMap<Color, Pair<Double, Boolean>>();
        this.cartridges.forEach(c -> {
            double amount = PrinterBE.getInkStatus(c);
            CartridgeItem item = (CartridgeItem)c.m_41720_();
            map.put(item.renderColor, Pair.of((Object)amount, (Object)(amount >= (double)item.inkPerPage ? 1 : 0)));
        });
        return map;
    }

    public Map<Color, Double> getInkStatusAmountOnly() {
        HashMap<Color, Double> map = new HashMap<Color, Double>();
        this.cartridges.forEach(c -> {
            double amount = PrinterBE.getInkStatus(c);
            Color color = ((CartridgeItem)c.m_41720_()).renderColor;
            map.put(color, amount);
        });
        return map;
    }

    public ItemStack getNextEmptyAndRemove() {
        List<ItemStack> empties = this.cartridges.stream().filter(c -> {
            if (!c.m_41782_()) {
                return false;
            }
            CompoundTag tag = c.m_41784_();
            CartridgeItem item = (CartridgeItem)c.m_41720_();
            return tag.m_128459_("inkStatus") < (double)item.inkPerPage;
        }).toList();
        if (empties.isEmpty()) {
            return null;
        }
        ItemStack stack = empties.get(0);
        this.cartridges.remove(stack);
        this.m_6596_();
        this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
        return stack;
    }

    public boolean tryInsertCartridge(ItemStack stack) {
        if (this.cartridges.size() >= 4) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof CartridgeItem)) {
            return false;
        }
        CartridgeItem cartridgeItem = (CartridgeItem)item;
        if (this.cartridges.stream().anyMatch(c -> stack.m_41720_() == c.m_41720_())) {
            return false;
        }
        if (PrinterBE.getInkStatus(stack) < (double)cartridgeItem.inkPerPage) {
            return false;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.cartridges.add(copy);
        stack.m_41774_(1);
        this.m_6596_();
        this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
        return true;
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.targetPoint == null) {
                this.targetPoint = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            }
            if (this.address == null) {
                this.switchAddressType(SymbolTypeRegistry.MILKYWAY);
            }
            if (this.printStarted > 0L && (double)(this.f_58857_.m_46467_() - this.printStarted) > (double)115.54f) {
                this.printStarted = 0L;
                this.inputPages.m_41774_(1);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                JSGSoundHelper.playPositionedSound(this.f_58857_, this.m_58899_(), SoundPositionedEnum.PRINTER_PRINTING, false);
                this.sendSignal("printer_print_done", new Object[0]);
            }
        }
    }

    public void switchAddressType(SymbolTypeEnum<?> symbolTypeEnum) {
        this.address = new StargateAddressDynamic(symbolTypeEnum);
        this.symbolsToPrint.clear();
        for (int i = 0; i < 8; ++i) {
            this.address.addSymbol((SymbolInterface)symbolTypeEnum.getFirstValidForAddress());
            this.symbolsToPrint.add(i + 1);
        }
        this.symbolsToPrint.add(9);
        this.address.addSymbol((SymbolInterface)symbolTypeEnum.getOrigin());
        this.m_6596_();
        this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
    }

    protected void createOutputAndPrint() {
        CompoundTag nbt;
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack outputPage = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get(), 1);
        if (this.printCustomText == null) {
            nbt = PageNotebookItemFilled.getCompoundFromAddress((IAddress)this.address, this.symbolsToPrint, PageNotebookItemFilled.getRegistryPathFromWorld(this.f_58857_, this.m_58899_()), this.originId, NotebookPageSerialization.STARGATES);
        } else {
            nbt = new CompoundTag();
            CompoundTag customText = new CompoundTag();
            ListTag lines = new ListTag();
            for (Component line : this.printCustomText) {
                CompoundTag lineTag = new CompoundTag();
                lineTag.m_128359_("component", Component.Serializer.m_130703_((Component)line));
                lines.add((Object)lineTag);
            }
            customText.m_128365_("lines", (Tag)lines);
            nbt.m_128365_("customText", (Tag)customText);
            this.printCustomText = null;
            if (this.titleOverride != null) {
                PageNotebookItemFilled.setName(nbt, this.titleOverride);
                this.titleOverride = null;
            }
        }
        outputPage.m_41751_(nbt);
        this.printStarted = this.f_58857_.m_46467_();
        this.outputPages.addLast(outputPage);
        this.shrinkInk();
        this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
        JSGSoundHelper.playPositionedSound(this.f_58857_, this.m_58899_(), SoundPositionedEnum.PRINTER_PRINTING, true);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.targetPoint = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
            this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
        } else {
            this.requestState(StateTypeEnum.RENDERER_UPDATE);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_183515_(CompoundTag compound) {
        int i;
        super.m_183515_(compound);
        compound.m_128365_("inputItem", (Tag)this.inputPages.m_41739_(new CompoundTag()));
        int size = this.outputPages.size();
        compound.m_128405_("outputPagesSize", size);
        for (i = 0; i < size; ++i) {
            compound.m_128365_("outputItem" + i, (Tag)this.outputPages.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128356_("printStarted", this.printStarted);
        compound.m_128408_("symbolsToPrint", this.symbolsToPrint);
        compound.m_128405_("originId", this.originId);
        compound.m_128405_("originPos", this.originPos);
        if (this.address != null) {
            compound.m_128365_("address", (Tag)this.address.serializeNBT());
        }
        compound.m_128405_("inksCount", this.cartridges.size());
        i = 0;
        for (ItemStack cartridge : this.cartridges) {
            compound.m_128365_("cartridge" + i, (Tag)cartridge.m_41739_(new CompoundTag()));
            ++i;
        }
    }

    @ParametersAreNonnullByDefault
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cartridges.clear();
        this.outputPages.clear();
        this.inputPages = ItemStack.m_41712_((CompoundTag)compound.m_128469_("inputItem"));
        int size = compound.m_128451_("outputPagesSize");
        for (int i = 0; i < size; ++i) {
            this.outputPages.addLast(ItemStack.m_41712_((CompoundTag)compound.m_128469_("outputItem" + i)));
        }
        this.printStarted = compound.m_128454_("printStarted");
        int[] array = compound.m_128465_("symbolsToPrint");
        this.symbolsToPrint.clear();
        for (int s : array) {
            this.symbolsToPrint.add(s);
        }
        this.originId = compound.m_128451_("originId");
        this.originPos = compound.m_128451_("originPos");
        if (compound.m_128441_("address")) {
            this.address = new StargateAddressDynamic(compound.m_128469_("address"));
        }
        int inksCount = compound.m_128451_("inksCount");
        for (int i = 0; i < inksCount; ++i) {
            this.cartridges.add(ItemStack.m_41712_((CompoundTag)compound.m_128469_("cartridge" + i)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        LazyOptional<T> computerCaps = this.getDeviceHolder().getOrCreateDeviceBasedOnCap(capability);
        if (computerCaps.isPresent()) {
            return computerCaps;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String getDeviceType() {
        return "PRINTER";
    }

    public void createDeviceHolder() {
        this.computerDeviceHolder = new ComputerDeviceHolder(this);
    }

    @Override
    public ComputerDeviceHolder getDeviceHolder() {
        if (this.computerDeviceHolder == null) {
            this.createDeviceHolder();
        }
        return this.computerDeviceHolder;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            this.rendererState.addressDynamic = this.address;
            this.rendererState.output = this.outputPages;
            this.rendererState.input = this.inputPages;
            this.rendererState.pos = this.editPos;
            this.rendererState.printStarted = this.printStarted;
            this.rendererState.symbolsToPrint.clear();
            this.rendererState.symbolsToPrint.addAll(this.symbolsToPrint);
            this.rendererState.originId = this.originId;
            this.rendererState.cartridges = this.cartridges;
            return this.rendererState;
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            return new PrinterRendererState();
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType == StateTypeEnum.RENDERER_UPDATE) {
            this.outputPages.clear();
            this.rendererState = (PrinterRendererState)state;
            this.inputPages = this.rendererState.input;
            this.outputPages.addAll(this.rendererState.output);
            this.editPos = this.rendererState.pos;
            this.printStarted = this.rendererState.printStarted;
            this.address = this.rendererState.addressDynamic;
            this.symbolsToPrint.clear();
            this.symbolsToPrint.addAll(this.rendererState.symbolsToPrint);
            this.originId = this.rendererState.originId;
            this.cartridges = this.rendererState.cartridges;
            this.m_6596_();
        }
    }

    @Override
    public void sendState(StateTypeEnum type, State state) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), type, state), this.targetPoint);
        } else {
            JSG.logger.debug("targetPoint was null trying to send {} from {}", (Object)type, (Object)this.getClass().getCanonicalName());
        }
    }

    public void buttonClick(int button, ServerPlayer player) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_46467_() - this.lastActivated < 5L) {
            return;
        }
        this.lastActivated = this.f_58857_.m_46467_();
        if (this.printStarted > 0L) {
            player.m_5661_((Component)Component.m_237115_((String)"block.jsg.printer.busy"), true);
            return;
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (button == 0) {
            ++this.editPos;
            this.editPos %= 9;
            if (player.m_6047_()) {
                this.editPos = 0;
                this.switchAddressType(SymbolTypeRegistry.getNext(this.address.getSymbolType(), false));
            }
        } else if (button == 1) {
            if (player.m_6047_()) {
                if (this.symbolsToPrint.contains(this.editPos + 1)) {
                    this.symbolsToPrint.removeIf(i -> i == this.editPos + 1);
                } else {
                    this.symbolsToPrint.add(this.editPos + 1);
                }
            } else if (this.editPos == 8) {
                List<Integer> origins = OriginsLoader.getAllOrigins();
                ++this.originPos;
                this.originPos %= origins.size();
                this.originId = origins.get(this.originPos);
            } else {
                SymbolInterface symbol = this.address.get(this.editPos);
                SymbolInterface next = symbol.getNext(false);
                this.address.set(this.editPos, next);
            }
        } else if (button == 2) {
            if (player.m_6047_()) {
                if (this.symbolsToPrint.contains(this.editPos + 1)) {
                    this.symbolsToPrint.removeIf(i -> i == this.editPos + 1);
                } else {
                    this.symbolsToPrint.add(this.editPos + 1);
                }
            } else if (this.editPos == 8) {
                List<Integer> origins = OriginsLoader.getAllOrigins();
                --this.originPos;
                if (this.originPos < 0) {
                    this.originPos = origins.size() - 1;
                }
                this.originId = origins.get(this.originPos);
            } else {
                SymbolInterface symbol = this.address.get(this.editPos);
                SymbolInterface prev = symbol.getNext(true);
                this.address.set(this.editPos, prev);
            }
        } else if (button == 3) {
            if (this.inputPages.m_41619_()) {
                player.m_5661_((Component)Component.m_237115_((String)"block.jsg.printer.empty_input"), true);
                return;
            }
            if (this.outputPages.size() >= 10) {
                player.m_5661_((Component)Component.m_237115_((String)"block.jsg.printer.full_output"), true);
                return;
            }
            if (this.noInk()) {
                Map<Color, Pair<Double, Boolean>> status = this.getInkStatus();
                for (Map.Entry<Color, Pair<Double, Boolean>> c : status.entrySet()) {
                    if (((Boolean)c.getValue().second()).booleanValue()) continue;
                    String color = "magenta";
                    if (c.getKey() == Color.BLACK) {
                        color = "black";
                    } else if (c.getKey() == Color.YELLOW) {
                        color = "yellow";
                    } else if (c.getKey() == Color.CYAN) {
                        color = "cyan";
                    }
                    player.m_5661_((Component)Component.m_237115_((String)("block.jsg.printer.no_ink." + color)), true);
                    return;
                }
                player.m_5661_((Component)Component.m_237115_((String)"block.jsg.printer.no_ink.general"), true);
                return;
            }
            this.createOutputAndPrint();
            return;
        }
        this.m_6596_();
        this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
    }

    public ItemStack insertPage(ItemStack notebookPage, boolean simulate, boolean shift) {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        if (this.printStarted > 0L) {
            return ItemStack.f_41583_;
        }
        if (this.f_58857_.m_46467_() - this.lastActivated < 5L) {
            return ItemStack.f_41583_;
        }
        this.lastActivated = this.f_58857_.m_46467_();
        ItemStack stack = ItemStack.f_41583_;
        if (!shift || notebookPage != null && notebookPage.m_41720_() == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get()) {
            if (notebookPage == null || notebookPage.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!(notebookPage.m_41720_() instanceof PageNotebookItemEmpty)) {
                return ItemStack.f_41583_;
            }
            int size = Math.min(10 - this.inputPages.m_41613_(), Math.min(notebookPage.m_41613_(), shift ? 64 : 1));
            if (size <= 0) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                if (this.inputPages.m_41619_()) {
                    this.inputPages = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_EMPTY.get(), size);
                } else {
                    this.inputPages.m_41769_(size);
                }
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            }
            notebookPage.m_41774_(size);
        } else {
            if (notebookPage != null && !notebookPage.m_41619_()) {
                return ItemStack.f_41583_;
            }
            stack = this.inputPages.m_41777_();
            stack.m_41764_(1);
            if (!simulate) {
                this.inputPages.m_41774_(1);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            }
        }
        return stack;
    }

    @Nullable
    public ItemStack takePage(boolean simulate) {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        if (this.printStarted > 0L) {
            return ItemStack.f_41583_;
        }
        if (this.f_58857_.m_46467_() - this.lastActivated < 5L) {
            return ItemStack.f_41583_;
        }
        if ((double)(this.f_58857_.m_46467_() - this.printStarted) < (double)115.54f) {
            return ItemStack.f_41583_;
        }
        this.lastActivated = this.f_58857_.m_46467_();
        if (this.outputPages.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.outputPages.getLast();
        if (!simulate) {
            this.outputPages.removeLast();
            this.m_6596_();
            this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
        }
        return stack;
    }

    public Object[] buttonClickPC(int button, boolean shift) {
        return this.buttonClickPC(button, shift, null);
    }

    /*
     * WARNING - void declaration
     */
    public Object[] buttonClickPC(int button, boolean shift, @Nullable List<String> customTexts) {
        if (this.f_58857_ == null) {
            return new Object[]{false, "level_null", "Level is null!"};
        }
        if (this.printStarted > 0L) {
            return new Object[]{false, "printer_busy", "Printer is busy!"};
        }
        if (button == 0) {
            ++this.editPos;
            this.editPos %= 9;
            if (shift) {
                this.editPos = 0;
                this.switchAddressType(SymbolTypeRegistry.getNext(this.address.getSymbolType(), false));
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                return new Object[]{true, "symbol_type_switched", "Symbol type switched!"};
            }
            this.m_6596_();
            this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            return new Object[]{true, "edit_pos_moved", "Edit position moved!"};
        }
        if (button == 1) {
            if (shift) {
                if (this.symbolsToPrint.contains(this.editPos + 1)) {
                    this.symbolsToPrint.removeIf(i -> i == this.editPos + 1);
                    this.m_6596_();
                    this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                    return new Object[]{true, "symbol_disabled", "Symbol disabled!"};
                }
                this.symbolsToPrint.add(this.editPos + 1);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                return new Object[]{true, "symbol_enabled", "Symbol enabled!"};
            }
            if (this.editPos == 8) {
                List<Integer> origins = OriginsLoader.getAllOrigins();
                ++this.originPos;
                this.originPos %= origins.size();
                this.originId = origins.get(this.originPos);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                return new Object[]{true, "origin_changed_up", "Origin type changed up!"};
            }
            SymbolInterface symbol = this.address.get(this.editPos);
            SymbolInterface next = symbol.getNext(false);
            this.address.set(this.editPos, next);
            this.m_6596_();
            this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            return new Object[]{true, "symbol_changed_up", "Symbol changed up!"};
        }
        if (button == 2) {
            if (shift) {
                if (this.symbolsToPrint.contains(this.editPos + 1)) {
                    this.symbolsToPrint.removeIf(i -> i == this.editPos + 1);
                    this.m_6596_();
                    this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                    return new Object[]{true, "symbol_disabled", "Symbol disabled!"};
                }
                this.symbolsToPrint.add(this.editPos + 1);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                return new Object[]{true, "symbol_enabled", "Symbol enabled!"};
            }
            if (this.editPos == 8) {
                List<Integer> origins = OriginsLoader.getAllOrigins();
                --this.originPos;
                if (this.originPos < 0) {
                    this.originPos = origins.size() - 1;
                }
                this.originId = origins.get(this.originPos);
                this.m_6596_();
                this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
                return new Object[]{true, "origin_changed_down", "Origin type changed down!"};
            }
            SymbolInterface symbol = this.address.get(this.editPos);
            SymbolInterface prev = symbol.getNext(true);
            this.address.set(this.editPos, prev);
            this.m_6596_();
            this.getAndSendState(StateTypeEnum.RENDERER_UPDATE);
            return new Object[]{true, "symbol_changed_down", "Symbol changed down!"};
        }
        if (button == 3) {
            if (this.inputPages.m_41619_()) {
                return new Object[]{false, "print_error_no_page", "Input for pages is empty!"};
            }
            if (this.outputPages.size() >= 10) {
                return new Object[]{false, "print_error_full_output", "Output for pages in full!"};
            }
            if (this.noInk()) {
                Map<Color, Pair<Double, Boolean>> status = this.getInkStatus();
                for (Map.Entry<Color, Pair<Double, Boolean>> entry : status.entrySet()) {
                    if (((Boolean)entry.getValue().second()).booleanValue()) continue;
                    String color = "magenta";
                    if (entry.getKey() == Color.BLACK) {
                        color = "black";
                    } else if (entry.getKey() == Color.YELLOW) {
                        color = "yellow";
                    } else if (entry.getKey() == Color.CYAN) {
                        color = "cyan";
                    }
                    return new Object[]{false, "print_error_no_ink", "Not enough " + color + "!"};
                }
                return new Object[]{false, "print_error_no_ink", "Some cartridges are missing!"};
            }
            if (customTexts != null) {
                this.printCustomText = new LinkedList();
                int i2 = 0;
                for (String string : customTexts) {
                    void var6_15;
                    if (++i2 == 1) {
                        this.titleOverride = string;
                        continue;
                    }
                    if (!(string.startsWith("{") || string.startsWith("[") || string.startsWith("\""))) {
                        String string2 = "\"" + string + "\"";
                    }
                    MutableComponent line = var6_15.startsWith("\"") ? Component.m_237113_((String)var6_15.substring(1, var6_15.length() - 1)) : Component.Serializer.m_130701_((String)var6_15);
                    this.printCustomText.addLast((Component)line);
                }
                if (customTexts.size() == 1) {
                    this.printCustomText = null;
                }
            }
            this.createOutputAndPrint();
            return new Object[]{true, "print_started", "Printing..."};
        }
        return new Object[]{true, "printer_error_input_malformed", "Wrong input!"};
    }
}

