/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BeeDungeonProcessor
extends StructureProcessor {
    public static final Codec<BeeDungeonProcessor> CODEC = Codec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        RandomSource random;
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.f_74675_())) {
            return structureBlockInfoWorld;
        }
        BlockState blockState = structureBlockInfoWorld.f_74676_();
        BlockPos worldPos = structureBlockInfoWorld.f_74675_();
        CompoundTag nbt = structureBlockInfoWorld.f_74677_();
        if (blockState.m_60713_(Blocks.f_50677_)) {
            CompoundTag compoundTag = structureBlockInfoWorld.f_74677_();
            if (compoundTag == null) {
                return structureBlockInfoWorld;
            }
            String metadata = compoundTag.m_128461_("metadata");
            BlockState belowBlock = levelReader.m_46865_(worldPos).m_8055_(worldPos);
            if (!metadata.isEmpty()) {
                nbt = null;
            }
            if (belowBlock.m_60795_()) {
                blockState = Blocks.f_50627_.m_49966_();
            } else {
                RandomSource random2 = settings.m_230326_(worldPos);
                switch (metadata) {
                    case "center": {
                        if (random2.m_188501_() < 0.1f) {
                            blockState = BzBlocks.HONEY_COCOON.get().m_49966_();
                            nbt = new CompoundTag();
                            nbt.m_128359_("LootTable", "the_bumblezone:structures/bee_dungeon");
                            break;
                        }
                        if (random2.m_188501_() < 0.6f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random2.m_188501_() < 0.6f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random2.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random2.m_188503_(4) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "inner_ring": {
                        if (random2.m_188501_() < 0.35f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random2.m_188501_() < 0.35f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random2.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random2.m_188503_(random2.m_188503_(4) + 1) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "outer_ring": {
                        if (random2.m_188501_() < 0.45f) {
                            blockState = BzBlocks.HONEY_CRYSTAL.get().m_49966_();
                            break;
                        }
                        if (random2.m_188501_() < 0.2f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random2.m_188503_(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random2.m_188503_(random2.m_188503_(4) + 1) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                }
            }
        } else if (blockState.m_60713_(Blocks.f_50720_) || blockState.m_60713_(BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            boolean compatSuccess = false;
            RandomSource random3 = settings.m_230326_(worldPos);
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                if (!compat.checkCombSpawn(worldPos, random3, levelReader, false)) continue;
                StructureTemplate.StructureBlockInfo info = compat.getHoneycomb(worldPos, random3, levelReader, false);
                if (info != null) {
                    return info;
                }
                compatSuccess = true;
                break;
            }
            if (!compatSuccess) {
                blockState = random3.m_188501_() < 0.4f ? Blocks.f_50720_.m_49966_() : BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_();
            }
        } else if (blockState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get())) {
            RandomSource random4 = settings.m_230326_(worldPos);
            blockState = random4.m_188501_() < 0.6f ? (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random4.m_188503_(3)))).m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)HoneycombBrood.f_52588_))) : (random4.m_188501_() < 0.2f ? Blocks.f_50719_.m_49966_() : BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_());
        } else if (blockState.m_60713_((Block)BzFluids.SUGAR_WATER_BLOCK.get()) && (random = settings.m_230326_(worldPos)).m_188501_() < 0.1f) {
            blockState = (BlockState)BzBlocks.HONEY_CRYSTAL.get().m_49966_().m_61124_((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.BEE_DUNGEON_PROCESSOR.get();
    }
}

