/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class PollinatedCaves
extends Feature<NoneFeatureConfiguration> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;
    protected static OpenSimplex2F noiseGen2;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            noiseGen2 = new OpenSimplex2F(seed + 3451L);
            this.seed = seed;
        }
    }

    public PollinatedCaves(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        this.setSeed(level.m_7328_());
        BlockPos.MutableBlockPos mutableBlockPos = context.m_159777_().m_122032_();
        int disallowedBottomRange = Integer.MAX_VALUE;
        int disallowedTopRange = Integer.MIN_VALUE;
        WorldGenLevel worldGenLevel = context.m_159774_();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.m_9598_().m_6632_(Registries.f_256944_).get();
            StructureManager structureManager = ((WorldGenRegionAccessor)worldGenRegion).bumblezone$getStructureManager();
            ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
            List structureStarts = structureManager.m_220477_(chunkPos, struct -> structureRegistry.m_246971_((ResourceKey)structureRegistry.m_7854_(struct).get()).m_203656_(BzTags.NO_CAVES));
            for (StructureStart structureStart : structureStarts) {
                disallowedBottomRange = Math.min(disallowedBottomRange, structureStart.m_73601_().m_162396_());
                disallowedTopRange = Math.max(disallowedTopRange, structureStart.m_73601_().m_162400_());
            }
        }
        int orgX = context.m_159777_().m_123341_();
        int orgY = context.m_159777_().m_123342_();
        int orgZ = context.m_159777_().m_123343_();
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.m_159774_());
        for (int y = 15; y < context.m_159775_().m_6331_() - 14; ++y) {
            if (y > disallowedBottomRange && y < disallowedTopRange) continue;
            mutableBlockPos.m_122178_(orgX, orgY, orgZ).m_122184_(0, y, 0);
            if (bulkSectionAccess.getSection((BlockPos)mutableBlockPos).m_188008_()) {
                y += 16 - y % 16;
                continue;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double heightPressure;
                    mutableBlockPos.m_122178_(orgX, orgY, orgZ).m_122184_(x, y, z);
                    double noise1 = Math.abs(noiseGen.noise3_Classic((double)mutableBlockPos.m_123341_() * 0.019, (double)mutableBlockPos.m_123343_() * 0.019, (double)mutableBlockPos.m_123342_() * 0.038));
                    if (noise1 >= 0.037) {
                        if (noise1 >= 0.6) {
                            z += 6;
                            continue;
                        }
                        if (noise1 >= 0.4) {
                            z += 4;
                            continue;
                        }
                        if (!(noise1 >= 0.2)) continue;
                        z += 2;
                        continue;
                    }
                    double noise2 = noiseGen2.noise3_Classic((double)mutableBlockPos.m_123341_() * 0.019, (double)mutableBlockPos.m_123343_() * 0.019, (double)mutableBlockPos.m_123342_() * 0.038);
                    double finalNoise = noise1 * noise1 + noise2 * noise2 + (heightPressure = (double)Math.max((30.0f - (float)y) / 90.0f, 0.0f));
                    if (finalNoise < (double)0.014f) {
                        PollinatedCaves.carve(level, bulkSectionAccess, mutableBlockPos, finalNoise, noise1);
                        continue;
                    }
                    if (finalNoise >= 0.6) {
                        z += 6;
                        continue;
                    }
                    if (finalNoise >= 0.4) {
                        z += 4;
                        continue;
                    }
                    if (!(finalNoise >= 0.2)) continue;
                    z += 2;
                }
            }
        }
        return true;
    }

    private static void carve(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos.MutableBlockPos position, double finalNoise, double noise) {
        BlockState currentState = bulkSectionAccess.getBlockState((BlockPos)position);
        if (!currentState.m_60795_() && currentState.m_60819_().m_76178_() && !currentState.m_60713_(BzBlocks.PILE_OF_POLLEN.get()) && !currentState.m_204336_(BzTags.FORCE_CAVE_TO_NOT_CARVE)) {
            if (finalNoise > (double)0.0105f) {
                if (noise * 3.0 % 2.0 < 0.35) {
                    bulkSectionAccess.setBlockState((BlockPos)position, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), false);
                    if (currentState.m_155947_()) {
                        world.m_46865_((BlockPos)position).m_8114_((BlockPos)position);
                    }
                }
                return;
            }
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                sidePos.m_122190_((Vec3i)position).m_122173_(direction);
                if (bulkSectionAccess.getBlockState((BlockPos)sidePos).m_60819_().m_76178_()) continue;
                return;
            }
            position.m_122173_(Direction.DOWN);
            BlockState belowState = bulkSectionAccess.getBlockState((BlockPos)position);
            position.m_122173_(Direction.UP);
            if (currentState.m_155947_()) {
                world.m_46865_((BlockPos)position).m_8114_((BlockPos)position);
            }
            if (!belowState.m_60795_() && belowState.m_60819_().m_76178_() && belowState.m_280555_()) {
                bulkSectionAccess.setBlockState((BlockPos)position, (BlockState)BzBlocks.PILE_OF_POLLEN.get().m_49966_().m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf((int)Math.max(Math.min((noise + 1.0) * 3.0, 8.0), 1.0))), false);
                world.m_186460_((BlockPos)position, BzBlocks.PILE_OF_POLLEN.get(), 0);
                int carveHeight = Math.abs((int)(noise * 1000.0 % 0.8)) * 4 + 2;
                for (int i = 0; i < carveHeight; ++i) {
                    position.m_122173_(Direction.UP);
                    for (Direction direction : Direction.values()) {
                        sidePos.m_122190_((Vec3i)position).m_122173_(direction);
                        if (bulkSectionAccess.getBlockState((BlockPos)sidePos).m_60819_().m_76178_()) continue;
                        return;
                    }
                    BlockState blockState = bulkSectionAccess.getBlockState((BlockPos)position);
                    if (blockState.m_155947_()) {
                        world.m_46865_((BlockPos)position).m_8114_((BlockPos)position);
                    }
                    bulkSectionAccess.setBlockState((BlockPos)position, Blocks.f_50627_.m_49966_(), false);
                }
                position.m_122175_(Direction.DOWN, carveHeight);
            } else {
                bulkSectionAccess.setBlockState((BlockPos)position, Blocks.f_50627_.m_49966_(), false);
            }
        }
    }
}

