/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla;

import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.PixelTransformer;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public class LazyAreaContext
implements BigContext<LazyArea> {
    private static final int MAX_CACHE = 1024;
    private final Long2IntLinkedOpenHashMap cache;
    private final int maxCache;
    private final ImprovedNoise biomeNoise;
    private final long seed;
    private long rval;

    public LazyAreaContext(int maxCache, long seed1, long seed2) {
        this.seed = LazyAreaContext.mixSeed(seed1, seed2);
        this.biomeNoise = new ImprovedNoise((RandomSource)new LegacyRandomSource(seed1));
        this.cache = new Long2IntLinkedOpenHashMap(16, 0.25f);
        this.cache.defaultReturnValue(Integer.MIN_VALUE);
        this.maxCache = maxCache;
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer) {
        return new LazyArea(this.cache, this.maxCache, pixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer, LazyArea lazyArea) {
        return new LazyArea(this.cache, Math.min(1024, lazyArea.getMaxCache() * 4), pixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer, LazyArea lazyArea, LazyArea lazyArea2) {
        return new LazyArea(this.cache, Math.min(1024, Math.max(lazyArea.getMaxCache(), lazyArea2.getMaxCache()) * 4), pixelTransformer);
    }

    @Override
    public void initRandom(long l, long m) {
        long n = this.seed;
        n = LinearCongruentialGenerator.m_13972_((long)n, (long)l);
        n = LinearCongruentialGenerator.m_13972_((long)n, (long)m);
        n = LinearCongruentialGenerator.m_13972_((long)n, (long)l);
        this.rval = n = LinearCongruentialGenerator.m_13972_((long)n, (long)m);
    }

    @Override
    public int nextRandom(int i) {
        int j = Math.floorMod(this.rval >> 24, i);
        this.rval = LinearCongruentialGenerator.m_13972_((long)this.rval, (long)this.seed);
        return j;
    }

    @Override
    public ImprovedNoise getBiomeNoise() {
        return this.biomeNoise;
    }

    private static long mixSeed(long l, long m) {
        long n = LinearCongruentialGenerator.m_13972_((long)m, (long)m);
        n = LinearCongruentialGenerator.m_13972_((long)n, (long)m);
        n = LinearCongruentialGenerator.m_13972_((long)n, (long)m);
        long o = LinearCongruentialGenerator.m_13972_((long)l, (long)n);
        o = LinearCongruentialGenerator.m_13972_((long)o, (long)n);
        return LinearCongruentialGenerator.m_13972_((long)o, (long)n);
    }
}

