/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.client.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenRandomizerTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.QueenTradesREICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.rei.REIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class REICompat
implements REIClientPlugin {
    public static final CategoryIdentifier<REIQueenTradesInfo> QUEEN_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_trades");
    public static final CategoryIdentifier<REIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = CategoryIdentifier.of((String)"the_bumblezone", (String)"queen_color_randomizer_trades");

    public void registerDisplays(DisplayRegistry registry) {
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> REICompat.addInfo((Item)item.get()));
        REICompat.addInfo((Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        REICompat.addInfo((Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            REICompat.addInfo((Fluid)BzFluids.HONEY_FLUID.get());
        }
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "potion_candle/from_super_candles")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, true));
        registry.getRecipeManager().m_44043_(new ResourceLocation("the_bumblezone", "potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> REICompat.registerExtraRecipes(recipe, registry, false));
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).m_146338_()) {
                    List<ItemStack> rewardCollection = weightedTradeResult.getItems().stream().map(e -> new ItemStack((ItemLike)e, weightedTradeResult.count)).toList();
                    registry.add((Display)new REIQueenTradesInfo(((MainTradeRowInput)trade.getFirst()).tagKey().isPresent() ? EntryIngredients.ofItemTag(((MainTradeRowInput)trade.getFirst()).tagKey().get()) : EntryIngredients.of((ItemLike)((MainTradeRowInput)trade.getFirst()).item()), (TagKey<Item>)((TagKey)((MainTradeRowInput)trade.getFirst()).tagKey().orElse(null)), EntryIngredients.ofItemStacks(rewardCollection), (TagKey<Item>)((TagKey)weightedTradeResult.tagKey.orElse(null)), weightedTradeResult.xpReward, weightedTradeResult.weight, weightedTradeResult.getTotalWeight()), QUEEN_TRADES);
                }
            }
        }
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheReiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                TagKey<Item> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheReiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<ItemStack> randomizeStack = tradeEntry.getWantItems().m_203614_().map(e -> ((Item)e.m_203334_()).m_7968_()).toList();
                    tagData = new TagData(randomizeStack.size(), Collections.singletonList(EntryIngredients.ofIngredient((Ingredient)Ingredient.m_204132_(itemTagKey))));
                    cacheReiData.put(itemTagKey, tagData);
                }
                registry.add((Display)new REIQueenRandomizerTradesInfo(tagData.reiIngredient(), tagData.reiIngredient(), itemTagKey, 1, tagData.listSize()), QUEEN_RANDOMIZE_TRADES);
            }
        }
        List<ItemStack> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        REICompat.addComplexBlockTagInfo(Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(Pair<String, List<ItemStack>> ... structureInfo) {
        for (Pair<String, List<ItemStack>> predicatePair : structureInfo) {
            BuiltinClientPlugin.getInstance().registerInformation(EntryIngredient.of(((List)predicatePair.getSecond()).stream().map(EntryStacks::of).toList()), (Component)Component.m_237115_((String)predicatePair.toString()), text -> {
                text.add(Component.m_237115_((String)("the_bumblezone" + (String)predicatePair.getFirst())));
                return text;
            });
        }
    }

    private static void addInfo(Item item) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((ItemLike)item), (Component)Component.m_237115_((String)BuiltInRegistries.f_257033_.m_7981_((Object)item).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_() + ".description")));
            return text;
        });
    }

    private static void addInfo(Fluid fluid) {
        BuiltinClientPlugin.getInstance().registerInformation(EntryStacks.of((Fluid)fluid, (long)1L), (Component)Component.m_237115_((String)BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString()), text -> {
            text.add(Component.m_237115_((String)("the_bumblezone." + BuiltInRegistries.f_257020_.m_7981_((Object)fluid).m_135815_() + ".description")));
            return text;
        });
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, DisplayRegistry registry, boolean oneRecipeOnly) {
        if (baseRecipe instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)baseRecipe;
            List<CraftingRecipe> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            extraRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new QueenTradesREICategory());
        registry.add((DisplayCategory)new QueenRandomizerTradesREICategory());
        registry.addWorkstations(QUEEN_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
        registry.addWorkstations(QUEEN_RANDOMIZE_TRADES, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()))});
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new OverlayDecider(){

            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return true;
            }

            public <R extends Screen> InteractionResult shouldScreenBeOverlaid(R screen) {
                return screen.getClass() == CrystallineFlowerScreen.class ? InteractionResult.FAIL : InteractionResult.PASS;
            }
        });
    }

    record TagData(int listSize, List<EntryIngredient> reiIngredient) {
    }
}

