/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.items.BzShieldItem;
import com.telepathicgrunt.the_bumblezone.mixin.items.PlayerDamageShieldInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HoneyCrystalShield
extends BzShieldItem
implements ItemExtension {
    private static final int[] shieldDurabilityBoostPerLevel = new int[]{0, 20, 45, 75, 110, 150, 195, 245, 316, 632};
    private static final int maxShieldLevel = shieldDurabilityBoostPerLevel.length - 1;

    public HoneyCrystalShield(Item.Properties properties) {
        super(properties.m_41503_(40));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.HONEY_CRYSTAL_SHIELD_REPAIR_ITEMS);
    }

    @Override
    public EquipmentSlot bz$getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int shieldLevel = Math.max(Math.min(stack.m_41784_().m_128451_("ShieldLevel"), maxShieldLevel), 0);
            tooltip.add((Component)Component.m_237115_((String)"item.the_bumblezone.honey_crystal_shield.level_tooltip").m_130946_(": " + (shieldLevel + 1)));
        }
    }

    @Override
    public int bz$getMaxDamage(ItemStack stack) {
        if (stack.m_41782_()) {
            this.upgradeLegacyShield(stack);
            int shieldLevel = Math.max(Math.min(stack.m_41784_().m_128451_("ShieldLevel"), maxShieldLevel), 0);
            if (shieldLevel != 0) {
                return stack.m_41720_().m_41462_() + shieldDurabilityBoostPerLevel[shieldLevel];
            }
        }
        return stack.m_41720_().m_41462_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.bz$getMaxDamage(stack);
    }

    private void upgradeLegacyShield(ItemStack stack) {
        if (stack.m_41782_() && !stack.m_41783_().m_128441_("ShieldLevel")) {
            int repairCost = stack.m_41784_().m_128451_("RepairCost");
            if (repairCost >= 32) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel);
            } else if (repairCost >= 16) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel - 1);
            } else if (repairCost >= 5) {
                stack.m_41784_().m_128405_("ShieldLevel", maxShieldLevel / 2);
            }
        }
    }

    @Override
    public void bz$setDamage(ItemStack stack, int damage) {
        int newDamage = damage;
        int oldDamage = stack.m_41773_();
        int damageCaused = oldDamage - damage;
        int shieldLevel = stack.m_41784_().m_128451_("ShieldLevel");
        if (damageCaused < 0) {
            int reducedDamage = -1 * Math.min(-1, damageCaused + shieldLevel / 4);
            newDamage = Math.max(0, stack.m_41773_() + reducedDamage);
        } else if (damageCaused > stack.m_41776_() / 5) {
            stack.m_41784_().m_128405_("ShieldLevel", Math.min(maxShieldLevel, shieldLevel + 1));
        }
        stack.m_41784_().m_128405_("Damage", Math.max(0, newDamage));
    }

    public void setDamage(ItemStack stack, int damage) {
        this.bz$setDamage(stack, damage);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44962_) {
            return OptionalBoolean.FALSE;
        }
        return OptionalBoolean.of(enchantment.f_44672_.m_7454_(stack.m_41720_()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.bz$canApplyAtEnchantingTable(stack, enchantment).orElseGet(() -> enchantment.f_44672_.m_7454_(stack.m_41720_()));
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.m_41773_() * 13.0f / (float)itemStack.m_41776_());
    }

    public int m_142159_(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.m_41776_() - (float)itemStack.m_41773_()) / (float)itemStack.m_41776_());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean bz$canPerformAction(ItemStack stack, String toolAction) {
        return toolAction.equals("shield_block") && stack.m_150930_((Item)this);
    }

    public static boolean handledPlayerHurtBehavior(EntityAttackedEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HoneyCrystalShield.slowPhysicalAttackers(event.source(), player);
            return HoneyCrystalShield.damageShieldFromExplosionAndFire(event.source(), player);
        }
        return false;
    }

    public static boolean damageShieldFromExplosionAndFire(DamageSource source, Player player) {
        DamageSources damageSources = player.m_9236_().m_269111_();
        if (player.m_21211_().m_41720_() instanceof HoneyCrystalShield && player.m_21254_() && (source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268745_))) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.HONEY_CRYSTAL_SHIELD_BLOCK_INEFFECTIVELY_TRIGGER.trigger(serverPlayer);
            }
            if (source.m_269533_(DamageTypeTags.f_268415_)) {
                player.m_269405_(0.0, 0.0);
                ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.m_21211_().m_41776_() / 3, 18));
            } else if (source.m_269533_(DamageTypeTags.f_268745_) && !player.m_21023_(MobEffects.f_19607_)) {
                if (source.m_269533_(DamageTypeTags.f_268524_)) {
                    ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.m_21211_().m_41776_() / 6, 3));
                } else {
                    ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.m_21211_().m_41776_() / 100, 3));
                    return false;
                }
            }
            if (player instanceof ServerPlayer) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)player.m_21211_().m_41720_()));
            }
            return true;
        }
        return false;
    }

    public static void slowPhysicalAttackers(DamageSource source, Player player) {
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if ((!source.m_269533_(DamageTypeTags.f_268415_) || !source.m_269533_(DamageTypeTags.f_276146_)) && player.m_21211_().m_41720_() instanceof HoneyCrystalShield && player.m_21254_()) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 165, 1, true, true, false));
            }
        }
    }

    public static void setShieldCooldown(Player playerEntity, LivingEntity livingEntity) {
        float disableChance = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)livingEntity) * 0.05f;
        if (livingEntity.m_217043_().m_188501_() < disableChance) {
            playerEntity.m_36335_().m_41524_(BzItems.HONEY_CRYSTAL_SHIELD.get(), 100);
            livingEntity.m_9236_().m_7605_((Entity)playerEntity, (byte)30);
        }
    }

    public static boolean damageHoneyCrystalShield(Player player, float amount) {
        if (player.m_21211_().m_41720_() == BzItems.HONEY_CRYSTAL_SHIELD.get()) {
            if (amount >= 3.0f) {
                int damageToDo = 1 + Mth.m_14143_((float)amount);
                InteractionHand hand = player.m_7655_();
                player.m_21211_().m_41622_(damageToDo, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                if (player.m_21211_().m_41619_()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    player.m_5810_();
                    player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + player.m_217043_().m_188501_() * 0.4f);
                }
            }
            return true;
        }
        return false;
    }
}

