/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.fluids.base.BzBucketItem;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidInfo;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import dev.architectury.injectables.annotations.PlatformOnly;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BzCustomBucketItem
extends BzBucketItem {
    public final Fluid fluid;

    public BzCustomBucketItem(FluidInfo info, Item.Properties builder) {
        super(info, builder);
        this.fluid = info.source().m_5613_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        InteractionResultHolder<ItemStack> specialActionResult = PlatformHooks.performItemUse(world, playerEntity, hand, this.fluid, this);
        if (specialActionResult.m_19089_() != InteractionResult.PASS) {
            this.checkAndGrantAdvancement(world, playerEntity, specialActionResult);
            return specialActionResult;
        }
        InteractionResultHolder actionResult = super.m_7203_(world, playerEntity, hand);
        this.checkAndGrantAdvancement(world, playerEntity, (InteractionResultHolder<ItemStack>)actionResult);
        return actionResult;
    }

    private void checkAndGrantAdvancement(Level world, Player playerEntity, InteractionResultHolder<ItemStack> actionResult) {
        if (this.getFluid() == BzFluids.SUGAR_WATER_FLUID.get() && (actionResult.m_19089_() == InteractionResult.CONSUME || actionResult.m_19089_() == InteractionResult.SUCCESS) && playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            BlockHitResult raytraceresult = BzCustomBucketItem.m_41435_((Level)world, (Player)playerEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockpos = raytraceresult.m_82425_();
                Direction direction = raytraceresult.m_82434_();
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = world.m_8055_(blockpos);
                BlockPos blockpos2 = this.canBlockContainFluid(world, blockpos, blockstate) ? blockpos : blockpos1;
                boolean isNextToSugarCane = false;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction directionOffset : Direction.Plane.HORIZONTAL) {
                    mutable.m_122190_((Vec3i)blockpos2).m_122173_(directionOffset).m_122173_(Direction.UP);
                    BlockState state = world.m_8055_((BlockPos)mutable);
                    if (!state.m_60713_(Blocks.f_50130_)) continue;
                    isNextToSugarCane = true;
                    break;
                }
                if (isNextToSugarCane) {
                    BzCriterias.SUGAR_WATER_NEXT_TO_SUGAR_CANE_TRIGGER.trigger(serverPlayer);
                }
            }
        }
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && (((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, (Fluid)this.getFluid()) || ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, (Fluid)Fluids.f_76193_));
    }

    @PlatformOnly(value={"forge"})
    public boolean emptyContents(@Nullable Player player, Level world, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        return this.m_142073_(player, world, pos, hitResult);
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult hitResult) {
        if (!(this.fluid instanceof FlowingFluid) || !GeneralUtils.isPermissionAllowedAtSpot(level, (Entity)player, pos, true)) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        boolean canBucketPlace = blockState.m_60722_(this.fluid);
        boolean canPlaceFluid = blockState.m_60795_() || canBucketPlace;
        boolean feedVanillaWaterOverride = false;
        if (block instanceof LiquidBlockContainer) {
            if (((LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockState, this.fluid)) {
                canPlaceFluid = true;
            }
            if (this.fluid.m_205067_(FluidTags.f_13131_) && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockState, (Fluid)Fluids.f_76193_)) {
                canPlaceFluid = true;
                feedVanillaWaterOverride = true;
            }
        }
        if (!canPlaceFluid) {
            return hitResult != null && this.m_142073_(player, level, hitResult.m_82425_().m_121945_(hitResult.m_82434_()), null);
        }
        if (level.m_6042_().f_63857_() && this.info.properties().canExtinguish()) {
            double x = pos.m_123341_();
            double y = pos.m_123342_();
            double z = pos.m_123343_();
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + Math.random(), y + Math.random(), z + Math.random(), 0.0, 0.0, 0.0);
            }
            if (!level.m_5776_()) {
                if (this.fluid.m_205067_(BzTags.SUGAR_WATER_FLUID) && level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
                    Vec3 targetPos = hitResult != null ? hitResult.m_82450_() : new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    LootTable sugarWaterEvaporateLootTable = serverLevelAccessor.m_6018_().m_7654_().m_278653_().m_278676_(new ResourceLocation("the_bumblezone", "fluids/sugar_water_evaporates"));
                    LootParams lootParams = new LootParams.Builder(serverLevelAccessor.m_6018_()).m_287286_(LootContextParams.f_81460_, (Object)targetPos).m_287289_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81412_);
                    ObjectArrayList evaporateItems = sugarWaterEvaporateLootTable.m_287195_(lootParams);
                    for (ItemStack itemStackToSpawn : evaporateItems) {
                        ItemEntity itementity = new ItemEntity(level, targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), itemStackToSpawn);
                        itementity.m_32060_();
                        level.m_7967_((Entity)itementity);
                    }
                } else if (this.fluid.m_205067_(BzTags.HONEY_FLUID)) {
                    level.m_7731_(pos, BzBlocks.GLISTERING_HONEY_CRYSTAL.get().m_49966_(), 3);
                }
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && this.fluid.m_205067_(FluidTags.f_13131_)) {
            if (feedVanillaWaterOverride) {
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, pos, blockState, Fluids.f_76193_.m_76068_(false));
            } else {
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, pos, blockState, ((FlowingFluid)this.fluid).m_76068_(false));
            }
            this.m_7718_(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.f_46443_ && canBucketPlace && blockState.m_60819_().m_76178_()) {
            level.m_46961_(pos, true);
        }
        if (!level.m_7731_(pos, this.fluid.m_76145_().m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(player, (LevelAccessor)level, pos);
        return true;
    }
}

