/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RootminRangedAttackGoal
extends Goal {
    private final RootminEntity rootminEntity;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public RootminRangedAttackGoal(RootminEntity rootminEntity, double speedModifier, int attackIntervalMax, int attackIntervalMin, float attackRadius) {
        this.rootminEntity = rootminEntity;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMax;
        this.attackIntervalMax = attackIntervalMin;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.rootminEntity.m_5448_();
        if (livingEntity == null || !livingEntity.m_6084_() || this.rootminEntity.disableAttackGoals) {
            return false;
        }
        if (this.rootminEntity.isOwnedBy(livingEntity)) {
            return false;
        }
        if (!this.rootminEntity.canTarget(livingEntity)) {
            this.rootminEntity.m_6710_(null);
            this.rootminEntity.m_21561_(false);
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.rootminEntity.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        Level level = this.rootminEntity.m_9236_();
        BlockPos posInFront = this.rootminEntity.m_20183_().m_121945_(this.rootminEntity.m_6350_());
        double distToTarget = this.rootminEntity.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean blockBlockingInFront = level.m_8055_(posInFront).m_60838_((BlockGetter)level, posInFront);
        boolean lineOfSight = !blockBlockingInFront && this.rootminEntity.m_21574_().m_148306_((Entity)this.target);
        int n = this.seeTime = lineOfSight ? (this.seeTime = this.seeTime + 1) : 0;
        if (distToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) {
            this.rootminEntity.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        } else {
            this.rootminEntity.m_21573_().m_26573_();
        }
        this.rootminEntity.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!lineOfSight) {
                return;
            }
            float f = (float)Math.sqrt(distToTarget) / this.attackRadius;
            this.rootminEntity.runShoot(this.target, 1.2f, false);
            this.rootminEntity.exposedTimer = 0;
            this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distToTarget) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

