/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.fluids;

import com.mojang.blaze3d.systems.RenderSystem;
import com.telepathicgrunt.the_bumblezone.client.rendering.FluidClientOverlay;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.fluids.base.ClientFluidProperties;
import com.telepathicgrunt.the_bumblezone.fluids.base.FluidProperties;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;

public class RoyalJellyClientProperties {
    public static final ResourceLocation ROYAL_JELLY_FLUID_STILL_TEXTURE = new ResourceLocation("the_bumblezone", "block/royal_jelly_fluid_still");
    public static final ResourceLocation ROYAL_JELLY_FLUID_FLOWING_TEXTURE = new ResourceLocation("the_bumblezone", "block/royal_jelly_fluid_flow");
    public static final ResourceLocation ROYAL_JELLY_FLUID_FLOWING_DIAGONAL_TEXTURE = new ResourceLocation("the_bumblezone", "block/royal_jelly_fluid_flow_diagonal");

    public static ClientFluidProperties create(FluidProperties properties) {
        return new ClientFluidProperties(properties).still(ROYAL_JELLY_FLUID_STILL_TEXTURE).flowing(ROYAL_JELLY_FLUID_FLOWING_TEXTURE).overlay(ROYAL_JELLY_FLUID_FLOWING_TEXTURE).diagonal(ROYAL_JELLY_FLUID_FLOWING_DIAGONAL_TEXTURE).tintColor(-1).screenOverlay(FluidClientOverlay::renderHoneyOverlay).modifyFogColor((camera, partialTick, level, renderDistance, darkenWorldAmount, fogColor) -> {
            Entity entity = camera.m_90592_();
            BlockState state = level.m_8055_(entity != null ? BlockPos.m_274446_((Position)entity.m_20299_(1.0f)) : camera.m_90588_());
            if (state.m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                double yEye = Math.abs(entity != null ? entity.m_20299_(1.0f).m_7098_() : camera.m_90583_().m_7098_());
                double yOffset = yEye - (double)((int)yEye);
                if ((double)((Integer)state.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                    return fogColor;
                }
            }
            BlockPos blockpos = BlockPos.m_274561_((double)camera.m_90592_().m_20185_(), (double)camera.m_90592_().m_20188_(), (double)camera.m_90592_().m_20189_());
            float brightnessAtEyes = LightTexture.m_234316_((DimensionType)camera.m_90592_().m_9236_().m_6042_(), (int)camera.m_90592_().m_9236_().m_46803_(blockpos));
            float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes(camera.m_90592_()), 2.0), (double)brightnessAtEyes);
            float fogRed = 0.5f * brightness;
            float fogGreen = 0.0f;
            float fogBlue = 0.55f * brightness;
            return new Vector3f(fogRed, fogGreen, fogBlue);
        }).modifyFog((camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape) -> {
            BlockState state;
            Entity entity = camera.m_90592_();
            if (entity != null && (state = entity.m_9236_().m_8055_(BlockPos.m_274446_((Position)entity.m_20299_(1.0f)))).m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                double yEye = Math.abs(entity.m_20299_(1.0f).m_7098_());
                double yOffset = yEye - (double)((int)yEye);
                if ((double)((Integer)state.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                    return;
                }
            }
            RenderSystem.setShaderFogStart((float)0.35f);
            RenderSystem.setShaderFogEnd((float)4.0f);
        });
    }
}

