/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.electricring;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.electricring.ElectricRingModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ElectricRingEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ElectricRingRenderer<M extends EntityModel<ElectricRingEntity>>
extends EntityRenderer<ElectricRingEntity>
implements RenderLayerParent<ElectricRingEntity, M> {
    static final ResourceLocation SKIN_1 = new ResourceLocation("the_bumblezone", "textures/entity/electric_ring/electric_ring_1.png");
    static final ResourceLocation SKIN_2 = new ResourceLocation("the_bumblezone", "textures/entity/electric_ring/electric_ring_2.png");
    static final ResourceLocation SKIN_3 = new ResourceLocation("the_bumblezone", "textures/entity/electric_ring/electric_ring_3.png");
    protected final ElectricRingModel<ElectricRingEntity> model;
    protected final List<RenderLayer<ElectricRingEntity, M>> layers = Lists.newArrayList();

    public ElectricRingRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ElectricRingModel(context.m_174023_(ElectricRingModel.LAYER_LOCATION));
    }

    protected final boolean addLayer(RenderLayer<ElectricRingEntity, M> renderLayer) {
        return this.layers.add(renderLayer);
    }

    public M m_7200_() {
        return (M)((Object)this.model);
    }

    public void render(ElectricRingEntity ringEntity, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        packedLight = 0xF000F0;
        float angleExtra = -180.0f;
        int interval = 3;
        int state = ringEntity.f_19797_ / interval;
        float spinSpeed = 15.0f;
        float angle = ((float)ringEntity.f_19797_ + partialTicks) * spinSpeed;
        angle += (float)state * angleExtra;
        poseStack.m_85836_();
        float rotationLerp = Mth.m_14179_((float)partialTicks, (float)ringEntity.f_19860_, (float)ringEntity.m_146909_());
        float scale = ringEntity.disappearingTime >= 0 ? Math.min(((float)ringEntity.disappearingTime - partialTicks) / 20.0f, 1.0f) : Math.min(((float)ringEntity.f_19797_ + partialTicks) / 20.0f, 1.0f);
        poseStack.m_85841_(-scale, -scale, scale);
        poseStack.m_252880_(0.0f, -1.5f - (1.5f - scale * 1.5f), 0.0f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f - ringEntity.m_146908_()));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f - ringEntity.m_146909_()));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(angle % 360.0f));
        this.model.m_6839_(ringEntity, 0.0f, 0.0f, partialTicks);
        this.model.m_6973_(ringEntity, 0.0f, 0.0f, 0.0f, 0.0f, rotationLerp);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bodyVisible = this.isBodyVisible(ringEntity);
        boolean hidden = !bodyVisible && !ringEntity.m_20177_((Player)minecraft.f_91074_);
        boolean glowing = minecraft.m_91314_((Entity)ringEntity);
        RenderType renderType = this.getRenderType(ringEntity, bodyVisible, hidden, glowing);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, 0, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!ringEntity.m_5833_()) {
            for (RenderLayer<ElectricRingEntity, M> renderLayer : this.layers) {
                renderLayer.m_6494_(poseStack, multiBufferSource, packedLight, (Entity)ringEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, rotationLerp);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)ringEntity, yRot, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(ElectricRingEntity ringEntity, boolean bodyVisible, boolean hidden, boolean glowing) {
        ResourceLocation resourceLocation = this.getTextureLocation(ringEntity);
        if (bodyVisible) {
            return this.model.m_103119_(resourceLocation);
        }
        if (glowing) {
            return RenderType.m_110491_((ResourceLocation)resourceLocation);
        }
        return null;
    }

    protected boolean isBodyVisible(ElectricRingEntity ringEntity) {
        return !ringEntity.m_20145_();
    }

    public ResourceLocation getTextureLocation(ElectricRingEntity ringEntity) {
        int interval = 3;
        int state = ringEntity.f_19797_ % (interval * 3);
        if (state < interval) {
            return SKIN_1;
        }
        if (state < interval * 2) {
            return SKIN_2;
        }
        return SKIN_3;
    }
}

