/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BeehemothModel
extends EntityModel<BeehemothEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_bumblezone", "beehemoth"), "main");
    private final ModelPart ROOT;
    protected final ModelPart SADDLE;
    protected final ModelPart CROWN;
    protected final ModelPart WING_RIGHT;
    protected final ModelPart WING_LEFT;
    protected final ModelPart LEG_FRONTLEFT;
    protected final ModelPart LEG_FRONTRIGHT;
    protected final ModelPart LEG_MIDLEFT;
    protected final ModelPart LEG_MIDRIGHT;
    protected final ModelPart LEG_REARLEFT;
    protected final ModelPart LEG_REARRIGHT;
    protected final ModelPart KneeFrontRightCube_r1;
    protected final ModelPart KneeMidRightCube_r1;
    protected final ModelPart KneeRearRightCube_r1;
    protected final ModelPart KneeFrontLeftCube_r1;
    protected final ModelPart KneeMidLeftCube_r1;
    protected final ModelPart KneeRearLeftCube_r1;
    protected final ModelPart ANTENNA_LEFT;
    protected final ModelPart ANTENNA_RIGHT;
    protected final ModelPart THORAX;
    protected final ModelPart FACE;
    protected final ModelPart ABDOMEN;

    public BeehemothModel(ModelPart modelPart) {
        this.ROOT = modelPart.m_171324_("ROOT");
        this.FACE = this.ROOT.m_171324_("FACE");
        this.CROWN = this.FACE.m_171324_("CROWN");
        this.ANTENNA_LEFT = this.FACE.m_171324_("ANTENNA_LEFT");
        this.ANTENNA_RIGHT = this.FACE.m_171324_("ANTENNA_RIGHT");
        this.THORAX = this.ROOT.m_171324_("THORAX");
        this.LEG_FRONTLEFT = this.THORAX.m_171324_("LEG_FRONTLEFT");
        this.KneeFrontLeftCube_r1 = this.LEG_FRONTLEFT.m_171324_("KNEE_FRONTLEFT").m_171324_("KneeFrontLeftCube_r1");
        this.LEG_MIDLEFT = this.THORAX.m_171324_("LEG_MIDLEFT");
        this.KneeMidLeftCube_r1 = this.LEG_MIDLEFT.m_171324_("KNEE_MIDLEFT").m_171324_("KneeMidLeftCube_r1");
        this.LEG_REARLEFT = this.THORAX.m_171324_("LEG_REARLEFT");
        this.KneeRearLeftCube_r1 = this.LEG_REARLEFT.m_171324_("KNEE_REARLEFT").m_171324_("KneeRearLeftCube_r1");
        this.LEG_FRONTRIGHT = this.THORAX.m_171324_("LEG_FRONTRIGHT");
        this.KneeFrontRightCube_r1 = this.LEG_FRONTRIGHT.m_171324_("KNEE_FRONTRIGHT").m_171324_("KneeFrontRightCube_r1");
        this.LEG_MIDRIGHT = this.THORAX.m_171324_("LEG_MIDRIGHT");
        this.KneeMidRightCube_r1 = this.LEG_MIDRIGHT.m_171324_("KNEE_MIDRIGHT").m_171324_("KneeMidRightCube_r1");
        this.LEG_REARRIGHT = this.THORAX.m_171324_("LEG_REARRIGHT");
        this.KneeRearRightCube_r1 = this.LEG_REARRIGHT.m_171324_("KNEE_REARRIGHT").m_171324_("KneeRearRightCube_r1");
        this.WING_LEFT = this.THORAX.m_171324_("WING_LEFT");
        this.WING_RIGHT = this.THORAX.m_171324_("WING_RIGHT");
        this.ABDOMEN = this.ROOT.m_171324_("ABDOMEN");
        this.SADDLE = this.ROOT.m_171324_("SADDLE");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition ROOT = partdefinition.m_171599_("ROOT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition FACE = ROOT.m_171599_("FACE", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, 0.0f, -6.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)-6.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition CROWN = FACE.m_171599_("CROWN", CubeListBuilder.m_171558_().m_171514_(40, 26).m_171488_(-2.5f, -3.0f, -5.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ANTENNA_LEFT = FACE.m_171599_("ANTENNA_LEFT", CubeListBuilder.m_171558_().m_171514_(57, 1).m_171488_(-1.5f, 0.0f, -9.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ANTENNA_RIGHT = FACE.m_171599_("ANTENNA_RIGHT", CubeListBuilder.m_171558_().m_171514_(57, 1).m_171488_(1.5f, 0.0f, -9.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition THORAX = ROOT.m_171599_("THORAX", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-4.5f, -9.0f, -6.0f, 9.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LEG_FRONTLEFT = THORAX.m_171599_("LEG_FRONTLEFT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)0.0873f, (float)1.309f));
        PartDefinition KNEE_FRONTLEFT = LEG_FRONTLEFT.m_171599_("KNEE_FRONTLEFT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeFrontLeftCube_r1 = KNEE_FRONTLEFT.m_171599_("KneeFrontLeftCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171488_(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.6981f, (float)0.0f));
        PartDefinition LEG_MIDLEFT = THORAX.m_171599_("LEG_MIDLEFT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition KNEE_MIDLEFT = LEG_MIDLEFT.m_171599_("KNEE_MIDLEFT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeMidLeftCube_r1 = KNEE_MIDLEFT.m_171599_("KneeMidLeftCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171488_(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.8727f, (float)0.0f));
        PartDefinition LEG_REARLEFT = THORAX.m_171599_("LEG_REARLEFT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)-0.2182f, (float)0.9599f));
        PartDefinition KNEE_REARLEFT = LEG_REARLEFT.m_171599_("KNEE_REARLEFT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeRearLeftCube_r1 = KNEE_REARLEFT.m_171599_("KneeRearLeftCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171488_(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition LEG_FRONTRIGHT = THORAX.m_171599_("LEG_FRONTRIGHT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171480_().m_171488_(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)-1.309f));
        PartDefinition KNEE_FRONTRIGHT = LEG_FRONTRIGHT.m_171599_("KNEE_FRONTRIGHT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeFrontRightCube_r1 = KNEE_FRONTRIGHT.m_171599_("KneeFrontRightCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171480_().m_171488_(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.6981f, (float)0.0f));
        PartDefinition LEG_MIDRIGHT = THORAX.m_171599_("LEG_MIDRIGHT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171480_().m_171488_(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition KNEE_MIDRIGHT = LEG_MIDRIGHT.m_171599_("KNEE_MIDRIGHT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeMidRightCube_r1 = KNEE_MIDRIGHT.m_171599_("KneeMidRightCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171480_().m_171488_(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.8727f, (float)0.0f));
        PartDefinition LEG_REARRIGHT = THORAX.m_171599_("LEG_REARRIGHT", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171480_().m_171488_(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)0.2182f, (float)-0.9599f));
        PartDefinition KNEE_REARRIGHT = LEG_REARRIGHT.m_171599_("KNEE_REARRIGHT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeRearRightCube_r1 = KNEE_REARRIGHT.m_171599_("KneeRearRightCube_r1", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171480_().m_171488_(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition WING_LEFT = THORAX.m_171599_("WING_LEFT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)-9.0f, (float)-5.0f));
        PartDefinition WingLeftPlane_r1 = WING_LEFT.m_171599_("WingLeftPlane_r1", CubeListBuilder.m_171558_().m_171514_(5, 34).m_171488_(0.0f, 0.0f, -1.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2182f, (float)-0.1745f));
        PartDefinition WING_RIGHT = THORAX.m_171599_("WING_RIGHT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)-9.0f, (float)-5.0f));
        PartDefinition WingRightPlane_r1 = WING_RIGHT.m_171599_("WingRightPlane_r1", CubeListBuilder.m_171558_().m_171514_(5, 34).m_171480_().m_171488_(-7.0f, 0.0f, -1.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)-0.2182f, (float)0.1745f));
        PartDefinition ABDOMEN = ROOT.m_171599_("ABDOMEN", CubeListBuilder.m_171558_().m_171514_(29, 8).m_171488_(-3.5f, 0.0f, -1.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(51, 3).m_171488_(-0.5f, 3.0f, 9.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition SADDLE = ROOT.m_171599_("SADDLE", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-5.5f, -9.25f, -4.0f, 11.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private float getSine(float time, float max, float min) {
        float so = Mth.m_14031_((float)(time * 0.25f));
        float range = max - min;
        return so * range + min;
    }

    private float getCos(float time, float max, float min) {
        float so = Mth.m_14089_((float)(time * 0.25f));
        float range = max - min;
        return so * range + min;
    }

    public void setupAnim(BeehemothEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.SADDLE.f_104207_ = entity.m_6254_();
        this.CROWN.f_104207_ = entity.isQueen();
        this.WING_RIGHT.f_104203_ = 0.0f;
        this.ROOT.f_104203_ = 0.0f;
        this.ROOT.f_104201_ = 19.0f;
        boolean onGround = entity.m_20096_() || entity.m_20159_();
        boolean isSitting = entity.m_21825_();
        double xzSpeed = Math.abs(entity.m_20184_().m_7096_()) + Math.abs(entity.m_20184_().m_7094_());
        if (onGround) {
            this.WING_RIGHT.f_104204_ = -0.2618f;
            this.WING_RIGHT.f_104205_ = 0.0f;
            this.WING_LEFT.f_104203_ = 0.0f;
            this.WING_LEFT.f_104204_ = 0.2618f;
            this.WING_LEFT.f_104205_ = 0.0f;
            this.LEG_FRONTLEFT.f_104203_ = 0.0f;
            this.LEG_FRONTRIGHT.f_104203_ = 0.0f;
            this.LEG_MIDLEFT.f_104203_ = 0.0f;
            this.LEG_MIDRIGHT.f_104203_ = 0.0f;
            this.LEG_REARLEFT.f_104203_ = 0.0f;
            this.LEG_REARRIGHT.f_104203_ = 0.0f;
            if (xzSpeed > 8.0E-7) {
                this.KneeFrontRightCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset1, 0.2f, 0.475f);
                this.KneeMidRightCube_r1.f_104204_ = this.getCos(ageInTicks + entity.offset2, 0.375f, 0.525f);
                this.KneeRearRightCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset3, 0.45f, 0.625f);
                this.KneeFrontLeftCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset4, -0.2f, -0.475f);
                this.KneeMidLeftCube_r1.f_104204_ = this.getCos(ageInTicks + entity.offset5, -0.375f, -0.525f);
                this.KneeRearLeftCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset6, -0.45f, -0.625f);
            } else {
                this.KneeFrontRightCube_r1.f_104204_ = this.getSine(entity.offset1, 0.2f, 0.475f);
                this.KneeMidRightCube_r1.f_104204_ = this.getCos(entity.offset2, 0.375f, 0.525f);
                this.KneeRearRightCube_r1.f_104204_ = this.getSine(entity.offset3, 0.45f, 0.625f);
                this.KneeFrontLeftCube_r1.f_104204_ = this.getSine(entity.offset4, -0.2f, -0.475f);
                this.KneeMidLeftCube_r1.f_104204_ = this.getCos(entity.offset5, -0.375f, -0.525f);
                this.KneeRearLeftCube_r1.f_104204_ = this.getSine(entity.offset6, -0.45f, -0.625f);
            }
            if (xzSpeed > 0.03) {
                this.WING_RIGHT.f_104204_ = 0.0f;
                wingSpeed = 0.75f;
                this.WING_LEFT.f_104205_ = (float)((double)Mth.m_14089_((float)((limbSwing + ageInTicks) * 2.1f * wingSpeed)) * Math.PI * (double)0.15f);
                this.WING_LEFT.f_104203_ = this.WING_RIGHT.f_104203_;
                this.WING_LEFT.f_104204_ = this.WING_RIGHT.f_104204_;
                this.WING_RIGHT.f_104205_ = -this.WING_LEFT.f_104205_;
            }
        } else {
            this.WING_RIGHT.f_104204_ = 0.0f;
            wingSpeed = isSitting ? 0.75f : 1.0f;
            this.WING_LEFT.f_104205_ = (float)((double)Mth.m_14089_((float)((limbSwing + ageInTicks) * 2.1f * wingSpeed)) * Math.PI * (double)0.15f);
            this.WING_LEFT.f_104203_ = this.WING_RIGHT.f_104203_;
            this.WING_LEFT.f_104204_ = this.WING_RIGHT.f_104204_;
            this.WING_RIGHT.f_104205_ = -this.WING_LEFT.f_104205_;
            this.LEG_FRONTLEFT.f_104203_ = 0.7853982f;
            this.LEG_FRONTRIGHT.f_104203_ = 0.7853982f;
            this.LEG_MIDLEFT.f_104203_ = 0.7853982f;
            this.LEG_MIDRIGHT.f_104203_ = 0.7853982f;
            this.LEG_REARLEFT.f_104203_ = 0.7853982f;
            this.LEG_REARRIGHT.f_104203_ = 0.7853982f;
            this.ROOT.f_104203_ = 0.0f;
            this.ROOT.f_104204_ = 0.0f;
            this.ROOT.f_104205_ = 0.0f;
            this.KneeFrontRightCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset1, 0.2f, 0.475f);
            this.KneeMidRightCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset2, 0.375f, 0.525f);
            this.KneeRearRightCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset3, 0.45f, 0.625f);
            this.KneeFrontLeftCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset4, -0.2f, -0.475f);
            this.KneeMidLeftCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset5, -0.375f, -0.525f);
            this.KneeRearLeftCube_r1.f_104204_ = this.getSine(ageInTicks + entity.offset6, -0.45f, -0.625f);
        }
        this.ROOT.f_104203_ = 0.0f;
        this.ROOT.f_104204_ = 0.0f;
        this.ROOT.f_104205_ = 0.0f;
        float swayingMotion = Mth.m_14031_((float)(ageInTicks * 0.18f));
        if (isSitting) {
            this.ANTENNA_LEFT.f_104203_ = swayingMotion * (float)Math.PI * 0.002f;
            this.ANTENNA_RIGHT.f_104203_ = swayingMotion * (float)Math.PI * 0.002f;
            this.ANTENNA_LEFT.f_104202_ = -0.3f;
            this.ANTENNA_RIGHT.f_104202_ = -0.3f;
            this.ANTENNA_LEFT.f_104201_ = -1.1f;
            this.ANTENNA_RIGHT.f_104201_ = -1.1f;
            this.ANTENNA_LEFT.f_104203_ += 0.2f;
            this.ANTENNA_RIGHT.f_104203_ += 0.2f;
        } else {
            this.ANTENNA_LEFT.f_104203_ = swayingMotion * (float)Math.PI * 0.005f;
            this.ANTENNA_RIGHT.f_104203_ = swayingMotion * (float)Math.PI * 0.005f;
            this.ANTENNA_LEFT.f_104202_ = 0.1f;
            this.ANTENNA_RIGHT.f_104202_ = 0.1f;
            this.ANTENNA_LEFT.f_104201_ = -1.0f;
            this.ANTENNA_RIGHT.f_104201_ = -1.0f;
        }
        if (!onGround) {
            this.ROOT.f_104203_ = 0.1f + swayingMotion * (float)Math.PI * 0.015f;
            this.ROOT.f_104201_ = 19.0f - Mth.m_14089_((float)(ageInTicks * 0.18f)) * 0.9f;
        }
        this.THORAX.f_104203_ = 0.0f;
        float swayingMotion2 = Mth.m_14031_((float)(ageInTicks * 0.18f));
        this.FACE.f_104203_ = (swayingMotion2 + 40.0f) * (float)Math.PI * 0.0025f;
        this.ABDOMEN.f_104203_ = (swayingMotion2 - 40.0f) * (float)Math.PI * 0.0025f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.6f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(0.0, -0.5, 0.0);
        this.ROOT.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

