/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleBase;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleWick;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PotionCandleBlockEntity
extends BlockEntity {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_MAX_DURATION = 12000;
    public static final int DEFAULT_RANGE = 3;
    public static final int DEFAULT_LINGER_TIME = 60;
    public static final int DEFAULT_NIGHT_VISION_LINGER_TIME = 240;
    public static final int DEFAULT_CALCULATED_EFFECT_APPLY_INTERVAL_TIME = 10;
    public static final int MAX_CALCULATED_EFFECT_APPLY_INTERVAL_TIME = 200;
    public static final String COLOR_TAG = "color";
    public static final String STATUS_EFFECT_TAG = "status";
    public static final String EFFECT_LEVEL_TAG = "amplifier";
    public static final String MAX_DURATION_TAG = "max_duration";
    public static final String CURRENT_DURATION_TAG = "current_duration";
    public static final String INSTANT_START_TIME_TAG = "instant_start_time";
    public static final String INFINITE_TAG = "infinite";
    public static final String RANGE_TAG = "range";
    public static final String LINGER_TIME_TAG = "linger_time";
    public static final String CALCULATED_EFFECT_APPLY_INTERVAL_TAG = "calculated_effect_apply_interval";
    private int color = 0xFFFFFF;
    private MobEffect mobEffect = null;
    private int effectLevel = 0;
    private int maxDuration = 12000;
    private int currentDuration = 0;
    private long instantStartTime = 0L;
    private boolean infinite = false;
    private int range = 3;
    private int lingerTime = 60;
    private int calculatedEffectApplyInterval = 10;

    protected PotionCandleBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public PotionCandleBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BzBlockEntities.POTION_CANDLE.get(), blockPos, blockState);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int colorIn) {
        this.color = colorIn;
    }

    public MobEffect getMobEffect() {
        return this.mobEffect;
    }

    public void setMobEffect(MobEffect mobEffect) {
        this.mobEffect = mobEffect;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getEffectLevel() {
        return this.effectLevel;
    }

    public int getCurrentDuration() {
        return this.currentDuration;
    }

    public void resetCurrentDuration() {
        this.currentDuration = 0;
    }

    public void increaseCurrentDuration() {
        ++this.currentDuration;
    }

    public long getInstantStartTime() {
        return this.instantStartTime;
    }

    public void resetInstantStartTime() {
        this.instantStartTime = 0L;
    }

    public void setInstantStartTime(long startTime) {
        this.instantStartTime = startTime;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public int getRange() {
        return this.range;
    }

    public int getLingerTime() {
        return this.lingerTime;
    }

    public int getCalculatedEffectApplyInterval() {
        return this.calculatedEffectApplyInterval;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.color = compoundTag.m_128441_(COLOR_TAG) ? compoundTag.m_128451_(COLOR_TAG) : 0xFFFFFF;
        this.mobEffect = compoundTag.m_128441_(STATUS_EFFECT_TAG) && !compoundTag.m_128461_(STATUS_EFFECT_TAG).trim().equals("") ? (MobEffect)BuiltInRegistries.f_256974_.m_6612_(new ResourceLocation(compoundTag.m_128461_(STATUS_EFFECT_TAG))).orElse(null) : null;
        this.effectLevel = compoundTag.m_128441_(EFFECT_LEVEL_TAG) ? compoundTag.m_128451_(EFFECT_LEVEL_TAG) : 0;
        this.maxDuration = compoundTag.m_128441_(MAX_DURATION_TAG) ? compoundTag.m_128451_(MAX_DURATION_TAG) : 12000;
        this.currentDuration = compoundTag.m_128441_(CURRENT_DURATION_TAG) ? compoundTag.m_128451_(CURRENT_DURATION_TAG) : 0;
        this.instantStartTime = compoundTag.m_128441_(INSTANT_START_TIME_TAG) ? compoundTag.m_128454_(INSTANT_START_TIME_TAG) : 0L;
        this.infinite = this.mobEffect == null || compoundTag.m_128441_(INFINITE_TAG) && compoundTag.m_128471_(INFINITE_TAG);
        this.range = compoundTag.m_128441_(RANGE_TAG) ? compoundTag.m_128451_(RANGE_TAG) : 3;
        int n = this.lingerTime = compoundTag.m_128441_(LINGER_TIME_TAG) ? compoundTag.m_128451_(LINGER_TIME_TAG) : 60;
        if (compoundTag.m_128441_(CALCULATED_EFFECT_APPLY_INTERVAL_TAG)) {
            this.calculatedEffectApplyInterval = compoundTag.m_128451_(CALCULATED_EFFECT_APPLY_INTERVAL_TAG);
        } else {
            boolean isInstant;
            this.calculatedEffectApplyInterval = PotionCandleBlockEntity.createIntervalTimeForEffectApply(this.mobEffect, this.effectLevel, this.lingerTime);
            boolean bl = isInstant = this.mobEffect != null && this.mobEffect.m_8093_();
            if (!isInstant) {
                this.lingerTime += this.calculatedEffectApplyInterval;
            }
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.saveFieldsToTag(compoundTag);
    }

    private void saveFieldsToTag(CompoundTag compoundTag) {
        compoundTag.m_128405_(COLOR_TAG, this.color);
        if (this.mobEffect != null) {
            compoundTag.m_128359_(STATUS_EFFECT_TAG, BuiltInRegistries.f_256974_.m_7981_((Object)this.mobEffect).toString());
        }
        compoundTag.m_128405_(EFFECT_LEVEL_TAG, this.effectLevel);
        compoundTag.m_128405_(MAX_DURATION_TAG, this.maxDuration);
        compoundTag.m_128405_(CURRENT_DURATION_TAG, this.currentDuration);
        compoundTag.m_128356_(INSTANT_START_TIME_TAG, this.instantStartTime);
        compoundTag.m_128379_(INFINITE_TAG, this.mobEffect == null || this.infinite);
        compoundTag.m_128405_(RANGE_TAG, this.range);
        compoundTag.m_128405_(LINGER_TIME_TAG, this.lingerTime);
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)compoundTag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            boolean isInstant = potionCandleBlockEntity.getMobEffect() != null && potionCandleBlockEntity.getMobEffect().m_8093_();
            boolean instantPotionTime = PotionCandleBlockEntity.isInstantEffectApplyTime(level, potionCandleBlockEntity);
            if (blockState.m_61138_((Property)SuperCandleBase.LIT) && ((Boolean)blockState.m_61143_((Property)SuperCandleBase.LIT)).booleanValue()) {
                if (isInstant && instantPotionTime || level.m_46467_() % (long)potionCandleBlockEntity.getCalculatedEffectApplyInterval() == 0L) {
                    if (!potionCandleBlockEntity.isInfinite() && potionCandleBlockEntity.getCurrentDuration() >= potionCandleBlockEntity.getMaxDuration()) {
                        SuperCandleWick.extinguish(null, level.m_8055_(blockPos.m_7494_()), (LevelAccessor)level, blockPos.m_7494_());
                        potionCandleBlockEntity.resetCurrentDuration();
                        potionCandleBlockEntity.resetInstantStartTime();
                    } else if (potionCandleBlockEntity.getMobEffect() != null && (!isInstant || instantPotionTime)) {
                        int diameter = potionCandleBlockEntity.getRange() * 2 + 1;
                        List livingEntities = level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5), (double)diameter, (double)diameter, (double)diameter), e -> true);
                        int lingeringTime = isInstant ? 1 : potionCandleBlockEntity.getLingerTime();
                        for (LivingEntity livingEntity : livingEntities) {
                            MobEffectInstance mobEffectInstance;
                            boolean shouldApply = true;
                            if (!isInstant && livingEntity.m_21023_(potionCandleBlockEntity.getMobEffect())) {
                                mobEffectInstance = livingEntity.m_21124_(potionCandleBlockEntity.getMobEffect());
                                int currentEffectTick = mobEffectInstance.m_19557_();
                                boolean bl = shouldApply = currentEffectTick < lingeringTime - 1;
                            }
                            if (!shouldApply) continue;
                            mobEffectInstance = new MobEffectInstance(potionCandleBlockEntity.getMobEffect(), isInstant ? lingeringTime : lingeringTime + potionCandleBlockEntity.getCalculatedEffectApplyInterval() - 1, Math.max(0, potionCandleBlockEntity.getEffectLevel() - 1), true, true, !potionCandleBlockEntity.getMobEffect().m_8093_());
                            livingEntity.m_7292_(mobEffectInstance);
                        }
                        if (isInstant && level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            PotionCandleBlockEntity.spawnEffectParticles(serverLevel, blockPos, potionCandleBlockEntity.getMobEffect().m_19486_(), potionCandleBlockEntity.getRange());
                        }
                    }
                }
                potionCandleBlockEntity.increaseCurrentDuration();
            }
        }
    }

    public static boolean isInstantEffectApplyTime(Level world, PotionCandleBlockEntity potionCandleBlockEntity) {
        long thresholdTime;
        long trueTimePassed = world.m_46467_() - potionCandleBlockEntity.getInstantStartTime();
        return trueTimePassed % (thresholdTime = PotionCandleBlockEntity.getInstantEffectThresholdTime(potionCandleBlockEntity.getEffectLevel())) == 0L;
    }

    public static long getInstantEffectThresholdTime(int amplifier) {
        return 200L + 150L * (long)((float)(amplifier * amplifier) * 0.6f);
    }

    public static int createIntervalTimeForEffectApply(MobEffect mobEffect, int effectLevel, int durationStartingPoint) {
        if (mobEffect == null) {
            return 10;
        }
        for (int interval = 10; interval < 200; ++interval) {
            if (!mobEffect.m_6584_(interval + durationStartingPoint, effectLevel - 1)) continue;
            return interval;
        }
        return 10;
    }

    public static Vec3 convertIntegerColorToRGB(int color) {
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        Vec3 colorRGB = new Vec3(red, green, blue);
        return colorRGB;
    }

    private static void spawnEffectParticles(ServerLevel world, BlockPos position, boolean beneficial, int range) {
        world.m_8767_((ParticleOptions)(beneficial ? ParticleTypes.f_175827_ : ParticleTypes.f_123771_), (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.7, (double)position.m_123343_() + 0.5, range * 10, (double)(range / 2), (double)(range / 2), (double)(range / 2), 0.1);
    }
}

