/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.blocks.StateReturningBrushableBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.StateFocusedBrushableBlockEntity;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityCollisionContextAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PileOfPollenSuspicious
extends BrushableBlock
implements StateReturningBrushableBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83144_();
    private Item item;

    public PileOfPollenSuspicious() {
        super(null, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60971_((blockState, world, blockPos) -> true).m_60960_((blockState, blockGetter, blockPos) -> false).m_60955_().m_60910_().m_60978_(0.1f).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56747_), SoundEvents.f_271174_, SoundEvents.f_271452_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new StateFocusedBrushableBlockEntity(blockPos, blockState);
    }

    public Block m_277074_() {
        return BzBlocks.PILE_OF_POLLEN.get();
    }

    @Override
    public BlockState getTurnsIntoState() {
        return (BlockState)BzBlocks.PILE_OF_POLLEN.get().m_49966_().m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(8));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get());
    }

    public Item m_5456_() {
        if (this.item == null) {
            this.item = BzItems.POLLEN_PUFF.get();
        }
        return this.item;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter world, BlockPos blockPos, PathComputationType pathType) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).m_193113_()) != null && entity.m_6095_() != BzEntities.POLLEN_PUFF_ENTITY.get()) {
            StackTraceElement[] stackTrace;
            boolean found;
            context.m_7142_(Items.f_41852_);
            ItemStack heldItem = ((EntityCollisionContextAccessor)ctx).bumblezone$getHeldItem();
            if (heldItem != null && !heldItem.m_41619_() && (PlatformHooks.isToolAction(heldItem, BrushItem.class, "brush_brush") || heldItem.m_204117_(BzTags.SUSPICIOUS_PILE_OF_POLLEN_ADDITIONAL_BRUSHES)) && (found = Arrays.stream(stackTrace = Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).anyMatch(c -> c.equals(Items.f_271356_.getClass().getName()) || c.equals(heldItem.m_41720_().getClass().getName())))) {
                return this.m_5940_(state, worldIn, pos, context);
            }
            return Shapes.m_83040_();
        }
        return this.m_5940_(state, worldIn, pos, context);
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE;
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        BlockState blockstate = world.m_8055_(blockPos.m_7495_());
        if (blockstate.m_204336_(BlockTags.f_215833_) || !world.m_8055_(blockPos).m_60819_().m_76178_()) {
            return false;
        }
        if (blockstate.m_60795_() || blockstate.m_204336_(BzTags.POLLEN_BLOCKS) || blockstate.m_204336_(BlockTags.f_215834_)) {
            return true;
        }
        return GeneralUtils.isFaceFullFast(blockstate.m_60812_((BlockGetter)world, blockPos.m_7495_()), Direction.UP);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockState belowState;
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof BrushableBlockEntity) {
            BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)blockEntity;
            brushableBlockEntity.m_277175_();
        }
        if (!FallingBlock.m_53241_((BlockState)(belowState = serverLevel.m_8055_(blockPos.m_7495_()))) || belowState.m_60713_(BzBlocks.PILE_OF_POLLEN.get()) && (Integer)belowState.m_61143_((Property)PileOfPollen.LAYERS) == 8 || blockPos.m_123342_() < serverLevel.m_141937_()) {
            return;
        }
        FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
        fallingBlockEntity.m_272001_();
    }

    public BlockState m_7417_(BlockState oldBlockState, Direction direction, BlockState newBlockState, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return !oldBlockState.m_60710_((LevelReader)world, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (world.m_5776_()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollenSuspicious.spawnParticles(blockState, world, blockPos, world.m_213780_(), true);
                PileOfPollenSuspicious.spawnParticles(world, Vec3.m_82512_((Vec3i)blockPos), world.m_213780_(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        if (!blockState.m_60713_(BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get())) {
            return;
        }
        if (!(entity instanceof ExperienceOrb)) {
            LivingEntity livingEntity;
            int layerValueMinusOne = 7;
            double entitySpeed = entity.m_20184_().m_82553_();
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            Pair reduction = PileOfPollen.APPLIED_FALL_REDUCTION_FOR_ENTITY.getOrDefault(entity.m_20149_(), null);
            if (reduction == null || (Integer)reduction.getFirst() != entity.f_19797_ || (Integer)reduction.getSecond() < layerValueMinusOne && (Integer)reduction.getFirst() == entity.f_19797_) {
                int diffInLayer = reduction == null ? layerValueMinusOne : layerValueMinusOne - (Integer)reduction.getSecond();
                PileOfPollen.slowFallSpeed(entity, blockPos, diffInLayer);
                PileOfPollen.APPLIED_FALL_REDUCTION_FOR_ENTITY.put(entity.m_20149_(), (Pair<Integer, Integer>)Pair.of((Object)entity.f_19797_, (Object)layerValueMinusOne));
            }
            if (entitySpeed > 1.0E-5 && (double)world.f_46441_.m_188501_() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof ItemEntity ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.m_5776_()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollenSuspicious.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.f_46441_, true);
                        }
                        PileOfPollenSuspicious.spawnParticles((LevelAccessor)world, entity.m_20182_().m_82549_(entity.m_20184_().m_82542_(2.0, 2.0, 2.0)).m_82520_(0.0, 0.75, 0.0), world.f_46441_, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof Player) && !(entity instanceof ItemEntity)) {
                    PileOfPollenSuspicious.spawnParticlesServer((LevelAccessor)world, entity.m_20182_().m_82549_(entity.m_20184_().m_82542_(2.0, 2.0, 2.0)).m_82520_(0.0, 0.75, 0.0), world.f_46441_, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof Panda) {
                Panda pandaEntity = (Panda)entity;
                PileOfPollenSuspicious.pandaSneezing(pandaEntity);
            }
            if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_21023_(BzEffects.HIDDEN.get())) {
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos);
            }
        }
    }

    public static void pandaSneezing(Panda pandaEntity) {
        if (!pandaEntity.m_9236_().m_5776_() && pandaEntity.m_217043_().m_188501_() < 0.005f && pandaEntity.m_9236_().m_8055_(pandaEntity.m_20183_()).m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            pandaEntity.m_29220_(true);
        }
    }

    public void m_214162_(BlockState blockState, Level world, BlockPos blockPos, RandomSource random) {
        double chance = 0.08f;
        if ((double)random.m_188501_() < chance) {
            PileOfPollenSuspicious.spawnParticles(blockState, (LevelAccessor)world, blockPos, random, false);
        }
    }

    public static void spawnParticles(BlockState blockState, LevelAccessor world, BlockPos blockPos, RandomSource random, boolean disturbed) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.m_121945_(direction);
            if (world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            VoxelShape currentShape = SHAPE;
            double yHeight = currentShape.m_83297_(Direction.Axis.Y) - currentShape.m_83288_(Direction.Axis.Y);
            Direction.Axis directionAxis = direction.m_122434_();
            double xOffset = directionAxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double yOffset = directionAxis == Direction.Axis.Y ? yHeight * (double)direction.m_122430_() : (double)random.m_188501_() * yHeight;
            double zOffset = directionAxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            world.m_7106_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)blockPos.m_123341_() + xOffset, (double)blockPos.m_123342_() + yOffset, (double)blockPos.m_123343_() + zOffset, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + (disturbed ? 0.01 : 0.0), random.m_188583_() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double yOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double zOffset = (double)random.m_188501_() * 0.3 - 0.15;
        world.m_7106_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.m_7096_() + xOffset, location.m_7098_() + yOffset, location.m_7094_() + zOffset, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + initYSpeed, random.m_188583_() * speedXZModifier);
    }

    public static void spawnParticlesServer(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.m_5776_()) {
            return;
        }
        double xOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double yOffset = (double)random.m_188501_() * 0.3 - 0.15;
        double zOffset = (double)random.m_188501_() * 0.3 - 0.15;
        ((ServerLevel)world).m_8767_((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.m_7096_() + xOffset, location.m_7098_() + yOffset, location.m_7094_() + zOffset, numberOfParticles, random.m_188583_() * speedXZModifier, random.m_188583_() * speedYModifier + initYSpeed, random.m_188583_() * speedXZModifier, (double)0.02f);
    }
}

