/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class FireplaceBlock
extends WaterloggedBlock {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<BlockStatePropertiesAA.HorizontalConnection> HORIZONTAL_CONNECTION = BlockStatePropertiesAA.HORIZONTAL_CONNECTION;

    public FireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.FIREPLACE_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_(HORIZONTAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.HorizontalConnection.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HORIZONTAL_AXIS, LIT, HORIZONTAL_CONNECTION});
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X ? 1 : 3);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? 0 : 1;
        }
        return (Boolean)state.m_61143_((Property)LIT) != false ? 2 : 3;
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)(stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos)).m_61143_((Property)WATERLOGGED)).booleanValue()) {
            stateIn = (BlockState)stateIn.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        } else if (facing.m_122434_() == stateIn.m_61143_(HORIZONTAL_AXIS) && facingState.m_60734_() == this && !((Boolean)facingState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            stateIn = (BlockState)stateIn.m_61124_((Property)LIT, (Comparable)((Boolean)facingState.m_61143_((Property)LIT)));
        }
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return Utils.changeBlockLitStateWithItemOrCreativePlayer(state, worldIn, pos, player, handIn) >= 0 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (projectile instanceof AbstractArrow && projectile.m_6060_() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)((ThrownPotion)projectile).m_7846_()).m_43488_().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.m_82425_();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(isActivated)), 10);
                worldIn.m_5594_(null, pos, isActivated ? SoundEvents.f_11936_ : SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.m_5776_()) {
                for (int i = 0; i < worldIn.f_46441_.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                }
            }
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entityIn) {
        if (!entityIn.m_5825_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(entityIn.m_269291_().m_269387_(), 1.0f);
        }
        super.m_7892_(state, world, pos, entityIn);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        Direction.Axis axis = context.m_8125_().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)((BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)axis)).m_61124_(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getHorizontalShape(context.m_43725_(), context.m_8083_(), axis)));
    }

    private BlockStatePropertiesAA.HorizontalConnection getHorizontalShape(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean blockRight;
        BlockState left = worldIn.m_8055_(pos.m_5484_(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH, 1));
        BlockState right = worldIn.m_8055_(pos.m_5484_(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH, -1));
        boolean blockLeft = left.m_60734_() instanceof FireplaceBlock;
        if (blockLeft) {
            boolean bl = blockLeft = left.m_61143_(HORIZONTAL_AXIS) == axis;
        }
        if (blockRight = right.m_60734_() instanceof FireplaceBlock) {
            boolean bl = blockRight = right.m_61143_(HORIZONTAL_AXIS) == axis;
        }
        if (blockLeft) {
            return blockRight ? BlockStatePropertiesAA.HorizontalConnection.BOTH : BlockStatePropertiesAA.HorizontalConnection.LEFT;
        }
        return blockRight ? BlockStatePropertiesAA.HorizontalConnection.RIGHT : BlockStatePropertiesAA.HorizontalConnection.NONE;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || fluid.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WaterloggedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 10);
        world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
        return true;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.m_188503_(10) == 0) {
                worldIn.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.6f, false);
            }
            if (rand.m_188503_(10) == 0) {
                for (int i = 0; i < rand.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(rand.m_188501_() / 4.0f), 2.5E-5, (double)(rand.m_188501_() / 4.0f));
                }
            }
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5 + rand.m_188500_() / 3.0 * (double)(rand.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + rand.m_188500_() / 3.0 * (double)(rand.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        return rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90 ? (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) : state;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "fireplace");
    }
}

