/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Collectors;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class KegRecipes
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public KegRecipes(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (container == null) {
            return false;
        }
        if (container.m_6643_() != this.recipeItems.size()) {
            return false;
        }
        NonNullList remainingIngredients = NonNullList.m_122779_();
        remainingIngredients.addAll(this.recipeItems);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemInContainer = container.m_8020_(i);
            if (itemInContainer.m_41619_()) continue;
            boolean foundMatch = false;
            for (int j = 0; j < remainingIngredients.size(); ++j) {
                if (!((Ingredient)remainingIngredients.get(j)).test(itemInContainer)) continue;
                remainingIngredients.remove(j);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return remainingIngredients.isEmpty();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 4;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipesRegistry.KEG_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get();
    }

    public static NonNullList<KegRecipes> getAll(Level world) {
        return world.m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6671_() == RecipesRegistry.KEG_RECIPE_TYPE.get()).map(recipe -> (KegRecipes)recipe).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    public static class Serializer
    implements RecipeSerializer<KegRecipes> {
        @NotNull
        public KegRecipes fromJson(ResourceLocation id, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            if (ingredients.size() != 4) {
                throw new IllegalArgumentException("KegRecipes requires exactly 4 ingredients!");
            }
            NonNullList inputs = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < 4; ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new KegRecipes(id, output, (NonNullList<Ingredient>)inputs);
        }

        @NotNull
        public KegRecipes fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            inputs.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            return new KegRecipes(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, KegRecipes recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
        }
    }
}

