/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import java.util.Optional;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.helpers.ImplementedInventory;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KegEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
BlockEntityTicker<KegEntity> {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int progress = 0;
    private final int maxProgress = 18000;
    public final int maxWaterLevel = 40;
    public int waterLevel = 0;
    public int beerLevel = 0;
    public int beerType = 0;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> KegEntity.this.progress;
                case 1 -> 18000;
                case 2 -> KegEntity.this.waterLevel;
                case 3 -> KegEntity.this.beerLevel;
                case 4 -> KegEntity.this.beerType;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    KegEntity.this.progress = value;
                    break;
                }
                case 2: {
                    KegEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    KegEntity.this.beerLevel = value;
                    break;
                }
                case 4: {
                    KegEntity.this.beerType = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public KegEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.KEG_ENTITY.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.alcocraftplus.keg");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new KegGuiHandler(id, inventory, (Container)this, this.propertyDelegate);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress = nbt.m_128451_("progress");
        this.waterLevel = nbt.m_128451_("waterLevel");
        this.beerLevel = nbt.m_128451_("beerLevel");
        this.beerType = nbt.m_128451_("beerType");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128405_("waterLevel", this.waterLevel);
        nbt.m_128405_("beerLevel", this.beerLevel);
        nbt.m_128405_("beerType", this.beerType);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return false;
    }

    public void tick(Level level, BlockPos pos, BlockState state, KegEntity entity) {
        if (!level.m_5776_()) {
            RandomSource random = level.f_46441_;
            if (KegEntity.canBrew(entity)) {
                ++entity.progress;
                if (random.m_188501_() < 0.005f) {
                    level.m_5594_(null, pos, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.1f, 0.5f);
                }
                if (entity.progress >= entity.maxProgress) {
                    this.brew(level, pos, state, entity);
                }
            } else {
                entity.resetProgress();
            }
            KegEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    private void brew(Level level, BlockPos pos, BlockState state, KegEntity entity) {
        Level pLevel = entity.m_58904_();
        SimpleContainer inventory = new SimpleContainer(entity.inventory.size());
        for (int i = 0; i < entity.inventory.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)entity.inventory.get(i));
        }
        Optional match = pLevel.m_7465_().m_44015_((RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get(), (Container)inventory, pLevel);
        match.ifPresent(recipe -> {
            for (int i = 0; i < entity.inventory.size(); ++i) {
                if (((ItemStack)entity.inventory.get(i)).m_41619_()) continue;
                ((ItemStack)entity.inventory.get(i)).m_41774_(1);
            }
            entity.beerType = BeerTypeMapperUtil.getBeerType(recipe.m_8043_(level.m_9598_()).m_41720_());
            entity.beerLevel = entity.waterLevel;
            entity.waterLevel = 0;
            entity.resetProgress();
            KegEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        });
    }

    private static boolean canBrew(KegEntity entity) {
        SimpleContainer container = new SimpleContainer((ItemStack[])entity.inventory.toArray((Object[])new ItemStack[0]));
        Optional recipes = entity.f_58857_.m_7465_().m_44015_((RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get(), (Container)container, entity.f_58857_);
        return recipes.isPresent() && !KegEntity.hasBeer(entity) && KegEntity.hasWater(entity);
    }

    private static boolean hasWater(KegEntity entity) {
        return entity.waterLevel > 0;
    }

    private static boolean hasBeer(KegEntity entity) {
        return entity.beerLevel > 0;
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

