/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import me.itzme1on.alcocraftplus.core.blocks.keg.KegEntity;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Keg
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape KEG_SHAPE;
    private static final VoxelShape SHAPE_NORTH;
    private static final VoxelShape SHAPE_EAST;
    private static final VoxelShape SHAPE_SOUTH;
    private static final VoxelShape SHAPE_WEST;

    private static VoxelShape rotateShape(Direction to) {
        VoxelShape[] buffer = new VoxelShape[]{SHAPE_NORTH, Shapes.m_83040_()};
        int times = (to.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public Keg(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Rotation rotation = mirror.m_54846_((Direction)state.m_61143_((Property)FACING));
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KegEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        BlockEntity entity = level.m_7702_(pos);
        if (!(entity instanceof KegEntity)) {
            return InteractionResult.PASS;
        }
        KegEntity keg = (KegEntity)entity;
        ItemStack heldItem = player.m_21120_(hand);
        if (this.canPourBeer(heldItem, keg)) {
            return this.handlePouringBeer(player, hand, keg);
        }
        if (this.canAddWater(heldItem, keg)) {
            return this.handleAddingWater(level, pos, player, hand, keg);
        }
        return this.openKegScreen(state, level, pos, player);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && !player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof KegEntity) {
            KegEntity kegEntity = (KegEntity)blockEntity;
            kegEntity.getItems().forEach(stack -> {
                if (!stack.m_41619_()) {
                    Keg.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            });
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Keg.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntitiesRegistry.KEG_ENTITY.get()), (world, pos, st, entity) -> {
            if (entity != null) {
                entity.tick(world, pos, st, (KegEntity)entity);
            }
        });
    }

    private boolean canPourBeer(ItemStack heldItem, KegEntity keg) {
        return heldItem.m_150930_((Item)ItemsRegistry.MUG.get()) && keg.beerLevel >= 4;
    }

    private InteractionResult handlePouringBeer(Player player, InteractionHand hand, KegEntity keg) {
        ItemStack beerStack;
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        if (!(beerStack = BeerTypeMapperUtil.getBeerStack(keg.beerType)).m_41619_()) {
            ItemStack pouredBeer = beerStack.m_41777_();
            player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)ItemsRegistry.MUG.get())));
            if (player.m_150109_().m_36054_(pouredBeer)) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                player.m_36176_(pouredBeer, false);
            }
        }
        keg.beerLevel -= 4;
        return InteractionResult.SUCCESS;
    }

    private boolean canAddWater(ItemStack heldItem, KegEntity keg) {
        return heldItem.m_150930_(Items.f_42447_) && keg.waterLevel <= keg.maxWaterLevel - 10 && keg.beerLevel == 0;
    }

    private InteractionResult handleAddingWater(Level level, BlockPos pos, Player player, InteractionHand hand, KegEntity keg) {
        keg.waterLevel += 10;
        level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        player.m_146852_(GameEvent.f_157769_, (Entity)player);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult openKegScreen(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider screenHandlerFactory = state.m_60750_(level, pos);
        if (screenHandlerFactory != null) {
            player.m_5893_(screenHandlerFactory);
            level.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 0.8f);
            level.m_5594_(null, pos, SoundEvents.f_11725_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        SHAPE_NORTH = KEG_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)16.0, (double)7.0, (double)9.0, (double)17.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0), Block.m_49796_((double)2.0, (double)4.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.m_49796_((double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)4.0, (double)2.0), Block.m_49796_((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)14.0, (double)15.0), Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)15.0), Block.m_49796_((double)3.0, (double)14.0, (double)14.0, (double)13.0, (double)15.0, (double)15.0), Block.m_49796_((double)14.0, (double)4.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)3.0, (double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0), Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0), Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0), Block.m_49796_((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0), Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)1.0, (double)4.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)4.0), Block.m_49796_((double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0, (double)4.0), Block.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)5.0, (double)1.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)14.0), Block.m_49796_((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0, (double)14.0)});
        SHAPE_EAST = Keg.rotateShape(Direction.EAST);
        SHAPE_SOUTH = Keg.rotateShape(Direction.SOUTH);
        SHAPE_WEST = Keg.rotateShape(Direction.WEST);
    }
}

