/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.hooks.fluid.FluidStackHooks;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.utils.ColorUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KegGui
extends AbstractContainerScreen<KegGuiHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alcocraftplus", "textures/gui/keg_gui.png");
    private static final ResourceLocation BG = new ResourceLocation("alcocraftplus", "textures/gui/dark_bg.png");
    private static final Fluid fluid = Fluids.f_76193_;
    private static final int[] BUBBLE_LENGTHS = new int[]{0, 6, 11, 16, 20, 24, 28};
    private int bubbleAnimationTimer;
    private final int animationDurationTicks = 100;

    public KegGui(KegGuiHandler menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG);
        int x = (this.f_96543_ - this.f_97726_) / 2 + 3;
        int y = (this.f_96544_ - this.f_97727_) / 2 + 3;
        guiGraphics.m_280218_(BG, x, y, 0, 0, this.f_97726_ - 6, this.f_97727_ - 6);
        this.renderFluid(guiGraphics, x, y);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        x = (this.f_96543_ - this.f_97726_) / 2;
        y = (this.f_96544_ - this.f_97727_) / 2 - 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_ + 2);
        this.renderProgressBars(guiGraphics, x, y);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (((KegGuiHandler)this.f_97732_).isCrafting(0)) {
            ++this.bubbleAnimationTimer;
            if (this.bubbleAnimationTimer >= 100) {
                this.bubbleAnimationTimer = 0;
            }
        } else {
            this.bubbleAnimationTimer = 0;
        }
    }

    private void renderProgressBars(GuiGraphics guiGraphics, int x, int y) {
        if (((KegGuiHandler)this.f_97732_).isCrafting(0)) {
            int bubbleIndex = this.bubbleAnimationTimer * BUBBLE_LENGTHS.length / 100;
            if (bubbleIndex >= BUBBLE_LENGTHS.length) {
                bubbleIndex = 0;
            }
            int bubbleHeight = this.getBubbleHeight(bubbleIndex);
            guiGraphics.m_280218_(TEXTURE, x + 150, y + 17 + 28 - bubbleHeight, 176, 28 - bubbleHeight, 11, bubbleHeight);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, ColorUtil.getColorFromRGB(215, 171, 121));
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, ColorUtil.getColorFromRGB(64, 64, 64), false);
        this.renderTimer(guiGraphics);
    }

    private void renderTimer(GuiGraphics guiGraphics) {
        int colorShadow = ColorUtil.getColorFromRGB(97, 69, 36);
        int colorText = ColorUtil.getColorFromRGB(215, 171, 121);
        int progress = ((KegGuiHandler)this.f_97732_).getProgress();
        int maxProgress = ((KegGuiHandler)this.f_97732_).getMaxProgress();
        if (!((KegGuiHandler)this.f_97732_).isCrafting(0)) {
            guiGraphics.m_280488_(this.f_96547_, "00:00", 143, 47, colorShadow);
            guiGraphics.m_280488_(this.f_96547_, "00:00", 143, 47, colorText);
        } else if (maxProgress > 0) {
            int remainingProgress = maxProgress - progress;
            int timeInSeconds = (int)((float)remainingProgress / (float)maxProgress * ((float)maxProgress / 20.0f));
            String formattedTime = this.formatTime(timeInSeconds);
            guiGraphics.m_280488_(this.f_96547_, formattedTime, 143, 47, colorShadow);
            guiGraphics.m_280488_(this.f_96547_, formattedTime, 143, 47, colorText);
        } else {
            guiGraphics.m_280488_(this.f_96547_, "00:00", 143, 47, colorShadow);
            guiGraphics.m_280488_(this.f_96547_, "00:00", 143, 47, colorText);
        }
    }

    private void renderFluid(GuiGraphics guiGraphics, int x, int y) {
        int color;
        int beerLevel = ((KegGuiHandler)this.f_97732_).getBeerLevel();
        int beerType = ((KegGuiHandler)this.f_97732_).getBeerType();
        int waterLevel = ((KegGuiHandler)this.f_97732_).getWaterLevel();
        int maxWaterLevel = 40;
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((Fluid)fluid);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        if (beerLevel > 0) {
            color = this.getBeerColor(beerType);
            this.renderFluidArea(guiGraphics, x, y, beerLevel, maxWaterLevel, color, sprite);
        }
        if (waterLevel > 0 && beerLevel < maxWaterLevel) {
            color = FluidStackHooks.getColor((Fluid)fluid);
            this.renderFluidArea(guiGraphics, x, y, waterLevel, maxWaterLevel, color, sprite);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderFluidArea(GuiGraphics guiGraphics, int x, int y, int fluidLevel, int maxFluidLevel, int color, TextureAtlasSprite sprite) {
        int textureWidth = 16;
        int textureHeight = 16;
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        int numRowsToDraw = (int)Math.ceil((double)fluidLevel / ((double)maxFluidLevel / 4.0));
        numRowsToDraw = Math.min(numRowsToDraw, 4);
        for (int row = 0; row < numRowsToDraw; ++row) {
            for (int col = 0; col <= 8; ++col) {
                guiGraphics.m_280159_(x + textureWidth * col, y + textureHeight * (3 - row), 0, textureWidth, textureHeight, sprite);
            }
        }
    }

    private int getBeerColor(int beerType) {
        return switch (beerType) {
            case 1 -> ColorUtil.getColorFromRGB(222, 167, 81);
            case 2 -> ColorUtil.getColorFromRGB(201, 125, 31);
            case 3 -> ColorUtil.getColorFromRGB(107, 30, 5);
            case 4 -> ColorUtil.getColorFromRGB(29, 5, 3);
            case 5 -> ColorUtil.getColorFromRGB(170, 14, 1);
            case 6 -> ColorUtil.getColorFromRGB(75, 165, 128);
            case 7 -> ColorUtil.getColorFromRGB(58, 70, 123);
            case 8 -> ColorUtil.getColorFromRGB(143, 181, 246);
            case 9 -> ColorUtil.getColorFromRGB(188, 137, 39);
            case 10 -> ColorUtil.getColorFromRGB(69, 201, 72);
            case 11 -> ColorUtil.getColorFromRGB(142, 102, 141);
            case 12 -> ColorUtil.getColorFromRGB(199, 183, 0);
            default -> ColorUtil.getColorFromRGB(255, 255, 255);
        };
    }

    private String formatTime(int time) {
        int minutes = time / 60;
        int seconds = time % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private int getBubbleHeight(int progress) {
        return BUBBLE_LENGTHS[progress % BUBBLE_LENGTHS.length];
    }
}

