/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.google.common.base.Preconditions;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.ItemHeartAmulet;
import com.traverse.bhc.common.items.ItemSoulHeartAmulet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="bhc")
public class HealthModifier {
    public static final UUID HEALTH_MODIFIER_ID = UUID.fromString("caa44aa0-9e6e-4a57-9759-d2f64abfb7d3");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() == RegistryHandler.HEART_AMULET.get()) {
            final ICurio curio = new ICurio(){

                public ItemStack getStack() {
                    return new ItemStack((ItemLike)RegistryHandler.HEART_AMULET.get());
                }

                public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                    LivingEntity livingEntity = slotContext.getWearer();
                    Optional stackOptional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)RegistryHandler.HEART_AMULET.get(), livingEntity);
                    stackOptional.ifPresent(triple -> {
                        if (livingEntity instanceof Player) {
                            ItemStack stack = (ItemStack)triple.getRight();
                            HealthModifier.updatePlayerHealth((Player)livingEntity, stack, true);
                        }
                    });
                }

                public boolean canRightClickEquip() {
                    return false;
                }

                public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                    LivingEntity livingEntity = slotContext.entity();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        HealthModifier.updatePlayerHealth(player, ItemStack.f_41583_, false);
                    }
                }
            };
            ICapabilityProvider provider = new ICapabilityProvider(){
                private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
                }
            };
            event.addCapability(CuriosCapability.ID_ITEM, provider);
        } else if (((ItemStack)event.getObject()).m_41720_() == RegistryHandler.SOUL_HEART_AMULET.get()) {
            final ICurio curio = new ICurio(){

                public ItemStack getStack() {
                    return new ItemStack((ItemLike)RegistryHandler.SOUL_HEART_AMULET.get());
                }

                public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                    LivingEntity livingEntity = slotContext.getWearer();
                    Optional stackOptional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)RegistryHandler.SOUL_HEART_AMULET.get(), livingEntity);
                    stackOptional.ifPresent(triple -> {
                        if (livingEntity instanceof Player) {
                            ItemStack stack = (ItemStack)triple.getRight();
                            HealthModifier.updatePlayerHealth((Player)livingEntity, stack, true);
                        }
                    });
                }

                public boolean canRightClickEquip() {
                    return false;
                }

                public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                    if (slotContext.getWearer() instanceof Player) {
                        HealthModifier.updatePlayerHealth((Player)slotContext.getWearer(), ItemStack.f_41583_, false);
                    }
                }
            };
            ICapabilityProvider provider = new ICapabilityProvider(){
                private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
                }
            };
            event.addCapability(CuriosCapability.ID_ITEM, provider);
        }
    }

    public static void updatePlayerHealth(Player player, ItemStack stack, boolean addHealth) {
        int i;
        AttributeInstance health = player.m_21051_(Attributes.f_22276_);
        float diff = player.m_21233_() - player.m_21223_();
        int[] hearts = new int[4];
        if (addHealth && !stack.m_41619_()) {
            int[] amuletHearts = null;
            Item item = stack.m_41720_();
            if (item instanceof ItemHeartAmulet) {
                ItemHeartAmulet amulet = (ItemHeartAmulet)item;
                amuletHearts = amulet.getHeartCount(stack);
            } else {
                item = stack.m_41720_();
                if (item instanceof ItemSoulHeartAmulet) {
                    ItemSoulHeartAmulet amulet = (ItemSoulHeartAmulet)item;
                    amuletHearts = amulet.getHeartCount(stack);
                }
            }
            Preconditions.checkArgument((amuletHearts != null ? 1 : 0) != 0, (Object)"amuletHearts was never initialized - is this a soul canister?");
            for (i = 0; i < hearts.length; ++i) {
                int n = i;
                hearts[n] = hearts[n] + amuletHearts[i];
            }
        }
        int extraHearts = 0;
        for (i = 0; i < hearts.length; ++i) {
            extraHearts += Mth.m_14045_((int)hearts[i], (int)0, (int)((Integer)ConfigHandler.general.heartStackSize.get() * 2));
        }
        AttributeModifier modifier = health.m_22111_(HEALTH_MODIFIER_ID);
        if (modifier != null) {
            if (modifier.m_22218_() == (double)extraHearts) {
                return;
            }
            health.m_22130_(modifier);
        }
        health.m_22125_(new AttributeModifier(HEALTH_MODIFIER_ID, "bhc:extra_hearts", (double)extraHearts, AttributeModifier.Operation.ADDITION));
        float amount = Mth.m_14036_((float)(player.m_21233_() - diff), (float)0.0f, (float)player.m_21233_());
        if (amount > 0.0f) {
            player.m_21153_(amount);
        } else {
            player.m_6915_();
            player.m_6074_();
        }
    }
}

