/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cached {
    public static final Map<String, WeakReference<ServerLevel>> LEVELS_BY_NAME = new HashMap<String, WeakReference<ServerLevel>>(8);
    public static final Cache<UUID, Entity> ENTITIES_BY_UUID = CacheBuilder.newBuilder().weakValues().expireAfterAccess(Duration.ofMinutes(30L)).initialCapacity(8).build();

    @Nullable
    public static ServerLevel getLevelByName(@NotNull Iterable<ServerLevel> levels, @NotNull String name) {
        ServerLevel l;
        if (LEVELS_BY_NAME.containsKey(name) && (l = (ServerLevel)LEVELS_BY_NAME.get(name).get()) != null) {
            return l;
        }
        for (ServerLevel l2 : levels) {
            if (!name.equals(l2.m_46472_().m_135782_().toString())) continue;
            LEVELS_BY_NAME.put(name, new WeakReference<ServerLevel>(l2));
            return l2;
        }
        return null;
    }

    @Nullable
    public static Entity getEntityByUUID(@NotNull Iterable<ServerLevel> levels, @NotNull UUID uuid) {
        Entity cached = (Entity)ENTITIES_BY_UUID.getIfPresent((Object)uuid);
        if (cached != null) {
            return cached;
        }
        for (ServerLevel l : levels) {
            Entity entity = (Entity)l.m_142646_().m_142694_(uuid);
            if (entity == null) continue;
            ENTITIES_BY_UUID.put((Object)uuid, (Object)entity);
            return entity;
        }
        return null;
    }
}

