/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.entity.monster.DeathTome;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.network.CreateMovingCicadaSoundPacket;
import twilightforest.network.TFPacketHandler;

@Mod.EventBusSubscriber(modid="twilightforest")
public class MiscEvents {
    @SubscribeEvent
    public static void addPrey(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EntityType type = mob.m_6095_();
            if (type == EntityType.f_20553_) {
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, DwarfRabbit.class, true, null));
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Squirrel.class, true, null));
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, TinyBird.class, true, null));
            } else if (type == EntityType.f_20505_) {
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, true));
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, true));
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, TinyBird.class, true));
            } else if (type == EntityType.f_20452_) {
                mob.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, true));
                mob.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, true));
            } else if (type == EntityType.f_20499_) {
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, DwarfRabbit.class, true, null));
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Squirrel.class, true, null));
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)mob, Bighorn.class, true, null));
            }
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        LivingEntity living = event.getEntity();
        if (ModList.get().isLoaded("curios") && CuriosCompat.isCicadaEquipped(living)) {
            return;
        }
        if (living != null && !living.m_9236_().m_5776_() && event.getSlot() == EquipmentSlot.HEAD && event.getTo().m_150930_(((Block)TFBlocks.CICADA.get()).m_5456_())) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new CreateMovingCicadaSoundPacket(living.m_19879_()));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SpawnEggItem spawnEggItem;
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(event.getHand());
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem && (spawnEggItem = (SpawnEggItem)item).m_43228_(stack.m_41783_()) == TFEntities.DEATH_TOME.get()) {
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().m_8055_(pos);
            if (state.m_60734_() instanceof LecternBlock && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61440_)).booleanValue()) {
                event.setCanceled(true);
                event.getLevel().m_5594_(null, pos, SoundEvents.f_11714_, SoundSource.BLOCKS, 1.0f, 1.0f);
                Level level = event.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    DeathTome tome = (DeathTome)((EntityType)TFEntities.DEATH_TOME.get()).m_20592_(serverLevel, stack, player, pos.m_7495_(), MobSpawnType.SPAWN_EGG, true, false);
                    if (tome != null) {
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        serverLevel.m_142346_((Entity)player, GameEvent.f_157810_, pos);
                        tome.setOnLectern(true);
                    }
                }
            }
        }
    }
}

