/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shaped_nbt;

import de.geheimagentnr1.recipes_lib.elements.recipes.ModRecipeSerializersRegisterFactory;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedNBTRecipe
extends NBTRecipe
implements IShapedRecipe<CraftingContainer> {
    @NotNull
    public static final String registry_name = "crafting_shaped_nbt";
    private final int recipeWidth;
    private final int recipeHeight;

    ShapedNBTRecipe(@NotNull ResourceLocation _id, @NotNull String _group, @NotNull NonNullList<Ingredient> _ingredients, @NotNull ItemStack _result, boolean _merge_nbt, int _recipeWidth, int _recipeHeight) {
        super(_id, _group, _ingredients, _result, _merge_nbt);
        this.recipeWidth = _recipeWidth;
        this.recipeHeight = _recipeHeight;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializersRegisterFactory.SHAPED_NBT;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public boolean matches(@NotNull CraftingContainer container, @NotNull Level level) {
        for (int x = 0; x <= container.m_39347_() - this.recipeWidth; ++x) {
            for (int y = 0; y <= container.m_39346_() - this.recipeHeight; ++y) {
                if (this.checkMatch(container, x, y, true)) {
                    return true;
                }
                if (!this.checkMatch(container, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(@NotNull CraftingContainer container, int x0, int y0, boolean turned) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        for (int x = 0; x < container.m_39347_(); ++x) {
            for (int y = 0; y < container.m_39346_(); ++y) {
                int dx = x - x0;
                int dy = y - y0;
                Ingredient ingredient = Ingredient.f_43901_;
                if (dx >= 0 && dy >= 0 && dx < this.recipeWidth && dy < this.recipeHeight) {
                    ingredient = turned ? (Ingredient)ingredients.get(this.recipeWidth - dx - 1 + dy * this.recipeWidth) : (Ingredient)ingredients.get(dx + dy * this.recipeWidth);
                }
                if (ingredient.test(container.m_8020_(x + y * container.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }
}

