/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;

public abstract class AbstractMaterialCastingRecipe
extends AbstractCastingRecipe {
    protected static final LoadableField<Integer, AbstractMaterialCastingRecipe> ITEM_COST_FIELD = IntLoadable.FROM_ONE.requiredField("item_cost", r -> r.itemCost);
    private final RecipeSerializer<?> serializer;
    protected final int itemCost;

    public AbstractMaterialCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, boolean consumed, boolean switchSlots) {
        super(serializer.getType(), id, group, cast, consumed, switchSlots);
        this.serializer = serializer;
        this.itemCost = itemCost;
    }

    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        return MaterialCastingLookup.getCastingFluid(inv.getFluid());
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv);
        if (recipe != MaterialFluidRecipe.EMPTY) {
            return ICastingRecipe.calcCoolingTime(recipe.getTemperature(), recipe.getFluidAmount(inv.getFluid()) * this.itemCost);
        }
        return 1;
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.getFluidRecipe(inv).getFluidAmount(inv.getFluid()) * this.itemCost;
    }

    protected List<FluidStack> resizeFluids(List<FluidStack> fluids) {
        if (this.itemCost != 1) {
            return fluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * this.itemCost)).collect(Collectors.toList());
        }
        return fluids;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }
}

