/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.armor.MultilayerArmorModel;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public class ArmorModelManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "tinkering/armor_models";
    public static final ArmorModelManager INSTANCE = new ArmorModelManager();
    private Map<ResourceLocation, ArmorModel> models = Collections.emptyMap();
    private static final List<ArmorModelDispatcher> DISPATCHERS = new ArrayList<ArmorModelDispatcher>();

    public static void init(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    private ArmorModelManager() {
        super(JsonHelper.DEFAULT_GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager manager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        ArmorTextureSupplier.TEXTURE_VALIDATOR.onReloadSafe(manager);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : splashList.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                builder.put((Object)key, (Object)((ArmorModel)ArmorModel.LOADABLE.convert(element, key.toString())));
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to load armor model from {}", (Object)key, (Object)e);
            }
        }
        this.models = builder.build();
        HashSet<ResourceLocation> missing = new HashSet<ResourceLocation>();
        for (ArmorModelDispatcher dispatcher : DISPATCHERS) {
            dispatcher.model = null;
            ResourceLocation name = dispatcher.getName();
            if (this.models.containsKey(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            TConstruct.LOG.error("Missing armor models used by items: {}", missing);
        }
        TConstruct.LOG.info("Loaded {} armor models in {} ms", (Object)this.models.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public ArmorModel getModel(ResourceLocation name) {
        return this.models.getOrDefault(name, ArmorModel.EMPTY);
    }

    public record ArmorModel(List<ArmorTextureSupplier> layers) {
        public static final ArmorModel EMPTY = new ArmorModel(List.of());
        public static final RecordLoadable<ArmorModel> LOADABLE = RecordLoadable.create((RecordField)ArmorTextureSupplier.LOADER.list(1).requiredField("layers", ArmorModel::layers), ArmorModel::new);
    }

    public static abstract class ArmorModelDispatcher
    implements IClientItemExtensions {
        private ArmorModel model;

        public ArmorModelDispatcher() {
            DISPATCHERS.add(this);
        }

        protected abstract ResourceLocation getName();

        protected ArmorModel getModel(ItemStack stack) {
            if (this.model == null) {
                this.model = INSTANCE.getModel(this.getName());
                if (this.model == ArmorModel.EMPTY) {
                    TConstruct.LOG.warn("Failed to find armor model {}, will skip rendering {}", (Object)this.getName(), (Object)stack);
                }
            }
            return this.model;
        }

        @Nonnull
        public Model getGenericArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
            return MultilayerArmorModel.INSTANCE.setup(living, stack, slot, original, this.getModel(stack));
        }
    }
}

