/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.gear.material.AbstractMaterial;
import net.silentchaos512.gear.gear.material.CompoundMaterial;
import net.silentchaos512.gear.gear.material.CraftedMaterial;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.PartMaterial;

public final class MaterialSerializers {
    private static final Map<ResourceLocation, IMaterialSerializer<?>> REGISTRY = new HashMap();
    public static final AbstractMaterial.Serializer<PartMaterial> STANDARD = MaterialSerializers.register(new AbstractMaterial.Serializer<PartMaterial>(SilentGear.getId("standard"), PartMaterial::new));
    public static final CompoundMaterial.Serializer COMPOUND = MaterialSerializers.register(new CompoundMaterial.Serializer());
    public static final AbstractMaterial.Serializer<CustomCompoundMaterial> CUSTOM_COMPOUND = MaterialSerializers.register(new AbstractMaterial.Serializer<CustomCompoundMaterial>(SilentGear.getId("custom_compound"), CustomCompoundMaterial::new));
    public static final CraftedMaterial.Serializer CRAFTED = MaterialSerializers.register(new CraftedMaterial.Serializer(SilentGear.getId("crafted")));

    private MaterialSerializers() {
    }

    public static <S extends IMaterialSerializer<T>, T extends IMaterial> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate material serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(MaterialManager.MARKER, "Registered material serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
        ResourceLocation type = SilentGear.getIdWithDefaultNamespace(GsonHelper.m_13851_((JsonObject)json, (String)"type", (String)STANDARD.getName().toString()));
        IMaterialSerializer serializer = REGISTRY.getOrDefault(type, STANDARD);
        return serializer.deserialize(id, packName, json);
    }

    public static IMaterial read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        ResourceLocation type = buffer.m_130281_();
        IMaterialSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown material serializer: " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IMaterial> void write(T material, FriendlyByteBuf buffer) {
        buffer.m_130085_(material.getId());
        buffer.m_130085_(material.getSerializer().getName());
        IMaterialSerializer<?> serializer = material.getSerializer();
        serializer.write(buffer, material);
    }
}

