/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import java.util.Collection;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;

public interface IStatModProvider<D> {
    public Collection<StatInstance> getStatModifiers(D var1, PartType var2, StatGearKey var3, ItemStack var4);

    default public Collection<StatInstance> getStatModifiers(D instance, PartType partType, StatGearKey key) {
        return this.getStatModifiers(instance, partType, key, ItemStack.f_41583_);
    }

    default public float getStat(D instance, PartType partType, StatGearKey key, ItemStack gear) {
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            return key.getStat().getDefaultValue();
        }
        Collection<StatInstance> mods = this.getStatModifiers(instance, partType, key, gear);
        return stat.compute(mods);
    }

    default public float getStatUnclamped(D instance, PartType partType, StatGearKey key, ItemStack gear) {
        ItemStat stat = ItemStats.get(key.getStat());
        if (stat == null) {
            return key.getStat().getDefaultValue();
        }
        Collection<StatInstance> mods = this.getStatModifiers(instance, partType, key, gear);
        return stat.compute(stat.getBaseValue(), false, key.getGearType(), mods);
    }
}

