/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.setup;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import java.util.Arrays;
import java.util.List;
import net.mcreator.ars_technica.common.items.threads.PressurePerk;
import net.mcreator.ars_technica.setup.ItemsRegistry;
import net.mcreator.ars_technica.setup.RecipeRegistry;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ArsNouveauRegistry {
    public static void init() {
        ArsNouveauRegistry.registerThreads();
    }

    public static void postInit() {
        ArsNouveauRegistry.registerArmor();
    }

    private static void registerArmor() {
        List<PerkSlot> perkSlots = Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE);
        List<ItemLike> armors = List.of((ItemLike)ItemsRegistry.TECHNOMANCER_HELMET.get(), (ItemLike)ItemsRegistry.TECHNOMANCER_CHESTPLATE.get(), (ItemLike)ItemsRegistry.TECHNOMANCER_LEGGINGS.get(), (ItemLike)ItemsRegistry.TECHNOMANCER_BOOTS.get());
        for (ItemLike armor : armors) {
            PerkRegistry.registerPerkProvider((ItemLike)armor, stack -> new ArmorPerkHolder(stack, List.of(perkSlots, perkSlots, perkSlots, perkSlots)));
        }
        ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add((RecipeType)RecipeRegistry.TECHNOMANCER_ARMOR_UP.get());
    }

    private static void registerThreads() {
        PerkRegistry.registerPerk((IPerk)PressurePerk.INSTANCE);
    }
}

