/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.RuneCaster;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import java.util.Set;
import javax.annotation.Nonnull;
import net.mcreator.ars_technica.common.entity.WhirlEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EffectWhirl
extends AbstractEffect {
    public static final EffectWhirl INSTANCE = new EffectWhirl();
    public final float DEFAULT_RADIUS = 1.5f;
    public final int DEFAULT_DURATION = 360;

    private EffectWhirl() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"glyph_whirl"), "Whirl");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Vec3 position = rayTraceResult.m_82450_();
        IWrappedCaster iWrappedCaster = spellContext.getCaster();
        if (iWrappedCaster instanceof RuneCaster) {
            RuneCaster runeCaster = (RuneCaster)iWrappedCaster;
            Vec3 casterPos = runeCaster.getPosition();
            position = casterPos.m_82520_(0.5, 0.0, 0.5);
        }
        this.resolve(position, (Level)serverWorld, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Vec3 adjustedPosition = this.getAdjustedPosition(rayTraceResult);
        this.resolve(adjustedPosition, (Level)serverWorld, shooter, spellStats, spellContext, resolver);
    }

    private Vec3 getAdjustedPosition(BlockHitResult rayTraceResult) {
        BlockPos blockPos = rayTraceResult.m_82425_();
        Direction hitFace = rayTraceResult.m_82434_();
        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
        return switch (hitFace) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> center.m_82520_(0.0, 0.5, 0.0);
            case Direction.DOWN -> center.m_82520_(0.0, -1.0, 0.0);
            case Direction.NORTH -> center.m_82520_(0.0, 0.0, -1.0);
            case Direction.SOUTH -> center.m_82520_(0.0, 0.0, 1.0);
            case Direction.WEST -> center.m_82520_(-1.0, 0.0, 0.0);
            case Direction.EAST -> center.m_82520_(1.0, 0.0, 0.0);
        };
    }

    protected void resolve(Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        float aoeAmplifier = (float)spellStats.getAoeMultiplier();
        double durationAmplifier = spellStats.getDurationMultiplier();
        int extraDurationTicks = Math.toIntExact(Math.round(durationAmplifier * 40.0));
        AllFanProcessingTypes.SplashingType processingType = null;
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next == EffectConjureWater.INSTANCE) {
                    processingType = AllFanProcessingTypes.SPLASHING;
                    break;
                }
                if (next == EffectFlare.INSTANCE) {
                    processingType = AllFanProcessingTypes.SMOKING;
                    break;
                }
                if (next == EffectSmelt.INSTANCE) {
                    processingType = AllFanProcessingTypes.BLASTING;
                    break;
                }
                if (next != EffectHex.INSTANCE) break;
                processingType = AllFanProcessingTypes.HAUNTING;
                break;
            }
        }
        WhirlEntity whirl = new WhirlEntity(world, position, 1.5f + aoeAmplifier * 0.33f, 360 + extraDurationTicks, (FanProcessingType)processingType, resolver);
        world.m_7967_((Entity)whirl);
    }

    public int getDefaultManaCost() {
        return 40;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentExtendTime.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_AIR});
    }

    public String getBookDescription() {
        return "Creates a whirlwind in an area, causing items to be centrifuged.";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

