/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.ars_technica.common.crafting.DynamicCraftingContainer;
import net.mcreator.ars_technica.common.glyphs.AbstractItemResolveEffect;
import net.mcreator.ars_technica.common.helpers.CraftingHelpers;
import net.mcreator.ars_technica.common.helpers.ItemHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EffectCarve
extends AbstractItemResolveEffect {
    public static final EffectCarve INSTANCE = new EffectCarve();

    private EffectCarve() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ars_technica", (String)"glyph_carve"), "Carve");
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double amplifier = spellStats.getAmpMultiplier();
        Map<Item, List<ItemEntity>> groupedItems = entityList.stream().collect(Collectors.groupingBy(itemEntity -> itemEntity.m_32055_().m_41720_()));
        Map<Item, List> carveableItems = groupedItems.entrySet().stream().filter(entry -> this.hasCraftingRecipe((Item)entry.getKey(), world, amplifier)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<Item, List> entry2 : carveableItems.entrySet()) {
            this.carveItems(entry2.getKey(), entry2.getValue(), spellStats, world, pos, amplifier);
        }
    }

    private boolean hasCraftingRecipe(Item item, Level world, double amplifier) {
        DynamicCraftingContainer container = new DynamicCraftingContainer(3, 3);
        this.setContainerShape(container, new ItemStack((ItemLike)item), amplifier);
        Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)container, world);
        return recipe.isPresent();
    }

    private void setContainerShape(CraftingContainer container, ItemStack itemStack, double amplifier) {
        if (amplifier < 0.0) {
            CraftingHelpers.setSlabShape(container, itemStack);
        } else if (amplifier > 0.0) {
            CraftingHelpers.setWallShape(container, itemStack);
        } else {
            CraftingHelpers.setStairsShape(container, itemStack);
        }
    }

    private int getCraftSize(double amplifier) {
        return amplifier < 0.0 ? 3 : 6;
    }

    private void carveItems(Item item, List<ItemEntity> itemEntities, SpellStats spellStats, Level world, BlockPos pos, double amplifier) {
        int craftSize = this.getCraftSize(amplifier);
        int totalItemCount = itemEntities.stream().mapToInt(entity -> entity.m_32055_().m_41613_()).sum();
        int totalCarvings = totalItemCount / craftSize;
        DynamicCraftingContainer container = new DynamicCraftingContainer(3, 3);
        this.setContainerShape(container, new ItemStack((ItemLike)item), amplifier);
        for (int i = 0; i < totalCarvings; ++i) {
            ItemStack carvedItem = CraftingHelpers.getItem(container, item, world);
            if (carvedItem.m_41619_()) continue;
            ItemHelpers.createItemEntity(carvedItem, world, pos);
        }
        int totalItemsToRemove = totalCarvings * craftSize;
        ItemHelpers.subtractItemsFromItemEntities(itemEntities, totalItemsToRemove, item, pos, world);
    }

    public int getDefaultManaCost() {
        return 10;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Shapes identical items, crafting them into stairs. Augment for walls, Dampen for slabs";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

