/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import net.mcreator.ars_technica.client.events.ClientHandler;
import net.mcreator.ars_technica.common.helpers.SpellResolverHelpers;
import net.mcreator.ars_technica.common.kinetics.WhirlCurrent;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WhirlEntity
extends Entity
implements IAirCurrentSource,
GeoEntity {
    private float radius;
    private int duration;
    private final Level world;
    private float speed = 0.05f;
    private FanProcessingType processor;
    private WhirlCurrent current;
    private final SpellResolver spellResolver;
    private boolean soundPlaying;
    private static final EntityDataAccessor<String> PROCESSOR_TYPE = SynchedEntityData.m_135353_(WhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(WhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(WhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public float getRadius() {
        return this.radius;
    }

    public Level getLevel() {
        return this.world;
    }

    public float getScaledSpeed() {
        return this.speed / 0.05f;
    }

    public FanProcessingType getProcessor() {
        return this.processor;
    }

    public WhirlEntity(EntityType<? extends WhirlEntity> entityType, Level world) {
        super(entityType, world);
        this.radius = 1.0f;
        this.duration = 100;
        this.world = world;
        this.spellResolver = null;
    }

    public WhirlEntity(Level world, Vec3 position, float radius, int duration, @Nullable FanProcessingType processor, SpellResolver spellResolver) {
        super((EntityType)EntityRegistry.WHIRL_ENTITY.get(), world);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.duration = duration;
        this.world = world;
        this.spellResolver = spellResolver;
        this.setRadius(radius);
        this.radius = radius;
        this.setSpeed(SpellResolverHelpers.hasTransmutationFocus(spellResolver) ? 0.1f : 0.05f);
        this.setProcessor(processor);
        this.current = new WhirlCurrent(this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.handleWhirlwindEffect();
    }

    private void handleGravity() {
        boolean onGround;
        BlockPos belowPos = this.m_20099_();
        boolean bl = onGround = !this.world.m_8055_(belowPos).m_60795_();
        if (!onGround) {
            this.moveDown();
        }
    }

    private void moveDown() {
        this.m_6034_(this.m_20185_(), this.m_20186_() - (double)0.03f, this.m_20189_());
    }

    private void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    private void setProcessor(@Nullable FanProcessingType processor) {
        this.f_19804_.m_135381_(PROCESSOR_TYPE, (Object)this.getProcessorLegacyId(processor));
    }

    private void setRadius(float radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    private String getProcessorLegacyId(@Nullable FanProcessingType processor) {
        if (processor == AllFanProcessingTypes.BLASTING) {
            return "BLASTING";
        }
        if (processor == AllFanProcessingTypes.HAUNTING) {
            return "HAUNTING";
        }
        if (processor == AllFanProcessingTypes.SMOKING) {
            return "SMOKING";
        }
        if (processor == AllFanProcessingTypes.SPLASHING) {
            return "SPLASHING";
        }
        return "NONE";
    }

    private void handleWhirlwindEffect() {
        if (!this.world.f_46443_) {
            --this.duration;
            if (this.current != null) {
                this.current.tick(this.spellResolver);
            }
            if (this.duration <= 0) {
                if (this.current != null) {
                    this.current.stopAffectedItems();
                }
                this.m_146870_();
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PROCESSOR_TYPE, (Object)"");
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.05f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.5f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
        }
        if (PROCESSOR_TYPE.equals(key)) {
            String val = (String)this.f_19804_.m_135370_(PROCESSOR_TYPE);
            this.processor = val.isEmpty() ? null : AllFanProcessingTypes.parseLegacy((String)((String)this.f_19804_.m_135370_(PROCESSOR_TYPE)));
            this.initSound();
        }
        if (RADIUS.equals(key)) {
            this.radius = ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
        }
    }

    private void initSound() {
        if (this.world.f_46443_ && !this.soundPlaying) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handleWhirlSound(this, this.processor, this.speed));
            this.soundPlaying = true;
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.duration = compound.m_128451_("Duration");
        this.setRadius(compound.m_128457_("Radius"));
        this.setSpeed(compound.m_128457_("Speed"));
        if (compound.m_128441_("ProcessorType")) {
            String processorType = compound.m_128461_("ProcessorType");
            this.setProcessor(AllFanProcessingTypes.parseLegacy((String)processorType));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Duration", this.duration);
        compound.m_128350_("Radius", this.radius);
        compound.m_128350_("Speed", this.speed);
        if (this.processor != null) {
            compound.m_128359_("ProcessorType", this.getProcessorLegacyId(this.processor));
        }
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return null;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return null;
    }

    public BlockPos getAirCurrentPos() {
        return null;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Direction getAirflowOriginSide() {
        return null;
    }

    @Nullable
    public Direction getAirFlowDirection() {
        return null;
    }

    public boolean isSourceRemoved() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotateController", 0, this::rotateAnimationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState rotateAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        event.getController().setAnimationSpeed((double)(0.75f * (this.speed / 0.05f)));
        return PlayState.CONTINUE;
    }
}

