/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.blocks;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import java.util.List;
import net.mcreator.ars_technica.common.api.IModifiableCooldown;
import net.mcreator.ars_technica.common.helpers.CooldownHelper;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PreciseRelayTile
extends RelayTile
implements IModifiableCooldown {
    private int customCooldownTicks = -1;
    private AnimationController rotateController;

    public PreciseRelayTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.PRECISE_RELAY_TILE.get(), pos, state);
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        int cooldownTicks = this.getCooldownTicks();
        if (cooldownTicks == -1) {
            cooldownTicks = 20;
        }
        int transferRate = this.getTransferRate();
        String coolDownText = CooldownHelper.getCooldownText(cooldownTicks);
        tooltip.add((Component)Component.m_237119_());
        MutableComponent transferRateComponent = Component.m_237110_((String)"ars_nouveau.relay.transfer_rate", (Object[])new Object[]{transferRate, coolDownText}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)transferRateComponent);
    }

    public void tick() {
        if (this.f_58857_.f_46443_ && this.rotateController != null) {
            int divider = this.customCooldownTicks == 0 ? 1 : this.customCooldownTicks;
            this.rotateController.setAnimationSpeed(20.0 / (double)divider);
        }
        if (this.f_58857_.f_46443_ || this.disabled) {
            return;
        }
        if (this.shouldStall()) {
            return;
        }
        BlockPos fromPos = this.getFromPos();
        BlockPos toPos = this.getToPos();
        if (fromPos != null && this.f_58857_.m_46749_(fromPos)) {
            AbstractSourceMachine fromTile;
            if (!(this.f_58857_.m_7702_(fromPos) instanceof AbstractSourceMachine)) {
                this.setFromPos(null);
                this.updateBlock();
                return;
            }
            BlockEntity blockEntity = this.f_58857_.m_7702_(fromPos);
            if (blockEntity instanceof AbstractSourceMachine && this.transferSource((ISourceTile)(fromTile = (AbstractSourceMachine)blockEntity), (ISourceTile)this) > 0) {
                this.updateBlock();
                ParticleUtil.spawnFollowProjectile((Level)this.f_58857_, (BlockPos)fromPos, (BlockPos)this.f_58858_, (ParticleColor)this.getColor());
            }
        }
        if (toPos != null && this.f_58857_.m_46749_(toPos)) {
            if (!(this.f_58857_.m_7702_(toPos) instanceof AbstractSourceMachine)) {
                this.setToPos(null);
                this.updateBlock();
                return;
            }
            AbstractSourceMachine toTile = (AbstractSourceMachine)this.f_58857_.m_7702_(toPos);
            if (this.transferSource((ISourceTile)this, (ISourceTile)toTile) > 0) {
                ParticleUtil.spawnFollowProjectile((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockPos)toPos, (ParticleColor)this.getColor());
            }
        }
    }

    private boolean shouldStall() {
        if (this.customCooldownTicks == 0) {
            return false;
        }
        if (this.customCooldownTicks == -1) {
            return this.f_58857_.m_46467_() % 20L != 0L;
        }
        return this.f_58857_.m_46467_() % (long)this.customCooldownTicks != 0L;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customCooldownTicks != -1) {
            tag.m_128405_("CustomCooldown", this.customCooldownTicks);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        int coolDown = tag.m_128451_("CustomCooldown");
        if (coolDown != -1) {
            this.customCooldownTicks = coolDown;
        }
    }

    @Override
    public void setCooldownTicks(int ticks) {
        this.customCooldownTicks = ticks;
    }

    @Override
    public int getCooldownTicks() {
        return this.customCooldownTicks;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        this.rotateController = new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate);
        data.add(new AnimationController[]{this.rotateController});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "float_controller", 0, this::floatPredicate)});
    }

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState floatPredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        return PlayState.CONTINUE;
    }
}

