/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.LocationManager;

class ChestData
extends InventoryInternal {
    private final String owner;
    private final String code;
    private byte capacity = (byte)9;

    ChestData(String owner, String code) {
        super(null, "", 54, 64, owner.toLowerCase() + "." + code.toLowerCase());
        this.owner = owner;
        this.code = code;
    }

    void setCapacity(byte capacity) {
        this.capacity = (byte)Mth.m_14045_((int)capacity, (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()), (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()));
        ChestHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    CompoundTag saveToNBT(CompoundTag nbtTag) {
        ListTag nbtList = new ListTag();
        for (int index = 0; index < this.contents.length; ++index) {
            if (this.contents[index].m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)index);
            this.contents[index].m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbtTag.m_128365_("Items", (Tag)nbtList);
        nbtTag.m_128344_("Capacity", this.capacity);
        return nbtTag;
    }

    ChestData loadFromNBT(CompoundTag nbtTag) {
        this.m_6211_();
        this.setCapacity(nbtTag.m_128445_("Capacity"));
        ListTag nbtList = nbtTag.m_128437_("Items", 10);
        for (int index = 0; index < nbtList.size(); ++index) {
            CompoundTag nbtCompound = nbtList.m_128728_(index);
            int slot = nbtCompound.m_128445_("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.m_41712_((CompoundTag)nbtCompound);
        }
        return this;
    }

    boolean saveCheck() {
        if (this.capacity > (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()) {
            return true;
        }
        for (ItemStack content : this.contents) {
            if (content.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public int m_6643_() {
        return Mth.m_14045_((int)this.capacity, (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get()), (int)((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()));
    }

    public void m_6596_() {
        ChestHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }
}

