/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;

public interface IOpenable {
    public static final Cache<ItemStack, Integer> CLOSE_DELAY = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static boolean isOpen(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("open")) {
            return tag.m_128471_("open");
        }
        IOpenable.setOpenState(stack, false);
        return false;
    }

    public static void setOpenState(ItemStack stack, boolean isOpen) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("open", isOpen);
    }

    default public void openInventory(ItemStack stack, Player player) {
        this.openInventory(stack, player.m_9236_(), player);
    }

    default public void iOpenableInventoryTick(ItemStack stack, Entity entity) {
        if (IOpenable.isOpen(stack)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Integer delay = (Integer)CLOSE_DELAY.getIfPresent((Object)stack);
                if (this.isContainerOpen(player)) {
                    if (delay == null || delay > 0) {
                        CLOSE_DELAY.put((Object)stack, (Object)-1);
                    }
                    return;
                }
                if (delay == null || delay > 0) {
                    int n;
                    if (delay == null) {
                        n = 10;
                    } else {
                        delay = delay - 1;
                        n = delay;
                    }
                    CLOSE_DELAY.put((Object)stack, (Object)n);
                    return;
                }
            }
            IOpenable.setOpenState(stack, false);
        }
    }

    public InteractionResultHolder<ItemStack> openInventory(ItemStack var1, Level var2, Player var3);

    public boolean isContainerOpen(Player var1);

    public static enum Type {
        NONE,
        EITHER,
        BAG,
        POUCH;


        public static Type getFor(ItemStack stack) {
            Item item;
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                return openable instanceof ItemEnderBag ? BAG : (openable instanceof ItemEnderPouch ? POUCH : NONE);
            }
            return NONE;
        }

        public boolean test(ItemStack stack) {
            return this.test(stack.m_41720_());
        }

        private boolean test(Item item) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> false;
                case EITHER -> {
                    if (BAG.test(item) || POUCH.test(item)) {
                        yield true;
                    }
                    yield false;
                }
                case BAG -> item instanceof ItemEnderBag;
                case POUCH -> item instanceof ItemEnderPouch;
            };
        }
    }
}

