/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientList;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientListMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;

public class IngredientList<T, M>
extends IngredientCollectionCollectionAdapter<T, M, List<T>>
implements IIngredientListMutable<T, M> {
    public IngredientList(IngredientComponent<T, M> component, List<T> list) {
        super(component, list);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof IngredientList && IngredientCollections.equalsCheckedOrdered(this, (IIngredientCollection)obj);
    }

    @Override
    @Nullable
    public T get(int index) {
        return (T)((List)this.getCollection()).get(index);
    }

    @Override
    @Nullable
    public T set(int index, T instance) {
        return ((List)this.getCollection()).set(index, instance);
    }

    @Override
    public void add(int index, T instance) {
        ((List)this.getCollection()).add(index, instance);
    }

    @Override
    @Nullable
    public T remove(int index) {
        return (T)((List)this.getCollection()).remove(index);
    }

    @Override
    public int firstIndexOf(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        ListIterator<T> it = this.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            if (!matcher.matchesExactly(it.next(), instance)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        ListIterator<T> it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            int i = it.previousIndex();
            if (!matcher.matchesExactly(it.previous(), instance)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return ((List)this.getCollection()).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int offset) {
        return ((List)this.getCollection()).listIterator(offset);
    }

    @Override
    public IIngredientList<T, M> subList(int fromIndex, int toIndex) {
        return new IngredientList(this.getComponent(), ((List)this.getCollection()).subList(fromIndex, toIndex));
    }
}

