/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.storage;

import com.github.jarva.arsadditions.server.sync.SourceJarSync;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class EnderSourceData
extends SavedData {
    public HashMap<UUID, Integer> source = new HashMap();

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        for (Map.Entry<UUID, Integer> entry : this.source.entrySet()) {
            UUID uuid = entry.getKey();
            Integer source = entry.getValue();
            if (uuid == null) continue;
            tag.m_128405_(uuid.toString(), source.intValue());
        }
        return tag;
    }

    public void update(UUID uuid, int source) {
        this.source.put(uuid, source);
        this.m_77762_();
    }

    public static EnderSourceData create() {
        return new EnderSourceData();
    }

    public static EnderSourceData load(CompoundTag tag) {
        EnderSourceData data = EnderSourceData.create();
        List<UUID> uuids = tag.m_128431_().stream().map(UUID::fromString).toList();
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            data.source.put(uuid, tag.m_128451_(uuid.toString()));
        }
        return data;
    }

    public static EnderSourceData getData(MinecraftServer server) {
        return (EnderSourceData)server.m_129783_().m_8895_().m_164861_(EnderSourceData::load, EnderSourceData::create, "ender_source_data");
    }

    public static int getSource(MinecraftServer server, UUID uuid) {
        return EnderSourceData.getData((MinecraftServer)server).source.computeIfAbsent(uuid, k -> 0);
    }

    public static void setSource(MinecraftServer server, UUID uuid, int source) {
        if (source != EnderSourceData.getSource(server, uuid)) {
            EnderSourceData data = EnderSourceData.getData(server);
            data.update(uuid, source);
            SourceJarSync.updateSourceLevel(server, uuid);
        }
    }
}

