/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.util;

import com.github.jarva.arsadditions.mixin.BookEntryAccessor;
import com.github.jarva.arsadditions.mixin.BookPageAccessor;
import com.github.jarva.arsadditions.mixin.PageRelationsAccessor;
import com.github.jarva.arsadditions.mixin.PageTextAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.page.PageRelations;
import vazkii.patchouli.client.book.page.PageText;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class BookUtil {
    public static final ResourceLocation WORN_NOTEBOOK = new ResourceLocation("ars_nouveau", "worn_notebook");

    public static void addRelation(ResourceLocation bookEntry, ResourceLocation relation) {
        Map<ResourceLocation, BookEntry> entries = BookUtil.getEntries();
        BookEntry entry = entries.get(bookEntry);
        if (entry == null) {
            return;
        }
        List pages = entry.getPages();
        Optional<BookPage> relationsPage = pages.stream().filter(p -> p instanceof PageRelations).findFirst();
        relationsPage.ifPresent(relations -> {
            PageRelationsAccessor relationsAccessor = (PageRelationsAccessor)relations;
            relationsAccessor.getEntries().add((BookEntry)entries.get(relation));
        });
    }

    public static void addPage(ResourceLocation bookEntry, BookPage newPage) {
        BookUtil.addPage(bookEntry, newPage, true, null);
    }

    public static void addPage(ResourceLocation bookEntry, BookPage newPage, boolean after, @Nullable Predicate<BookPage> isPage) {
        int i;
        Map<ResourceLocation, BookEntry> entries = BookUtil.getEntries();
        BookEntry entry = entries.get(bookEntry);
        if (entry == null) {
            return;
        }
        BookEntryAccessor entryAccessor = (BookEntryAccessor)entry;
        List<BookPage> pages = entryAccessor.getRealPages();
        if (isPage == null) {
            i = pages.size() - 1;
        } else {
            for (i = 0; i < pages.size(); ++i) {
                BookPage page = pages.get(i);
                if (!isPage.test(page)) continue;
                if (!after) break;
                ++i;
                break;
            }
        }
        pages.add(i, newPage);
    }

    public static BookPage newTextPage(String title, String text) {
        PageText page = new PageText();
        PageTextAccessor pageTextAccessor = (PageTextAccessor)page;
        pageTextAccessor.setTitle(title);
        BookPageAccessor bookPageAccessor = (BookPageAccessor)page;
        bookPageAccessor.setPageNum(1);
        page.setText(text);
        return page;
    }

    public static boolean isTextPage(BookPage page, String pageTitle) {
        if (page instanceof PageText) {
            PageText text = (PageText)page;
            PageTextAccessor textAccessor = (PageTextAccessor)text;
            String title = textAccessor.getTitle();
            if (title == null) {
                return false;
            }
            return title.equals(pageTitle);
        }
        return false;
    }

    private static Map<ResourceLocation, BookEntry> getEntries() {
        Book wornNotebook = (Book)BookRegistry.INSTANCE.books.get(WORN_NOTEBOOK);
        return wornNotebook.getContents().entries;
    }
}

