/*
 * Decompiled with CFR 0.152.
 */
package daripher.apothiccurios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.client.SocketTooltipRenderer;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod(value="apothiccurios")
public class ApothicCuriosMod {
    public static final String MOD_ID = "apothiccurios";
    public static final EquipmentSlot FAKE_SLOT = EquipmentSlot.LEGS;

    public ApothicCuriosMod() {
        if (!this.adventureModuleEnabled()) {
            return;
        }
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(EventPriority.LOW, this::addCurioSocketTooltip);
        forgeEventBus.addListener(this::applyCurioShieldBlockAffixes);
        forgeEventBus.addListener(this::applyCurioBlockBreakAffixes);
        forgeEventBus.addListener(this::applyCurioArrowAffixes);
        forgeEventBus.addListener(this::applyCurioAttributeAffixes);
        forgeEventBus.addListener(this::applyCurioDamageAffixes);
        forgeEventBus.addListener(EventPriority.LOWEST, this::removeFakeCurioAttributes);
        forgeEventBus.addListener(EventPriority.LOWEST, this::removeGemAttributeTooltips);
    }

    private void addCurioSocketTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (ApothicCuriosMod.isNonCurio(stack)) {
            return;
        }
        Predicate<TooltipComponent> isSocketComponent = SocketTooltipRenderer.SocketComponent.class::isInstance;
        event.getTooltipElements().removeIf(c -> c.right().filter(isSocketComponent).isPresent());
        SocketTooltipRenderer.SocketComponent component = new SocketTooltipRenderer.SocketComponent(stack, SocketHelper.getGems((ItemStack)stack));
        event.getTooltipElements().add(Either.right((Object)component));
    }

    @SubscribeEvent
    public void applyCurioShieldBlockAffixes(ShieldBlockEvent event) {
        AtomicReference<Float> blocked = new AtomicReference<Float>(Float.valueOf(event.getBlockedDamage()));
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getDamageSource();
        ApothicCuriosMod.getCuriosAffixes(entity).forEach(affix -> blocked.set(Float.valueOf(affix.onShieldBlock(entity, damageSource, ((Float)blocked.get()).floatValue()))));
        if (blocked.get().floatValue() != event.getOriginalBlockedDamage()) {
            event.setBlockedDamage(blocked.get().floatValue());
        }
    }

    @SubscribeEvent
    public void applyCurioBlockBreakAffixes(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        ApothicCuriosMod.getCuriosAffixes((LivingEntity)player).forEach(affix -> affix.onBlockBreak(player, level, pos, state));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void applyCurioArrowAffixes(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        if (arrow.getPersistentData().m_128471_("apoth.generated")) {
            return;
        }
        Entity shooter = arrow.m_19749_();
        if (!(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)shooter;
        ApothicCuriosMod.getCuriosAffixes(living).forEach(affix -> affix.onArrowFired(living, arrow));
        ApothicCuriosMod.getEquippedCurios(living).forEach(curio -> AffixHelper.copyFrom((ItemStack)curio, (Entity)arrow));
    }

    private void applyCurioAttributeAffixes(CurioAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41782_()) {
            return;
        }
        SlotContext slotContext = event.getSlotContext();
        if (!CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)stack)) {
            return;
        }
        LootCategory category = (LootCategory)LootCategory.BY_ID.get("curios:" + slotContext.identifier());
        if (LootCategory.forItem((ItemStack)stack) != category) {
            return;
        }
        AffixHelper.getAffixes((ItemStack)stack).forEach((a, i) -> i.addModifiers(FAKE_SLOT, (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1)));
        SocketHelper.getGems((ItemStack)stack).addModifiers(LootCategory.forItem((ItemStack)stack), FAKE_SLOT, (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1));
    }

    private void applyCurioDamageAffixes(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        AtomicDouble amount = new AtomicDouble((double)event.getAmount());
        ApothicCuriosMod.getCuriosAffixes(entity).forEach(affix -> amount.set((double)affix.onHurt(source, entity, amount.floatValue())));
        event.setAmount(amount.floatValue());
    }

    private void removeFakeCurioAttributes(ItemAttributeModifierEvent event) {
        if (ApothicCuriosMod.isNonCurio(event.getItemStack())) {
            return;
        }
        if (event.getSlotType() == FAKE_SLOT) {
            event.clearModifiers();
        }
    }

    private void removeGemAttributeTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41782_()) {
            return;
        }
        if (ApothicCuriosMod.isNonCurio(stack)) {
            return;
        }
        this.getGemTooltips(stack).forEach(component -> ApothicCuriosMod.removeTooltip(event, component));
    }

    private List<Component> getGemTooltips(ItemStack stack) {
        TooltipFlag.Default flag = TooltipFlag.f_256752_;
        ArrayList<Component> components = new ArrayList<Component>();
        SocketedGems gems = SocketHelper.getGems((ItemStack)stack);
        HashMultimap modifierMap = HashMultimap.create();
        gems.forEach(arg_0 -> ApothicCuriosMod.lambda$getGemTooltips$8((Multimap)modifierMap, arg_0));
        for (Attribute attr : modifierMap.keySet()) {
            Collection modifiers = modifierMap.get((Object)attr);
            if (modifiers.size() > 1) {
                double[] sums = new double[3];
                boolean[] merged = new boolean[3];
                HashMap<AttributeModifier.Operation, List> shiftExpands = new HashMap<AttributeModifier.Operation, List>();
                for (AttributeModifier modifier : modifierMap.values()) {
                    if (modifier.m_22218_() == 0.0) continue;
                    if (sums[modifier.m_22217_().ordinal()] != 0.0) {
                        merged[modifier.m_22217_().ordinal()] = true;
                    }
                    int n = modifier.m_22217_().ordinal();
                    sums[n] = sums[n] + modifier.m_22218_();
                    shiftExpands.computeIfAbsent(modifier.m_22217_(), k -> new LinkedList()).add(modifier);
                }
                for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
                    int i = op.ordinal();
                    if (sums[i] == 0.0) continue;
                    if (merged[i]) {
                        TextColor color;
                        TextColor textColor = color = sums[i] < 0.0 ? TextColor.m_131266_((int)16331057) : TextColor.m_131266_((int)8026873);
                        if (sums[i] < 0.0) {
                            int n = i;
                            sums[n] = sums[n] * -1.0;
                        }
                        AttributeModifier fakeModif = new AttributeModifier(UUID.randomUUID(), () -> "attributeslib:merged", sums[i], op);
                        MutableComponent comp = IFormattableAttribute.toComponent((Attribute)attr, (AttributeModifier)fakeModif, (TooltipFlag)flag);
                        components.add((Component)comp.m_130948_(comp.m_7383_().m_131148_(color)));
                        if (!merged[i] || !Screen.m_96638_()) continue;
                        ((List)shiftExpands.get(AttributeModifier.Operation.m_22236_((int)i))).forEach(arg_0 -> ApothicCuriosMod.lambda$getGemTooltips$11(components, attr, (TooltipFlag)flag, arg_0));
                        continue;
                    }
                    AttributeModifier fakeModif = new AttributeModifier(UUID.randomUUID(), () -> "attributeslib:merged", sums[i], op);
                    components.add((Component)IFormattableAttribute.toComponent((Attribute)attr, (AttributeModifier)fakeModif, (TooltipFlag)flag));
                }
                continue;
            }
            modifiers.forEach(arg_0 -> ApothicCuriosMod.lambda$getGemTooltips$13(components, attr, (TooltipFlag)flag, arg_0));
        }
        return components;
    }

    private static void removeTooltip(ItemTooltipEvent event, Component tooltip) {
        event.getToolTip().removeIf(c -> c.getString().equals(tooltip.getString()));
    }

    public static void registerCurioLootCategory(String id) {
        String slotId = id.replace("curios:", "");
        SlotContext slotContext = new SlotContext(slotId, null, 0, false, false);
        Predicate<ItemStack> validator = s -> CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)s);
        EquipmentSlot[] fakeSlots = new EquipmentSlot[]{FAKE_SLOT};
        LootCategory.register(null, (String)id, validator, (EquipmentSlot[])fakeSlots);
    }

    private boolean adventureModuleEnabled() {
        return Apotheosis.enableAdventure;
    }

    private static boolean isNonCurio(ItemStack stack) {
        return CuriosApi.getItemStackSlots((ItemStack)stack).isEmpty();
    }

    private static List<ItemStack> getEquippedCurios(LivingEntity entity) {
        ArrayList<ItemStack> curios = new ArrayList<ItemStack>();
        CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios).ifPresent(i -> {
            for (int slot = 0; slot < i.getSlots(); ++slot) {
                curios.add(i.getStackInSlot(slot));
            }
        });
        return curios;
    }

    public static List<AffixInstance> getCuriosAffixes(LivingEntity entity) {
        return ApothicCuriosMod.getEquippedCurios(entity).stream().map(AffixHelper::getAffixes).map(Map::values).flatMap(Collection::stream).toList();
    }

    private static /* synthetic */ void lambda$getGemTooltips$13(List components, Attribute attr, TooltipFlag flag, AttributeModifier m) {
        if (m.m_22218_() != 0.0) {
            components.add(IFormattableAttribute.toComponent((Attribute)attr, (AttributeModifier)m, (TooltipFlag)flag));
        }
    }

    private static /* synthetic */ void lambda$getGemTooltips$11(List components, Attribute attr, TooltipFlag flag, AttributeModifier modif) {
        components.add(AttributeHelper.list().m_7220_((Component)IFormattableAttribute.toComponent((Attribute)attr, (AttributeModifier)modif, (TooltipFlag)flag)));
    }

    private static /* synthetic */ void lambda$getGemTooltips$8(Multimap modifierMap, GemInstance gemInstance) {
        gemInstance.addModifiers(FAKE_SLOT, (arg_0, arg_1) -> ((Multimap)modifierMap).put(arg_0, arg_1));
    }
}

