/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketSubmitBid
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketSubmitBid> HANDLER = new H();
    final long auctionHouseID;
    final int tradeIndex;
    final MoneyValue bidAmount;

    public CPacketSubmitBid(long auctionHouseID, int tradeIndex, MoneyValue bidAmount) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.auctionHouseID);
        buffer.writeInt(this.tradeIndex);
        this.bidAmount.encode(buffer);
    }

    private static class H
    extends CustomPacket.Handler<CPacketSubmitBid> {
        private H() {
        }

        @Override
        public CPacketSubmitBid decode(FriendlyByteBuf buffer) {
            return new CPacketSubmitBid(buffer.readLong(), buffer.readInt(), MoneyValue.decode(buffer));
        }

        @Override
        protected void handle(CPacketSubmitBid message, Player player) {
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.f_36096_) instanceof TraderMenu) {
                TraderMenu menu = (TraderMenu)abstractContainerMenu;
                TraderData data = TraderAPI.getApi().GetTrader(false, message.auctionHouseID);
                if (data instanceof AuctionHouseTrader) {
                    AuctionHouseTrader ah = (AuctionHouseTrader)data;
                    ah.makeBid(player, menu, message.tradeIndex, message.bidAmount);
                }
            }
        }
    }
}

