/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.categories;

import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TraderCategory
extends NotificationCategory {
    public static final NotificationCategoryType<TraderCategory> TYPE = new NotificationCategoryType(VersionUtil.lcResource("trader"), TraderCategory::new);
    private final Item trader;
    private final long traderID;
    private final Component traderName;
    private final IconData traderIcon;

    @Deprecated(since="2.3.0.0")
    public TraderCategory(ItemLike trader, Component traderName, long traderID) {
        this(trader, traderName, traderID, IconData.Null());
    }

    public TraderCategory(ItemLike trader, Component traderName, long traderID, IconData icon) {
        this.trader = trader.m_5456_();
        this.traderName = traderName;
        this.traderID = traderID;
        this.traderIcon = icon == null ? IconData.Null() : icon;
    }

    public TraderCategory(CompoundTag compound) {
        this.trader = compound.m_128441_("Icon") ? (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(compound.m_128461_("Icon"))) : ModItems.TRADING_CORE.get();
        this.traderName = compound.m_128441_("TraderName") ? Component.Serializer.m_130701_((String)compound.m_128461_("TraderName")) : Component.m_237115_((String)"gui.lightmanscurrency.universaltrader.default");
        this.traderID = compound.m_128441_("TraderID") ? compound.m_128454_("TraderID") : -1L;
        this.traderIcon = compound.m_128441_("CustomIcon") ? IconData.load(compound.m_128469_("CustomIcon")) : IconData.Null();
    }

    @Override
    public IconData getIcon() {
        if (!this.traderIcon.isNull()) {
            return this.traderIcon;
        }
        return ItemIcon.ofItem((ItemLike)this.trader);
    }

    @Override
    public Component getName() {
        return this.traderName;
    }

    public NotificationCategoryType<TraderCategory> getType() {
        return TYPE;
    }

    @Override
    public boolean matches(NotificationCategory other) {
        if (other instanceof TraderCategory) {
            TraderCategory otherTrader = (TraderCategory)other;
            if (this.traderID >= 0L) {
                if (this.traderID == otherTrader.traderID) {
                    return true;
                }
            } else {
                return false;
            }
            return this.traderName.getString().contentEquals(otherTrader.traderName.getString()) && this.trader.equals(otherTrader.trader);
        }
        return false;
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Icon", ForgeRegistries.ITEMS.getKey((Object)this.trader).toString());
        compound.m_128359_("TraderName", Component.Serializer.m_130703_((Component)this.traderName));
        compound.m_128356_("TraderID", this.traderID);
        if (!this.traderIcon.isNull()) {
            compound.m_128365_("CustomIcon", (Tag)this.traderIcon.save());
        }
    }
}

