/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.CustomModelTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests.AndTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests.BlockEntityTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests.ConstantTest;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.custom_models.tests.OrTest;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CustomModelDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CustomModelDataManager INSTANCE = new CustomModelDataManager();
    private final Map<ResourceLocation, CustomModelData> data = new HashMap<ResourceLocation, CustomModelData>();

    private CustomModelDataManager() {
        super(GSON, "lightmanscurrency/custom_model_data");
        CustomModelTest.register(ConstantTest.TYPE, ConstantTest::parse);
        CustomModelTest.register(AndTest.TYPE, AndTest::parse);
        CustomModelTest.register(OrTest.TYPE, OrTest::parse);
        CustomModelTest.register(BlockEntityTest.TYPE, BlockEntityTest::parse);
    }

    @Nullable
    public static ModelResourceLocation getCustomModel(ItemTraderBlockEntity blockEntity, ItemStack item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        if (CustomModelDataManager.INSTANCE.data.containsKey(itemID)) {
            return CustomModelDataManager.INSTANCE.data.get(itemID).getCustomModel(blockEntity, item);
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller filler) {
        this.data.clear();
        map.forEach((id, json) -> {
            try {
                CustomModelData data = CustomModelData.read(GsonHelper.m_13918_((JsonElement)json, (String)"top element"));
                this.data.put((ResourceLocation)id, data);
            }
            catch (JsonSyntaxException | IllegalArgumentException | ResourceLocationException e) {
                LightmansCurrency.LogError("Parsing error loading custom model data " + id, e);
            }
        });
    }
}

