/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AuctionStorageClientTab
extends TraderStorageClientTab<AuctionStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 10;
    private static final int ROWS = 4;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    EasyButton buttonCollectItems;
    IconButton buttonCollectMoney;

    public AuctionStorageClientTab(Object screen, AuctionStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_AUCTION_STORAGE.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(193, 17))).height(72).scrollable(this).build());
        this.buttonCollectItems = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(11, 97))).pressAction(((AuctionStorageTab)this.commonTab)::quickTransfer)).sprite(SpriteUtil.BUTTON_QUICK_EXTRACT).build());
        this.buttonCollectMoney = this.addChild(((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(25, 118))).pressAction(((AuctionStorageTab)this.commonTab)::collectCoins)).icon(IconUtil.ICON_COLLECT_COINS).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 118)).listener(this).build());
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_TRADER_AUCTION_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            this.validateScroll();
            int index = this.scroll * 10;
            AuctionPlayerStorage storage = trader.getStorage(((ITraderStorageScreen)this.screen).getPlayer());
            if (storage != null) {
                List<ItemStack> storedItems = storage.getStoredItems();
                int hoverSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * 10;
                for (int y = 0; y < 4 && index < storedItems.size(); ++y) {
                    int yPos = 17 + y * 18;
                    for (int x = 0; x < 10 && index < storedItems.size(); ++index, ++x) {
                        int xPos = 13 + x * 18;
                        gui.resetColor();
                        SpriteUtil.EMPTY_SLOT_NORMAL.render(gui, xPos, yPos);
                        if (index < storedItems.size()) {
                            gui.renderItem(storedItems.get(index), xPos + 1, yPos + 1);
                        }
                        if (index != hoverSlot) continue;
                        gui.renderSlotHighlight(xPos + 1, yPos + 1);
                    }
                }
                if (storedItems.isEmpty()) {
                    TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_TRADER_AUCTION_STORAGE_ITEMS_NONE.get(new Object[0]), 10, ((ITraderStorageScreen)this.screen).getXSize() - 20, 49, 0x404040);
                }
                boolean bl = this.buttonCollectItems.f_93623_ = !storedItems.isEmpty();
                if (!storage.getStoredCoins().isEmpty()) {
                    this.buttonCollectMoney.f_93623_ = true;
                    gui.drawString((Component)LCText.GUI_TRADER_AUCTION_STORAGE_MONEY.get(storage.getStoredCoins().getRandomValueText()), 50, 118, 0x404040);
                } else {
                    this.buttonCollectMoney.f_93623_ = false;
                    gui.drawString((Component)LCText.GUI_TRADER_AUCTION_STORAGE_MONEY_NONE.get(new Object[0]), 50, 118, 0x404040);
                }
            }
        }
    }

    @Override
    public void renderAfterWidgets(EasyGuiGraphics gui) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionPlayerStorage storage;
            int hoveredSlot;
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            if (((ITraderStorageScreen)this.screen).getMenu().getHeldItem().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * 10) < (storage = ah.getStorage(((ITraderStorageScreen)this.screen).getPlayer())).getStoredItems().size()) {
                ItemStack stack = storage.getStoredItems().get(hoveredSlot);
                gui.renderComponentTooltip(EasyScreenHelper.getTooltipFromItem(stack));
            }
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17;
        for (int x = 0; x < 10 && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 4 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 10 + foundColumn;
    }

    private int totalStorageSlots() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            return ah.getStorage(((ITraderStorageScreen)this.screen).getPlayer()).getStoredItems().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (((ITraderStorageMenu)this.menu).getTrader() instanceof AuctionHouseTrader && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((AuctionStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 10, Screen.m_96638_());
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 10 - 4 + 1, 0);
    }

    @Override
    @Nullable
    public Pair<ItemStack, ScreenArea> getHoveredItem(ScreenPosition mousePos) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            AuctionPlayerStorage storage = trader.getStorage(((ITraderStorageMenu)this.menu).getPlayer());
            if (storage == null) {
                return null;
            }
            int foundColumn = -1;
            int foundRow = -1;
            int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
            int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17;
            for (int x = 0; x < 10 && foundColumn < 0; ++x) {
                if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
                foundColumn = x;
            }
            for (int y = 0; y < 4 && foundRow < 0; ++y) {
                if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
                foundRow = y;
            }
            if (foundColumn < 0 || foundRow < 0) {
                return null;
            }
            int slot = foundRow * 10 + foundColumn + this.scroll * 10;
            if (slot >= storage.getStoredItems().size()) {
                return null;
            }
            ItemStack stack = storage.getStoredItems().get(slot);
            return Pair.of((Object)stack, (Object)ScreenArea.of(leftEdge + foundColumn * 18, topEdge + foundRow * 18, 18, 18));
        }
        return null;
    }
}

