/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade;

import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TradeData
implements ITradeRuleHost {
    public static final String DEFAULT_KEY = "Trades";
    protected MoneyValue cost = MoneyValue.empty();
    List<TradeRule> rules = new ArrayList<TradeRule>();
    private final boolean validateRules;

    public abstract TradeDirection getTradeDirection();

    public void setTradeDirection(TradeDirection direction) {
    }

    public boolean validCost() {
        return this.getCost().isValidPrice();
    }

    public boolean isValid() {
        return this.validCost();
    }

    public MoneyValue getCost() {
        return this.cost;
    }

    public final MoneyValue getCost(TradeContext context) {
        if (!context.hasTrader() || !this.validCost()) {
            return this.getCost();
        }
        MoneyValue baseCost = TradeRule.getBaseCost(this, context);
        TradeEvent.TradeCostEvent event = context.getTrader().runTradeCostEvent(this, context, baseCost);
        return event.getCostResult();
    }

    public MoneyValue getCostWithTaxes(TraderData trader) {
        MoneyValue cost = TradeRule.getBaseCost(this, TradeContext.createStorageMode(trader));
        MoneyValue taxAmount = MoneyValue.empty();
        for (ITaxCollector entry : trader.getApplicableTaxes()) {
            taxAmount = taxAmount.addValue(cost.percentageOfValue(entry.getTaxRate()));
        }
        return Objects.requireNonNullElseGet(cost.addValue(taxAmount), MoneyValue::empty);
    }

    public MoneyValue getCostWithTaxes(TradeContext context) {
        MoneyValue cost = this.getCost(context);
        if (context.hasTrader()) {
            TraderData trader = context.getTrader();
            MoneyValue taxAmount = MoneyValue.empty();
            for (ITaxCollector entry : trader.getApplicableTaxes()) {
                taxAmount = taxAmount.addValue(cost.percentageOfValue(entry.getTaxRate()));
            }
            return cost.addValue(taxAmount);
        }
        return cost;
    }

    public void setCost(MoneyValue value) {
        this.cost = value;
    }

    public boolean outOfStock(TradeContext context) {
        return !this.hasStock(context);
    }

    public boolean hasStock(TradeContext context) {
        return this.getStock(context) > 0;
    }

    public abstract int getStock(TradeContext var1);

    public final int stockCountOfCost(TraderData trader) {
        if (this.getCost().isFree()) {
            return 1;
        }
        if (!this.getCost().isValidPrice()) {
            return 0;
        }
        MoneyValue storedMoney = trader.getStoredMoney().getStoredMoney().valueOf(this.getCost().getUniqueName());
        MoneyValue price = this.getCostWithTaxes(trader);
        if (!price.isValidPrice()) {
            return 0;
        }
        return (int)(storedMoney.getCoreValue() / price.getCoreValue());
    }

    public final int stockCountOfCost(TradeContext context) {
        if (!context.hasTrader()) {
            return 0;
        }
        TraderData trader = context.getTrader();
        if (this.getCost().isFree()) {
            return 1;
        }
        if (!this.getCost().isValidPrice()) {
            return 0;
        }
        MoneyValue storedMoney = trader.getStoredMoney().getStoredMoney().valueOf(this.getCost().getUniqueName());
        MoneyValue price = this.getCostWithTaxes(context);
        long stock = MathUtil.SafeDivide(storedMoney.getCoreValue(), price.getCoreValue(), 1L);
        if (stock > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)stock;
    }

    protected TradeData(boolean validateRules) {
        this.validateRules = validateRules;
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = new CompoundTag();
        tradeNBT.m_128365_("Price", (Tag)this.cost.save());
        TradeRule.saveRules(tradeNBT, this.rules, "RuleData");
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundTag nbt) {
        this.cost = MoneyValue.safeLoad(nbt, "Price");
        if (nbt.m_128441_("IsFree") && nbt.m_128471_("IsFree")) {
            this.cost = MoneyValue.free();
        }
        this.rules.clear();
        if (nbt.m_128441_("TradeRules")) {
            this.rules = TradeRule.loadRules(nbt, "TradeRules", this);
            for (TradeRule r : this.rules) {
                r.setActive(true);
            }
        } else {
            this.rules = TradeRule.loadRules(nbt, "RuleData", this);
        }
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    @Override
    public final boolean isTrader() {
        return false;
    }

    @Override
    public final boolean isTrade() {
        return true;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
    }

    @Override
    public List<TradeRule> getRules() {
        return new ArrayList<TradeRule>(this.rules);
    }

    @Override
    public void markTradeRulesDirty() {
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public abstract List<Component> GetDifferenceWarnings(TradeComparisonResult var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract TradeRenderManager<?> getButtonRenderer();

    public abstract void OnInputDisplayInteraction(BasicTradeEditTab var1, int var2, TradeInteractionData var3, ItemStack var4);

    public abstract void OnOutputDisplayInteraction(BasicTradeEditTab var1, int var2, TradeInteractionData var3, ItemStack var4);

    public abstract void OnInteraction(BasicTradeEditTab var1, TradeInteractionData var2, ItemStack var3);

    public final List<Integer> getRelevantInventorySlots(TradeContext context, List<Slot> slots) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.collectRelevantInventorySlots(context, slots, results);
        return results;
    }

    protected void collectRelevantInventorySlots(TradeContext context, List<Slot> slots, List<Integer> results) {
    }
}

