/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.event.handlers;

import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ExtraBlock;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.client.screens.ArchitectsCutterScreen;
import com.ldtteam.domumornamentum.container.ModContainerTypes;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="domum_ornamentum", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModBusEventHandler {
    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getTrapdoor().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:trapdoor_type"), (itemStack, clientLevel, livingEntity, i) -> {
            TrapdoorType trapdoorType;
            if (!itemStack.m_41784_().m_128441_("type")) {
                return 0.0f;
            }
            try {
                trapdoorType = TrapdoorType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
            }
            catch (Exception ex) {
                trapdoorType = TrapdoorType.FULL;
            }
            return trapdoorType.ordinal();
        }));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getDoor().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:door_type"), (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.handleDoorTypeOverride(itemStack)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getFancyDoor().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:door_type"), (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.handleFancyDoorTypeOverride(itemStack)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getFancyTrapdoor().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:trapdoor_type"), (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.handleFancyTrapdoorTypeOverride(itemStack)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getPanel().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:trapdoor_type"), (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.handleStaticTrapdoorTypeOverride(itemStack)));
        event.enqueueWork(() -> ItemProperties.register((Item)IModBlocks.getInstance().getPost().m_5456_(), (ResourceLocation)new ResourceLocation("domum_ornamentum:post_type"), (itemStack, clientLevel, livingEntity, i) -> ModBusEventHandler.handlePostTypeOverride(itemStack)));
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModContainerTypes.ARCHITECTS_CUTTER.get()), ArchitectsCutterScreen::new));
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getArchitectsCutter(), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getStandingBarrel(), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getLayingBarrel(), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getShingleSlab(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPaperWall(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFence(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFenceGate(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getSlab(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getStair(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getWall(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFancyDoor(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getFancyTrapdoor(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getTrapdoor(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getDoor(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPanel(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getPost(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getTiledPaperWall(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getDynamicTimberFrame(), (RenderType)RenderType.m_110466_());
            for (ShingleHeightType heightType : ShingleHeightType.values()) {
                ItemBlockRenderTypes.setRenderLayer((Block)IModBlocks.getInstance().getShingle(heightType), (RenderType)RenderType.m_110466_());
            }
            IModBlocks.getInstance().getFloatingCarpets().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
            IModBlocks.getInstance().getTimberFrames().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_()));
            IModBlocks.getInstance().getAllBrickBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110451_()));
            IModBlocks.getInstance().getExtraTopBlocks().forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)(((ExtraBlock)b).getType().isTranslucent() ? RenderType.m_110466_() : RenderType.m_110451_())));
        });
    }

    private static float handleDoorTypeOverride(ItemStack itemStack) {
        DoorType doorType;
        if (!itemStack.m_41784_().m_128441_("type")) {
            return 0.0f;
        }
        try {
            doorType = DoorType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
        }
        catch (Exception ex) {
            doorType = DoorType.FULL;
        }
        return doorType.ordinal();
    }

    private static float handleFancyDoorTypeOverride(ItemStack itemStack) {
        FancyDoorType doorType;
        if (!itemStack.m_41784_().m_128441_("type")) {
            return 0.0f;
        }
        try {
            doorType = FancyDoorType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
        }
        catch (Exception ex) {
            doorType = FancyDoorType.FULL;
        }
        return doorType.ordinal();
    }

    private static float handleFancyTrapdoorTypeOverride(ItemStack itemStack) {
        FancyTrapdoorType doorType;
        if (!itemStack.m_41784_().m_128441_("type")) {
            return 0.0f;
        }
        try {
            doorType = FancyTrapdoorType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
        }
        catch (Exception ex) {
            doorType = FancyTrapdoorType.FULL;
        }
        return doorType.ordinal();
    }

    private static float handleStaticTrapdoorTypeOverride(ItemStack itemStack) {
        TrapdoorType doorType;
        if (!itemStack.m_41784_().m_128441_("type")) {
            return 0.0f;
        }
        try {
            doorType = TrapdoorType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
        }
        catch (Exception ex) {
            doorType = TrapdoorType.FULL;
        }
        return doorType.ordinal();
    }

    private static float handlePostTypeOverride(ItemStack itemStack) {
        PostType postType;
        if (!itemStack.m_41784_().m_128441_("type")) {
            return 0.0f;
        }
        try {
            postType = PostType.valueOf(itemStack.m_41784_().m_128461_("type").toUpperCase());
        }
        catch (Exception ex) {
            postType = PostType.PLAIN;
        }
        return postType.ordinal();
    }
}

