/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.element.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.fragmentum.util.easing.EasingFunction;
import dev.obscuria.tooltips.client.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.particle.TooltipParticle;
import dev.obscuria.tooltips.client.renderer.ParticleData;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.RandomUtils;

public record InwardParticleEffect(TooltipParticle particle) implements TooltipEffect
{
    public static final Codec<InwardParticleEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TooltipParticle.CODEC.fieldOf("particle").forGetter(InwardParticleEffect::particle)).apply((Applicative)codec, InwardParticleEffect::new));

    public Codec<InwardParticleEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof InwardParticleEffect);
    }

    @Override
    public void renderBack(GuiGraphics graphics, TooltipContext context, int x, int y, int width, int height) {
        float lastParticleTime = 0.0f;
        for (ParticleData particle : context.particles()) {
            if (!particle.source.equals(this)) continue;
            particle.render(graphics, context, this.particle, x, y);
            lastParticleTime = Math.max(lastParticleTime, particle.startTime);
        }
        if (context.timeInSeconds() - lastParticleTime < 0.2f) {
            return;
        }
        int edge = RandomUtils.nextInt((int)1, (int)5);
        float ratio = RandomUtils.nextFloat((float)0.0f, (float)1.0f);
        Vec2 center = new Vec2((float)width * 0.5f, (float)height * 0.5f);
        Vec2 origin = switch (edge) {
            case 1 -> new Vec2((float)width * ratio, 0.0f);
            case 2 -> new Vec2((float)width * ratio, (float)height);
            case 3 -> new Vec2(0.0f, (float)height * ratio);
            case 4 -> new Vec2((float)width, (float)height * ratio);
            default -> Vec2.f_82462_;
        };
        context.addParticle(new InwardParticle(this, context.timeInSeconds(), origin, center));
    }

    private static final class InwardParticle
    extends ParticleData {
        public InwardParticle(Object source, float startTime, Vec2 origin, Vec2 destination) {
            super(source, startTime, origin, destination);
        }

        @Override
        public float computeProgress(TooltipContext context) {
            return Easing.EASE_OUT_CUBIC.compute(super.computeProgress(context));
        }

        @Override
        public Vec2 computeTranslation(TooltipContext context, float progress) {
            return super.computeTranslation(context, progress).m_165903_(0.4f);
        }

        @Override
        public float computeScale(TooltipContext context, float progress) {
            return Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_IN_CUBIC, 0.2f).compute(progress * 1.25f);
        }

        @Override
        public float computeRotation(TooltipContext context, float progress) {
            return (float)Math.atan2(this.destination.f_82471_ - this.origin.f_82471_, this.destination.f_82470_ - this.origin.f_82470_);
        }
    }
}

