/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.gui;

import dev.latvian.mods.itemfilters.api.IStringValueFilter;
import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import dev.latvian.mods.itemfilters.net.MessageUpdateFilterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class StringValueFilterScreen
extends Screen {
    public final IStringValueFilter filter;
    public final ItemStack stack;
    public final InteractionHand hand;
    private final Map<String, StringValueFilterVariant> variants;
    private final ArrayList<StringValueFilterVariant> visibleVariants;
    private EditBox nameField;
    private int selectedVariant = 0;

    public StringValueFilterScreen(IStringValueFilter f, ItemStack is, InteractionHand h) {
        super(is.m_41611_());
        this.filter = f;
        this.stack = is;
        this.hand = h;
        this.variants = new HashMap<String, StringValueFilterVariant>();
        for (StringValueFilterVariant variant : this.filter.getValueVariants(this.stack)) {
            this.variants.put(variant.id, variant);
        }
        this.visibleVariants = new ArrayList<StringValueFilterVariant>(this.variants.values());
        this.visibleVariants.sort(null);
    }

    public void m_7856_() {
        super.m_7856_();
        int i = this.f_96543_ / 2;
        int j = this.f_96544_ / 2;
        int w = this.f_96543_ * 3 / 4;
        this.nameField = new EditBox(this.f_96547_, i - w / 2, j - 6, w, 12, (Component)Component.m_237119_());
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94151_(this::updateVariants);
        this.nameField.m_94199_(4096);
        this.nameField.m_94144_(this.filter.getValue(this.stack));
        this.nameField.m_93692_(true);
        this.m_142416_((GuiEventListener)this.nameField);
    }

    private void updateVariants(String txt) {
        if (!this.variants.isEmpty()) {
            this.visibleVariants.clear();
            txt = this.nameField.m_94155_().toLowerCase();
            if (txt.isEmpty()) {
                this.visibleVariants.addAll(this.variants.values());
            } else {
                for (StringValueFilterVariant variant : this.variants.values()) {
                    if (!variant.id.toLowerCase().contains(txt) && !variant.title.getString().toLowerCase().contains(txt)) continue;
                    this.visibleVariants.add(variant);
                }
            }
            this.visibleVariants.sort(null);
            this.selectedVariant = 0;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String text = !this.variants.isEmpty() && !this.visibleVariants.isEmpty() && this.selectedVariant >= 0 && this.selectedVariant < this.visibleVariants.size() ? this.visibleVariants.get((int)this.selectedVariant).id : this.nameField.m_94155_();
            if (this.variants.isEmpty() || text.isEmpty() || this.variants.containsKey(text)) {
                ItemStack newStack = this.stack.m_41777_();
                this.filter.setValue(newStack, text);
                if (newStack.m_41782_() || text.isEmpty()) {
                    this.f_96541_.m_91152_(null);
                    StringValueFilterVariant variant = this.variants.get(text);
                    this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Value changed!"), text.isEmpty() ? null : (variant == null ? Component.m_237113_((String)text) : variant.title.m_6881_())));
                    this.f_96541_.f_91074_.m_21008_(this.hand, newStack);
                    new MessageUpdateFilterItem(this.hand, newStack).send();
                } else {
                    this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Invalid string!"), null));
                }
            } else {
                this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Invalid string!"), null));
            }
            return true;
        }
        if (keyCode == 258) {
            this.adjustSelected(!Screen.m_96638_());
            return true;
        }
        if (keyCode == 264) {
            this.adjustSelected(true);
            return true;
        }
        if (keyCode == 265) {
            this.adjustSelected(false);
            return true;
        }
        if (this.nameField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void adjustSelected(boolean forward) {
        this.selectedVariant += forward ? 1 : -1;
        if (this.selectedVariant < 0) {
            this.selectedVariant = this.visibleVariants.size() - 1;
        } else if (this.selectedVariant >= this.visibleVariants.size()) {
            this.selectedVariant = 0;
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.nameField.m_5534_(typedChar, keyCode)) {
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.nameField.m_94144_("");
        } else {
            this.nameField.m_6375_(mouseX, mouseY, mouseButton);
            this.nameField.m_93692_(true);
        }
        return true;
    }

    public boolean m_6050_(double d, double e, double delta) {
        this.adjustSelected(delta < 0.0);
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (!this.variants.isEmpty()) {
            int first;
            Objects.requireNonNull(this.f_96547_);
            int drawY = 4 + 9;
            Objects.requireNonNull(this.f_96547_);
            int nLines = (this.f_96544_ - drawY) / 9;
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"itemfilters.variants", (Object[])new Object[]{this.visibleVariants.size()}).m_130940_(ChatFormatting.AQUA), 4, 4, 0xFFFFFF, false);
            List lines = ComponentRenderUtils.m_94005_((FormattedText)Component.m_237115_((String)"itemfilters.help_text.variants").m_130940_(ChatFormatting.DARK_AQUA), (int)(this.f_96543_ / 2), (Font)this.f_96547_);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                int n = this.f_96543_ - this.f_96547_.m_92724_(line) - 4;
                Objects.requireNonNull(this.f_96547_);
                graphics.m_280649_(this.f_96547_, line, n, 4 + i * 9, -1, false);
            }
            for (int i = first = this.visibleVariants.size() < nLines ? 0 : Math.max(0, this.selectedVariant - nLines / 2); i < this.visibleVariants.size(); ++i) {
                Objects.requireNonNull(this.f_96547_);
                if (drawY >= this.f_96544_ - 9) break;
                StringValueFilterVariant variant = this.visibleVariants.get(i);
                graphics.m_280614_(this.f_96547_, variant.title, variant.icon.m_41619_() ? 4 : 14, drawY, i == this.selectedVariant ? 0xFFFF00 : 0xFFFFFF, false);
                if (!variant.icon.m_41619_()) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(4.0f, (float)drawY, 0.0f);
                    graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.0f);
                    graphics.m_280480_(variant.icon, 0, 0);
                    graphics.m_280370_(this.f_96547_, variant.icon, 0, 0);
                    graphics.m_280168_().m_85849_();
                }
                Objects.requireNonNull(this.f_96547_);
                drawY += 9;
            }
            this.nameField.m_252865_(this.f_96543_ / 2);
            this.nameField.m_93674_(this.f_96543_ / 3);
            MutableComponent mutableComponent = Component.m_237115_((String)"itemfilters.help_text.filter");
            int n = this.nameField.m_252754_();
            int n2 = this.nameField.m_252907_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280614_(this.f_96547_, (Component)mutableComponent, n, n2 - 9 - 2, -1, false);
        } else {
            int w = this.f_96543_ * 3 / 4;
            this.nameField.m_252865_((this.f_96543_ - w) / 2);
            this.nameField.m_93674_(w);
            Object lines = this.stack.m_41720_();
            if (lines instanceof StringValueFilterItem) {
                StringValueFilterItem filterItem = (StringValueFilterItem)lines;
                lines = ComponentRenderUtils.m_94005_((FormattedText)Component.m_237115_((String)filterItem.getHelpKey()), (int)this.nameField.m_5711_(), (Font)this.f_96547_);
                int n = this.nameField.m_252907_() - 3;
                Objects.requireNonNull(this.f_96547_);
                int textY = n - 9 * lines.size();
                int color = -1;
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    FormattedCharSequence line = (FormattedCharSequence)iterator.next();
                    graphics.m_280649_(this.f_96547_, line, this.nameField.m_252754_(), textY, color, false);
                    color = -6710887;
                    Objects.requireNonNull(this.f_96547_);
                    textY += 9;
                }
            }
        }
    }
}

