/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.google.common.collect.Lists;
import com.lootbeams.Configuration;
import com.lootbeams.LootBeams;
import com.lootbeams.ModClientEvents;
import com.lootbeams.VFXParticle;
import com.lootbeams.compat.ApotheosisCompat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class LootBeamRenderer
extends RenderType {
    public static final Map<ItemEntity, List<Component>> TOOLTIP_CACHE = new ConcurrentHashMap<ItemEntity, List<Component>>();
    public static final List<ItemEntity> LIGHT_CACHE = new ArrayList<ItemEntity>();
    private static final ResourceLocation LOOT_BEAM_TEXTURE = new ResourceLocation("lootbeams", "textures/entity/loot_beam.png");
    private static final ResourceLocation WHITE_TEXTURE = new ResourceLocation("lootbeams", "textures/entity/white.png");
    public static final ResourceLocation GLOW_TEXTURE = new ResourceLocation("lootbeams", "textures/entity/glow.png");
    private static final RenderType LOOT_BEAM_RENDERTYPE = (Boolean)Configuration.GLOWING_BEAM.get() != false ? RenderType.m_110502_() : LootBeamRenderer.createRenderType();
    private static final RenderType GLOW = (Boolean)Configuration.GLOWING_BEAM.get() != false ? RenderType.m_234338_((ResourceLocation)GLOW_TEXTURE) : RenderType.m_110452_((ResourceLocation)GLOW_TEXTURE);
    private static final Random RANDOM = new Random();

    public LootBeamRenderer(String name, VertexFormat format, VertexFormat.Mode mode, int size, boolean crumble, boolean sorting, Runnable enable, Runnable disable) {
        super(name, format, mode, size, crumble, sorting, enable, disable);
    }

    public static void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float pticks, long worldtime, ItemEntity item) {
        RenderSystem.enableDepthTest();
        float beamAlpha = ((Double)Configuration.BEAM_ALPHA.get()).floatValue();
        float entityTime = item.f_19797_;
        double distance = Minecraft.m_91087_().f_91074_.m_20280_((Entity)item);
        double fadeDistance = (Double)Configuration.BEAM_FADE_DISTANCE.get() * 4.0;
        if (distance < 3.0) {
            beamAlpha = (float)((double)beamAlpha * Math.max(0.0, distance - 4.0));
        } else if (distance > fadeDistance * 0.75) {
            float fade = (float)(distance - fadeDistance * 0.75);
            beamAlpha *= Math.max(0.0f, 1.0f - fade);
        }
        if (beamAlpha <= 0.01f) {
            return;
        }
        float beamRadius = 0.05f * ((Double)Configuration.BEAM_RADIUS.get()).floatValue();
        float glowRadius = beamRadius + beamRadius * 0.2f;
        float beamHeight = ((Double)Configuration.BEAM_HEIGHT.get()).floatValue();
        float yOffset = ((Double)Configuration.BEAM_Y_OFFSET.get()).floatValue();
        if (((Boolean)Configuration.COMMON_SHORTER_BEAM.get()).booleanValue() && !LootBeamRenderer.compatRarityCheck(item, false)) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        Color color = LootBeamRenderer.getItemColor(item);
        float R = (float)color.getRed() / 255.0f;
        float G = (float)color.getGreen() / 255.0f;
        float B = (float)color.getBlue() / 255.0f;
        stack.m_85836_();
        stack.m_85836_();
        float rotation = (float)Math.floorMod(worldtime, 40L) + pticks;
        stack.m_252781_(Axis.f_252436_.m_252977_(rotation * 2.25f - 45.0f));
        stack.m_252880_(0.0f, yOffset, 0.0f);
        stack.m_252880_(0.0f, 1.0f, 0.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, false);
        stack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, (Boolean)Configuration.SOLID_BEAM.get());
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252880_(0.0f, yOffset, 0.0f);
        stack.m_252880_(0.0f, 1.0f, 0.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius, false);
        stack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha * 0.4f, beamHeight, -glowRadius, -glowRadius, glowRadius, -glowRadius, -beamRadius, glowRadius, glowRadius, glowRadius, (Boolean)Configuration.SOLID_BEAM.get());
        stack.m_85849_();
        if (((Boolean)Configuration.WHITE_CENTER.get()).booleanValue()) {
            stack.m_85836_();
            stack.m_252880_(0.0f, yOffset, 0.0f);
            stack.m_252880_(0.0f, 1.0f, 0.0f);
            stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius * 0.4f, beamRadius * 0.4f, 0.0f, -beamRadius * 0.4f, 0.0f, 0.0f, -beamRadius * 0.4f, false);
            stack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            LootBeamRenderer.renderPart(stack, buffer.m_6299_(LOOT_BEAM_RENDERTYPE), R, G, B, beamAlpha, beamHeight, 0.0f, beamRadius * 0.4f, beamRadius * 0.4f, 0.0f, -beamRadius * 0.4f, 0.0f, 0.0f, -beamRadius * 0.4f, (Boolean)Configuration.SOLID_BEAM.get());
            stack.m_85849_();
        }
        if (((Boolean)Configuration.GLOW_EFFECT.get()).booleanValue() && item.m_20096_()) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.001f, 0.0f);
            float radius = ((Double)Configuration.GLOW_EFFECT_RADIUS.get()).floatValue();
            if (((Boolean)Configuration.ANIMATE_GLOW.get()).booleanValue()) {
                beamAlpha = (float)((double)beamAlpha * ((Math.abs(Math.cos((entityTime + pticks) / 10.0f)) * 0.5 + 0.5) * (double)1.3f));
                radius = (float)((double)radius * (Math.abs(Math.cos((entityTime + pticks) / 10.0f) * (double)0.45f) * 0.75 + 0.75));
            }
            LootBeamRenderer.renderGlow(stack, buffer.m_6299_(GLOW), R, G, B, beamAlpha * 0.4f, radius);
            stack.m_85849_();
        }
        stack.m_85849_();
        if (((Boolean)Configuration.RENDER_NAMETAGS.get()).booleanValue()) {
            LootBeamRenderer.renderNameTag(stack, buffer, item, color);
        }
        if (((Boolean)Configuration.PARTICLES.get()).booleanValue()) {
            if (!((Boolean)Configuration.PARTICLE_RARE_ONLY.get()).booleanValue()) {
                LootBeamRenderer.renderParticles(pticks, item, (int)entityTime, R, G, B);
            } else {
                boolean shouldRender = false;
                if (shouldRender = LootBeamRenderer.compatRarityCheck(item, shouldRender)) {
                    LootBeamRenderer.renderParticles(pticks, item, (int)entityTime, R, G, B);
                }
            }
        }
        RenderSystem.disableDepthTest();
    }

    static boolean compatRarityCheck(ItemEntity item, boolean shouldRender) {
        if (ModList.get().isLoaded("apotheosis")) {
            if (ApotheosisCompat.isApotheosisItem(item.m_32055_())) {
                shouldRender = !ApotheosisCompat.getRarityName(item.m_32055_()).contains("apotheosis:common") || item.m_32055_().m_41791_() != Rarity.COMMON;
            } else if (item.m_32055_().m_41791_() != Rarity.COMMON) {
                shouldRender = true;
            }
        } else if (item.m_32055_().m_41791_() != Rarity.COMMON) {
            shouldRender = true;
        }
        return shouldRender;
    }

    private static void renderParticles(float pticks, ItemEntity item, int entityTime, float r, float g, float b) {
        float particleCount = Math.abs(20.0f - ((Double)Configuration.PARTICLE_COUNT.get()).floatValue());
        if ((float)entityTime % particleCount == 0.0f && pticks < 0.3f && !Minecraft.m_91087_().m_91104_()) {
            Vec3 randomDir = new Vec3(RANDOM.nextDouble(-((Double)Configuration.PARTICLE_SPEED.get()).doubleValue() / 2.0, (Double)Configuration.PARTICLE_SPEED.get() / 2.0), RANDOM.nextDouble((Double)Configuration.PARTICLE_SPEED.get() / 2.0, (Double)Configuration.PARTICLE_SPEED.get()), RANDOM.nextDouble(-((Double)Configuration.PARTICLE_SPEED.get()).doubleValue() / 2.0, (Double)Configuration.PARTICLE_SPEED.get() / 2.0)).m_82542_(((Double)Configuration.RANDOMNESS_INTENSITY.get()).doubleValue(), ((Double)Configuration.RANDOMNESS_INTENSITY.get()).doubleValue(), ((Double)Configuration.RANDOMNESS_INTENSITY.get()).doubleValue());
            Vec3 particleDir = new Vec3(((Double)Configuration.PARTICLE_DIRECTION_X.get()).doubleValue(), ((Double)Configuration.PARTICLE_DIRECTION_Y.get()).doubleValue(), ((Double)Configuration.PARTICLE_DIRECTION_Z.get()).doubleValue()).m_82559_(randomDir);
            LootBeamRenderer.addParticle(ModClientEvents.GLOW_TEXTURE, r, g, b, 1.0f, (Integer)Configuration.PARTICLE_LIFETIME.get(), RANDOM.nextFloat((float)(0.25 * (Double)Configuration.PARTICLE_SIZE.get()), (float)((double)1.1f * (Double)Configuration.PARTICLE_SIZE.get())), new Vec3(RANDOM.nextDouble(item.m_20185_() - (Double)Configuration.PARTICLE_RADIUS.get(), item.m_20185_() + (Double)Configuration.PARTICLE_RADIUS.get()), RANDOM.nextDouble(item.m_20186_() - (Double)Configuration.PARTICLE_RADIUS.get() / 3.0, item.m_20186_() + (Double)Configuration.PARTICLE_RADIUS.get() / 3.0), RANDOM.nextDouble(item.m_20189_() - (Double)Configuration.PARTICLE_RADIUS.get(), item.m_20189_() + (Double)Configuration.PARTICLE_RADIUS.get())), particleDir, item.m_20182_());
        }
    }

    private static double pulse(float entityTime, float max) {
        double val = Math.cos(entityTime / 10.0f) * 0.5 + 0.5;
        return Mth.m_14139_((double)val, (double)0.25, (double)max);
    }

    private static void addParticle(ResourceLocation spriteLocation, float red, float green, float blue, float alpha, int lifetime, float size, Vec3 pos, Vec3 motion, Vec3 sourcePos) {
        Minecraft mc = Minecraft.m_91087_();
        VFXParticle provider = new VFXParticle(mc.f_91073_, mc.f_91061_.f_107296_.m_118316_(spriteLocation), red, green, blue, alpha *= 1.5f, lifetime, size, pos, motion, 0.0f, false, true);
        provider.setParticleCenter(sourcePos);
        mc.f_91061_.m_107344_((Particle)provider);
    }

    private static void renderGlow(PoseStack stack, VertexConsumer builder, float red, float green, float blue, float alpha, float radius) {
        PoseStack.Pose matrixentry = stack.m_85850_();
        Matrix4f matrixpose = matrixentry.m_252922_();
        Matrix3f matrixnormal = matrixentry.m_252943_();
        builder.m_252986_(matrixpose, -radius, 0.0f, -radius).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, -radius, 0.0f, radius).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, radius, 0.0f, radius).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, radius, 0.0f, -radius).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void renderNameTag(PoseStack stack, MultiBufferSource buffer, ItemEntity item, Color color) {
        if (((Boolean)Configuration.ADVANCED_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_.m_6047_() || ((Boolean)Configuration.RENDER_NAMETAGS_ONLOOK.get()).booleanValue() && LootBeamRenderer.isLookingAt(Minecraft.m_91087_().f_91074_, (Entity)item, (Double)Configuration.NAMETAG_LOOK_SENSITIVITY.get())) {
            List tooltip;
            int count;
            float foregroundAlpha = ((Double)Configuration.NAMETAG_TEXT_ALPHA.get()).floatValue();
            float backgroundAlpha = ((Double)Configuration.NAMETAG_BACKGROUND_ALPHA.get()).floatValue();
            double yOffset = (Double)Configuration.NAMETAG_Y_OFFSET.get();
            int foregroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
            int backgroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
            stack.m_85836_();
            stack.m_85837_(0.0, Math.min(1.0, Minecraft.m_91087_().f_91074_.m_20280_((Entity)item) * 0.025) + yOffset, 0.0);
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            float nametagScale = ((Double)Configuration.NAMETAG_SCALE.get()).floatValue();
            stack.m_85841_(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            Object itemName = StringUtil.m_14406_((String)item.m_32055_().m_41786_().getString());
            if (((Boolean)Configuration.RENDER_STACKCOUNT.get()).booleanValue() && (count = item.m_32055_().m_41613_()) > 1) {
                itemName = (String)itemName + " x" + count;
            }
            stack.m_252880_(0.0f, 0.0f, -10.0f);
            LootBeamRenderer.renderText(fontrenderer, stack, buffer, (String)itemName, foregroundColor, backgroundColor, backgroundAlpha);
            stack.m_85837_(0.0, 10.0, 0.0);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            boolean textDrawn = false;
            if (!TOOLTIP_CACHE.containsKey(item)) {
                tooltip = item.m_32055_().m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_);
                TOOLTIP_CACHE.put(item, tooltip);
            } else {
                tooltip = TOOLTIP_CACHE.get(item);
            }
            if (tooltip.size() >= 2 && ((Boolean)Configuration.RENDER_RARITY.get()).booleanValue()) {
                Color rarityColor;
                Component tooltipRarity = (Component)tooltip.get(1);
                if (((Boolean)Configuration.DMCLOOT_COMPAT_RARITY.get()).booleanValue() && ModList.get().isLoaded("dmcloot") && item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_("dmcloot.rarity")) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    MutableComponent translatedRarity = Component.m_237115_((String)("rarity.dmcloot." + item.m_32055_().m_41783_().m_128461_("dmcloot.rarity")));
                    LootBeamRenderer.renderText(fontrenderer, stack, buffer, translatedRarity.getString(), rarityColor.getRGB(), backgroundColor, backgroundAlpha);
                    textDrawn = true;
                }
                if (!textDrawn && ((List)Configuration.CUSTOM_RARITIES.get()).contains(tooltipRarity.getString())) {
                    rarityColor = (Boolean)Configuration.WHITE_RARITIES.get() != false ? Color.WHITE : LootBeamRenderer.getRawColor(tooltipRarity);
                    foregroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
                    backgroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
                    LootBeamRenderer.renderText(fontrenderer, stack, buffer, tooltipRarity.getString(), foregroundColor, backgroundColor, backgroundAlpha);
                }
            }
            if (!textDrawn && ((Boolean)Configuration.VANILLA_RARITIES.get()).booleanValue()) {
                Color rarityColor = LootBeamRenderer.getRawColor((Component)tooltip.get(0));
                foregroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * foregroundAlpha)).getRGB();
                backgroundColor = new Color(rarityColor.getRed(), rarityColor.getGreen(), rarityColor.getBlue(), (int)(255.0f * backgroundAlpha)).getRGB();
                LootBeamRenderer.renderText(fontrenderer, stack, buffer, LootBeamRenderer.getRarity(item.m_32055_()), foregroundColor, backgroundColor, backgroundAlpha);
            }
            stack.m_85849_();
        }
    }

    public static String getRarity(ItemStack stack) {
        String rarity = stack.m_41791_().name().toLowerCase();
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompat.isApotheosisItem(stack)) {
            rarity = ApotheosisCompat.getRarityName(stack);
        }
        if (I18n.m_118936_((String)(rarity = rarity.replace(":", ".").replace("_", ".")))) {
            return I18n.m_118938_((String)rarity, (Object[])new Object[0]);
        }
        return rarity;
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static void renderText(Font fontRenderer, PoseStack stack, MultiBufferSource buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (((Boolean)Configuration.BORDERS.get()).booleanValue()) {
            float w = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            MutableComponent comp = Component.m_237113_((String)text);
            fontRenderer.m_168645_(comp.m_7532_(), w, 0.0f, foregroundColor, bg, stack.m_85850_().m_252922_(), buffer, 0xF000F0);
        } else {
            fontRenderer.m_271703_(text, (float)(-fontRenderer.m_92895_(text) / 2), 0.0f, foregroundColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, backgroundColor, 0xF000E0);
        }
    }

    private static Color getItemColor(ItemEntity item) {
        if (LootBeams.CRASH_BLACKLIST.contains(item.m_32055_())) {
            return Color.WHITE;
        }
        try {
            Color nameColor;
            Color override = Configuration.getColorFromItemOverrides(item.m_32055_().m_41720_());
            if (override != null) {
                return override;
            }
            if (item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_("lootbeams.color")) {
                return Color.decode(item.m_32055_().m_41783_().m_128461_("lootbeams.color"));
            }
            if (((Boolean)Configuration.RENDER_NAME_COLOR.get()).booleanValue() && !(nameColor = LootBeamRenderer.getRawColor(item.m_32055_().m_41786_())).equals(Color.WHITE)) {
                return nameColor;
            }
            if (((Boolean)Configuration.RENDER_RARITY_COLOR.get()).booleanValue() && ((Style)item.m_32055_().m_41791_().getStyleModifier().apply(Style.f_131099_)).m_131135_() != null) {
                return new Color(((Style)item.m_32055_().m_41791_().getStyleModifier().apply(Style.f_131099_)).m_131135_().m_131265_());
            }
            return Color.WHITE;
        }
        catch (Exception e) {
            LootBeams.LOGGER.error("Failed to get color for (" + item.m_32055_().m_41611_() + "), added to temporary blacklist");
            LootBeams.CRASH_BLACKLIST.add(item.m_32055_());
            LootBeams.LOGGER.info("Temporary blacklist is now : ");
            for (ItemStack s : LootBeams.CRASH_BLACKLIST) {
                LootBeams.LOGGER.info((Object)s.m_41611_());
            }
            return Color.WHITE;
        }
    }

    private static Color getRawColor(Component text) {
        ArrayList list = Lists.newArrayList();
        text.m_7451_((acceptor, styleIn) -> {
            StringDecomposer.m_14346_((String)styleIn, (Style)acceptor, (string, style, consumer) -> {
                list.add(style);
                return true;
            });
            return Optional.empty();
        }, Style.f_131099_);
        if (((Style)list.get(0)).m_131135_() != null) {
            return new Color(((Style)list.get(0)).m_131135_().m_131265_());
        }
        return Color.WHITE;
    }

    private static void renderPart(PoseStack stack, VertexConsumer builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8, boolean gradient) {
        if (gradient) {
            LootBeamRenderer.renderGradientPart(stack, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        } else {
            LootBeamRenderer.renderPart(stack, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4, radius_5, radius_6, radius_7, radius_8);
        }
    }

    private static void renderPart(PoseStack stack, VertexConsumer builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        PoseStack.Pose matrixentry = stack.m_85850_();
        Matrix4f matrixpose = matrixentry.m_252922_();
        Matrix3f matrixnormal = matrixentry.m_252943_();
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderGradientPart(PoseStack stack, VertexConsumer builder, float red, float green, float blue, float alpha, float height, float radius_1, float radius_2, float radius_3, float radius_4, float radius_5, float radius_6, float radius_7, float radius_8) {
        PoseStack.Pose matrixentry = stack.m_85850_();
        Matrix4f matrixpose = matrixentry.m_252922_();
        Matrix3f matrixnormal = matrixentry.m_252943_();
        LootBeamRenderer.renderUpwardsGradientQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_1, radius_2, radius_3, radius_4);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_7, radius_8, radius_5, radius_6);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_3, radius_4, radius_7, radius_8);
        LootBeamRenderer.renderUpwardsGradientQuad(matrixpose, matrixnormal, builder, red, green, blue, alpha, height, radius_5, radius_6, radius_1, radius_2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float red, float green, float blue, float alpha, float y, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, y, z, texu, 0.0f, 0.0f);
    }

    private static void renderUpwardsGradientQuad(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float red, float green, float blue, float alpha, float y, float z1, float texu1, float z, float texu) {
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, 0.0f, y, z1, texu1, 1.0f, 0.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z1, texu1, 1.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, alpha, 0.0f, z, texu, 0.0f, 1.0f);
        LootBeamRenderer.addVertex(pose, normal, builder, red, green, blue, 0.0f, y, z, texu, 0.0f, 0.0f);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float red, float green, float blue, float alpha, float y, float x, float z, float texu, float texv) {
        builder.m_252986_(pose, x, y, z).m_85950_(red, green, blue, alpha).m_7421_(texu, texv).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static RenderType createRenderType() {
        ResourceLocation texture = (Boolean)Configuration.SOLID_BEAM.get() == false ? LOOT_BEAM_TEXTURE : WHITE_TEXTURE;
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173068_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110687_(f_110115_).m_110691_(false);
        return RenderType.m_173215_((String)"loot_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    private static boolean isLookingAt(LocalPlayer player, Entity target, double accuracy) {
        Vec3 difference = new Vec3(target.m_20185_() - player.m_20185_(), target.m_20188_() - player.m_20188_(), target.m_20189_() - player.m_20189_());
        double length = difference.m_82553_();
        double dot = Minecraft.m_91087_().m_91288_().m_20154_().m_82541_().m_82526_(difference.m_82541_());
        return dot > 1.0 - accuracy / length && !target.m_20145_();
    }
}

