/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item;

import com.tacz.guns.api.item.IAnimationItem;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.xjqsh.lrtactical.api.item.IThrowable;
import me.xjqsh.lrtactical.capability.CustomItemCoolDownsProvider;
import me.xjqsh.lrtactical.client.renderer.item.ThrowableItemRendererWrapper;
import me.xjqsh.lrtactical.entity.ThrowableItemEntity;
import me.xjqsh.lrtactical.item.index.ThrowableIndex;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import me.xjqsh.lrtactical.item.throwable.area.EffectCloudThrowableData;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowableItem
extends Item
implements IAnimationItem,
IThrowable {
    public ThrowableItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getThrowableIndex(stack).map(ThrowableIndex::getMaxStackSize).orElse(1);
    }

    @ParametersAreNonnullByDefault
    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ThrowableItemRendererWrapper renderer = null;

            public ThrowableItemRendererWrapper getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ThrowableItemRendererWrapper();
                }
                return this.renderer;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void triggerAnimation(ItemStack stack, String animationName) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)blockEntityWithoutLevelRenderer;
            renderer.triggerAnimation(stack, animationName);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pUsedHand) {
        if (pUsedHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(pUsedHand));
        }
        ItemStack stack = player.m_21120_(pUsedHand);
        boolean flag = this.getThrowableIndex(stack).map(index -> ((ThrowableData)index.getData()).getCooldownCategory()).map(id -> player.getCapability(CustomItemCoolDownsProvider.CAPABILITY).map(cap -> cap.isOnCooldown((ResourceLocation)id)).orElse(false)).orElse(false);
        if (!flag) {
            player.m_6672_(pUsedHand);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void onThrow(Level world, LivingEntity entity, ItemStack stack, ThrowableIndex<?, ?> index) {
        Object throwable = index.createEntity(stack, entity);
        if (((ThrowableData)index.getData()).isCookable()) {
            int newLife = ((ThrowableItemEntity)((Object)throwable)).getLife() - (entity.m_21252_() - ((ThrowableData)index.getData()).getPrepareTime());
            newLife = Math.max(newLife, 0);
            ((ThrowableItemEntity)((Object)throwable)).setLife(newLife);
        }
        world.m_7967_(throwable);
        ResourceLocation id = ((ThrowableData)index.getData()).getCooldownCategory();
        if (id != null) {
            entity.getCapability(CustomItemCoolDownsProvider.CAPABILITY).ifPresent(cap -> cap.addCooldown(id, ((ThrowableData)index.getData()).getCooldown()));
        }
        stack.m_41774_(1);
    }

    @ParametersAreNonnullByDefault
    public void m_5929_(Level world, LivingEntity entity, ItemStack stack, int pRemainingUseDuration) {
        this.getThrowableIndex(stack).ifPresent(index -> {
            Object data = index.getData();
            if (((ThrowableData)data).isCookable() && entity.m_21252_() >= ((ThrowableData)data).getPrepareTime() + ((ThrowableData)data).getEntityData().getLifeTime() && !world.m_5776_()) {
                this.onThrow(world, entity, stack, (ThrowableIndex<?, ?>)index);
                entity.m_5810_();
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        this.getThrowableIndex(stack).ifPresent(index -> {
            if (entity.m_21252_() >= ((ThrowableData)index.getData()).getPrepareTime() && !world.m_5776_()) {
                this.onThrow(world, entity, stack, (ThrowableIndex<?, ?>)index);
            }
        });
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
    }

    public boolean m_41463_(@NotNull ItemStack pStack) {
        return true;
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack stack) {
        return this.getThrowableIndex(stack).map(ThrowableIndex::getDescriptionId).orElse(super.m_5671_(stack));
    }

    @Override
    public boolean isSame(ItemStack stack1, ItemStack stack2) {
        return IThrowable.super.isSame(stack1, stack2);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.getThrowableIndex(stack).ifPresent(index -> {
            Object patt6665$temp = index.getData();
            if (patt6665$temp instanceof EffectCloudThrowableData) {
                EffectCloudThrowableData data = (EffectCloudThrowableData)patt6665$temp;
                PotionUtils.m_257410_(data.getCloudData().getEffectInstances(), (List)pTooltipComponents, (float)1.0f);
            }
        });
    }
}

